@extends('layouts.app')

@section('javascript')

        <!-- Flot Charts -->
<script>

    $(function () {

        /**
         * Flot charts data and options
         */
       // var data1 = [[0, 55], [1, 48], [2, 40], [3, 36], [4, 40], [5, 60], [6, 50], [7, 51]];
        var data1 = {!! json_encode($totalSubscribedUsers) !!};
        var chartUsersOptions = {
            series: {
                splines: {
                    show: true,
                    tension: 0,
                    lineWidth: 1,
                    fill: 0.4
                },
            },
            yaxis: {
                minTickSize: 1,
                tickDecimals: 0
            },
            xaxis: { ticks: {!! json_encode($generateAxisTicks, true)!!} },
            grid: {
                tickColor: "#f0f0f0",
                borderWidth: 1,
                borderColor: 'f0f0f0',
                color: '#6a6c6f'
            },
            colors: ["#62cb31", "#efefef"],
        };

        $.plot($("#flot-line-chart"), [data1], chartUsersOptions);

        /**
         * Flot charts 2 data and options
         */


        var chartIncomeOptions = {
            series: {
                splines: {
                    show: true,
                    tension: 0.4,
                    lineWidth: 1,
                    fill: 0.4
                },
            },
            yaxis: {
                minTickSize: 1,
                tickDecimals: 0
            },
            xaxis: { ticks: {!! json_encode($generateAxisTicks, true)!!} },
            grid: {
                tickColor: "#f0f0f0",
                borderWidth: 1,
                borderColor: 'f0f0f0',
                color: '#6a6c6f'
            },
            colors: ["#62cb31", "#efefef"],
        };

        $.plot($("#flot-income-chart"),  [{!! json_encode($totalUserSignups) !!}], chartIncomeOptions);

    });

    $(document).ready(function () {
        $('.table-data-full').DataTable({
            //dom: '<"html5buttons"B>lTfgitp',
            dom: '<"html5buttons"B>Tgitp',
            bPaginate: false,
            buttons: [
                {extend: 'copy'},
                {extend: 'csv'},
                {extend: 'excel', title: 'ExampleFile'},
                {extend: 'pdf', title: 'ExampleFile'},

                {
                    extend: 'print',
                    customize: function (win) {
                        $(win.document.body).addClass('white-bg');
                        $(win.document.body).css('font-size', '10px');

                        $(win.document.body).find('table')
                                .addClass('compact')
                                .css('font-size', 'inherit');
                    }
                }
            ]
        });
    });

</script>
@endsection

@section('content')
    <div class="row">
        <div class="col-lg-12 text-center m-t-md">
            <h2><img src="img/logo-320.png" class="inline-logo-h2" alt="To Start Work"/> Admin Portal</h2>
        </div>
    </div><!-- /.row -->

    <div class="margin-50"></div>

    <div class="text-center">
        <h2>User Acquisition</h2>
    </div>

    <div class="hpanel">
        <div class="panel-body">

            <div class="text-center small">
                <i class="fa fa-mobile"></i> Total Subscribed users (12 Month Overview)
            </div>
            <div class="flot-chart" style="height: 160px">
                <div class="flot-chart-content" id="flot-line-chart"></div>
            </div>

        </div>
    </div><!-- /.hpanel -->

    <div class="hpanel">
        <div class="panel-body">

            <div class="text-center small">
                <i class="fa fa-mobile"></i> New Users Per Month (12 Month Overview)
            </div>
            <div class="flot-chart" style="height: 160px">
                <div class="flot-chart-content" id="flot-income-chart"></div>
            </div>

        </div>
    </div><!-- /.hpanel -->
@endsection
