@extends('layouts.app')

@section('javascript')


    <!-- Datatables -->
    <script>

        $(document).ready(function(){
            $('#table-categories').DataTable({
                //dom: '<"html5buttons"B>lTfgitp',
                dom: '<"html5buttons"B>fgitp',
                bPaginate: true,
                "columnDefs": [
                    { "orderable": false, "targets": [2] }
                ],
                "aaSorting": [],
            });
        });

    </script>

    <!-- Sweet Alert -->
    <script src="/vendor/sweetalert/lib/sweet-alert.min.js"></script>
    <script>
        $('.create-category').click(function (e) {
            console.log(e);
            e.preventDefault();
            swal({
                title: 'Add A Category',
                type: 'input',
                showCancelButton: true,
                closeOnConfirm: false,
                inputPlaceholder: 'Category Name',

            }, function (inputValue) {
                if (inputValue === false) return false;

                if (inputValue === "") {
                    swal.showInputError("You need to write something!");
                    return false
                }
                console.log(inputValue);
                $.ajax({
                    url: "{{route('categories.store')}}",
                    type: 'POST',
                    data: {_token: '{{ csrf_token() }}', name: inputValue},
                    success: function () {
                        window.location = "{{route('categories.index')}}"
                    }
                })
            });
        });

        $('.edit-category').click(function (e) {
            var category = JSON.parse($(e.target).attr('data-category'));

            e.preventDefault();

            swal({
                title: 'Add A Category',
                type: 'input',
                showCancelButton: true,
                closeOnConfirm: false,
                inputPlaceholder: 'Category Name',
                inputValue: category.name

            }, function (inputValue) {
                if (inputValue === false) return false;

                if (inputValue === "") {
                    swal.showInputError("You need to write something!");
                    return false
                }
                console.log(inputValue);
                $.ajax({
                    url: e.target.href,
                    type: 'PUT',
                    data: {_token: '{{ csrf_token() }}', name: inputValue},
                    success: function () {
                        swal({
                            title: 'Updated',
                            text: "Category successfully updated",
                            type: 'success',
                            confirmButtonColor: 'rgb(120, 182, 211)',
                            confirmButtonText: 'OK'
                        }, function () {
                            window.location = "{{route('categories.index')}}"
                        });
                    }
                })
            });
        });

        $('.delete-category').click(function (e) {
            e.preventDefault();
            swal({
                title: 'Confirm',
                text: "Please confirm you want to delete this category",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: 'rgb(168, 67, 23)',
                confirmButtonText: 'Yes, delete it!',
                showLoaderOnConfirm: true

            }, function () {
                    $.ajax({
                        url: e.target.href,
                        type: 'delete',
                        data: {_token: '{{ csrf_token() }}'},
                        success: function () {
                            swal({
                                title: 'Deleted!',
                                text: "Course successfully deleted",
                                type: 'success',
                                confirmButtonColor: 'rgb(120, 182, 211)',
                                confirmButtonText: 'OK'
                            }, function () {
                                window.location = "{{route('categories.index')}}"
                            });
                        }
                    })

            });
        });
    </script>
@endsection

@section('content')
    <div class="normalheader transition animated fadeIn">
        <div class="hpanel">
            <div class="panel-body">
                <div class="row">
                    <div class="col-sm-12 col-md-8 col-lg-9">
                        <h2 class="font-light m-b-xs">
                            Course Categories
                        </h2>
                    </div>
                    <div class="col-sm-12 col-md-4 col-lg-3">
                        <a class="btn btn-success btn-block edit-category form-btn-no-label"><i class="fa fa-plus"></i> New Category</a>
                    </div>
                </div><!-- /.row -->
            </div>
        </div>
    </div>

    <div class="content">

        <div class="hpanel">
            <div class="panel-body">

                <div class="table-responsive">
                    <table id="table-categories" class="table table-striped table-bordered table-hover" >
                        <thead>
                        <tr>
                            <th>Category Name</th>
                            <th>Course Count</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($categories as $category)
                            <tr>
                                <td>{{$category->name}}</td>
                                <td>{{count($category->courses)}}</td>
                                <td>
                                    <a href="{{route('categories.update', [$category->id])}}" data-category="{{$category->toJson()}}" class="btn btn-primary btn-sm alert-category-edit edit-category"><i class="fa fa-pencil"></i>Edit</a>
                                    <a href="{{route('categories.destroy', [$category->id])}}" class="btn btn-danger btn-sm alert-category-delete delete-category"><i class="fa fa-close"></i>Delete</a>
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>

                </div><!-- /.table-responsive -->

            </div>
        </div><!-- /.hpanel -->

    </div><!-- /.content -->


@endsection
