<?php

use Carbon\Carbon;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // $this->call(UsersTableSeeder::class);

        \ToStartWork\User::create([
            'email' => 'jason@codium.com.au',
            'password' => bcrypt('123'),
            'is_admin' => true,
            'ios_device_token' => '75bd23fd570463b3d162b40ba9ce629f871712c26ed3a65902d7a8923222f03d'
        ]);

        $startDate = Carbon::now()->subMonths(12);

        //Setup fake users over last 12 months
        for ($i=0;$i<=11;$i++) {
            factory(\ToStartWork\User::class, rand(0,10))->create();
            Carbon::setTestNow($startDate->addMonth());
        }

        Carbon::setTestNow();

        \ToStartWork\QualificationTradeType::create(['name' => 'Plumbing']);
        \ToStartWork\QualificationTradeType::create(['name' => 'Electrician']);
        \ToStartWork\QualificationTradeType::create(['name' => 'Brick Laying']);
        \ToStartWork\QualificationTradeType::create(['name' => 'Tile Laying']);
        \ToStartWork\QualificationTradeType::create(['name' => 'Carpenter']);
        \ToStartWork\QualificationTradeType::create(['name' => 'Builder']);

        \ToStartWork\QualificationType::create(['name' => 'Induction']);
        \ToStartWork\QualificationType::create(['name' => 'Ticket']);
        \ToStartWork\QualificationType::create(['name' => 'License']);
        \ToStartWork\QualificationType::create(['name' => 'Certificate']);

        \ToStartWork\Qualification::create(['name' => 'Cert 4 Plumbing', 'type_id' => 4, 'trade_type_id' => 1]);
        \ToStartWork\Qualification::create(['name' => 'Plumbing Induction', 'type_id' => 1, 'trade_type_id' => 1]);
        \ToStartWork\Qualification::create(['name' => 'Plumbing License', 'type_id' => 3, 'trade_type_id' => 1]);

        factory(ToStartWork\Notification::class, 1000)->create(['sent' => Carbon::now()]);

        factory(ToStartWork\Course::class, 20)->create();
    }
}
