<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class AddIsApprovedToQualificationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('qualifications', function (Blueprint $table) {
            $table->boolean('is_approved')->default(false)->nullable();
            $table->integer('user_id')->unsigned()->nullable();
            $table->foreign('user_id')->references('id')->on('users');
        });

        DB::statement('ALTER TABLE `qualifications` MODIFY `trade_type_id` int(10) unsigned NULL');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('qualification_user', function (Blueprint $table) {
            $table->dropColumn('is_approved');
            $table->dropColumn('user_id');
        });

        DB::statement('ALTER TABLE `qualifications` MODIFY `trade_type_id` int(10) unsigned NOT NULL');
    }
}
