<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCoursesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('courses', function(Blueprint $table) {
            $table->increments('id');

            $table->integer('category_id')->unsigned();
            $table->foreign('category_id')->references('id')->on('course_categories');

            $table->integer('provider_id')->unsigned();
            $table->foreign('provider_id')->references('id')->on('course_providers');

            $table->string('name')->nullable();
            $table->date('enroll_date')->nullable();
            $table->double('price')->default(0);
            $table->double('citb_price')->default(0);
            $table->text('description')->nullable();
            $table->string('location')->nullable();
            $table->string('provider')->nullable();
            $table->boolean('recommended')->default(false);
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('courses');
    }
}
