<?php namespace ToStartWork\Http\Transformers;

class UserQualificationTransformer
{
    public function transform($qualifications)
    {
        return $qualifications->transform(function($qualification) {
            return [
                'country' => $qualification->pivot->country,
                'state' => $qualification->pivot->state,
                'ref_no' => $qualification->pivot->ref_no,
                'issue_date' => $qualification->pivot->issue_date,
                'expiry_date' => $qualification->pivot->expiry_date,
                'front_image_url'=> $qualification->pivot->front_image,
                'back_image_url' => $qualification->pivot->back_image,
                'trade_type_id' => intval($qualification->trade_type_id),
                'type_id' => intval($qualification->type_id),
                'name' => $qualification->name,
                'id' => $qualification->id
            ];
        });
    }
}