<?php

namespace ToStartWork\Http\Controllers;

use Illuminate\Http\Request;
use ToStartWork\Qualification;

class QualificationController extends Controller
{
    public function index()
    {
        $qualifications = Qualification::where('status', '<>', Qualification::ARCHIVED)->orderBy('id', 'desc')->get();

        return view('qualification.index', compact('qualifications'));
    }

    public function numOfUnapproved()
    {
        return response()->json(Qualification::unapproved()->count());
    }

    public function edit(Qualification $qualification)
    {
        return view('qualification.edit', compact('qualification'));
    }

    public function update(Request $request, Qualification $qualification)
    {
        $qualification->update($request->only(['name']));

        $qualification->update(['is_approved' => (boolean)$request->input('is_approved', '')]);

        return redirect()->back()->with('status', 'Updated Qualification');
    }

    public function archive(Qualification $qualification)
    {
        $qualification->update(['status' => Qualification::ARCHIVED]);

        return redirect()->route('qualifications.index')->with('status', 'Archived Qualification');
    }
}
