<?php

namespace ToStartWork\Http\Controllers\Auth;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use ToStartWork\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use ToStartWork\User;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest', ['except' => 'logout']);
    }

    public function authenticate(Request $request)
    {
        // grab credentials from the request
        $credentials = $request->only('email', 'password');

        try {
            // attempt to verify the credentials and create a token for the user
            if (!$token = \JWTAuth::attempt($credentials)) {

                return response()->json(['error' => 'invalid_credentials'], 401);
            }
        } catch (JWTException $e) {
            // something went wrong whilst attempting to encode the token
            return response()->json(['error' => 'could_not_create_token'], 500);
        }

        $user = Auth::user();

        // all good so return the token
        return response()->json([
            'token' => $token,
            'user' => $user
        ]);
    }

    public function socialAuthenticate(Request $request)
    {
        $user = null;

        switch ($request->from) {
            case 'google':
                $user = User::where('email', $request->email)->where('google_token', $request->token)->first();

                if (!$user) {
                    $user = User::createFromGoogle($request);
                }
                break;
            case 'facebook':
                $user = User::where('email', $request->email)->where('facebook_token', $request->token)->first();

                if (!$user) {
                    $user = User::createFromFacebook($request);
                }
                break;
        }



        try {

            // attempt to verify the credentials and create a token for the user
            if (!$token = \JWTAuth::fromUser($user)) {
                return response()->json(['error' => 'invalid_credentials'], 401);
            }
        } catch (JWTException $e) {
            // something went wrong whilst attempting to encode the token
            return response()->json(['error' => 'could_not_create_token'], 500);
        }

        //FromUser only generates the token and doesn't authenticate so auth here
        \JWTAuth::authenticate($token);

        //Load the full user
        $user = Auth::user();

        // all good so return the token
        return response()->json([
            'token' => $token,
            'user' => $user
        ]);
    }
}
