<?php

namespace ToStartWork\Http\Controllers\Api;

use Illuminate\Http\Request;
use ToStartWork\Http\Controllers\Controller;
use ToStartWork\Http\Requests\UserProfileRequest;
use ToStartWork\User;

class UserProfileController extends Controller
{
    /**
     * @param UserProfileController|UserProfileRequest $request
     * @return static
     */
    public function update(UserProfileRequest $request)
    {

        //Update profile information
        $profileData = array_merge(
            $request->get('basic_info'),
            $request->get('citizen_details'),
            $request->get('licenses'),
            $request->get('medical_informations')
        );
        $user = \Auth::user();
        $user->update($profileData);

        //Update emergency contacts
        if ($request->has('emergency_contacts')) {
            $user->contacts()->delete();
            $user->contacts()->createMany($request->get('emergency_contacts'));
        }

        if ($request->has('employment_details')) {
            //Update employment details
            $user->employment()->delete();
            $user->employment()->createMany($request->get('employment_details'));
        }

        if ($request->has('trades')) {
            //update trades
            $user->trades()->detach();
            $user->trades()->attach($request->get('trades'));
        }

        if ($request->input('is_setup')) {
            $user->update(['is_setup' => true]);
        }

        $user->load('contacts');
        $user->load('employment');
        $user->load('trades');

        return response()->json(['user' => $user]);
    }
}
