<?php

namespace ToStartWork\Http\Controllers\Api;

use Illuminate\Http\Request;
use ToStartWork\Http\Controllers\Controller;
use ToStartWork\Http\Requests\UserSignupRequest;
use ToStartWork\User;

class UserController extends Controller
{
    public function store(UserSignupRequest $request)
    {
        $data = $request->all();
        $data['password'] = bcrypt(base64_decode($request->get('password')));

        return User::create($data);
    }

    public function update(Request $request) {
        $user = \Auth::user();
        $user->update($request->only(['ios_device_token']));

        return response()->json(['user' => $user]);
    }
}
