<?php

namespace ToStartWork\Http\Controllers\Api;

use Auth;
use Illuminate\Http\Request;
use ToStartWork\Http\Controllers\Controller;
use ToStartWork\Http\Requests\UserStoreQualificationFrontImage;

class QualificationUserFrontImageController extends Controller
{
    /**
     * Show image for qualification
     *
     * @param $qualificationId
     * @return \Symfony\Component\HttpFoundation\BinaryFileResponse
     */
    public function show($qualificationId)
    {
        $qualification = Auth::user()->qualifications()->wherePivot('qualification_id', $qualificationId)->withPivot(['front_image'])->first();

        return response()->download(storage_path('app/'.$qualification->pivot->front_image));
    }


    /**
     * Store image for a qualification
     *
     * @param $qualificationId
     * @param UserStoreQualificationFrontImage $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store($qualificationId, UserStoreQualificationFrontImage $request)
    {
        $path = $request->file('front_image')->store('uploads');

        Auth::user()->qualifications()->updateExistingPivot($qualificationId, ['front_image' => $path]);

        return response()->json(['front_image' => $path]);
    }
}
