<?php

namespace ToStartWork\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use ToStartWork\Http\Controllers\Controller;
use ToStartWork\Http\Requests\UserRemoveQualificationRequest;
use ToStartWork\Http\Requests\UserStoreQualificationRequest;
use ToStartWork\Http\Requests\UserUpdateQualificationRequest;
use ToStartWork\Http\Transformers\UserQualificationTransformer;


class QualificationUserController extends Controller
{
    const PIVOT_DETAILS = ['ref_no', 'issue_date', 'expiry_date', 'country', 'state'];

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
        $user = Auth::user();

        $qualifications = $user->qualifications()->withPivot(self::PIVOT_DETAILS)->get();

        $qualificationTransformer = new UserQualificationTransformer();

        return response()->json(['qualifications' => $qualificationTransformer->transform($qualifications)]);
    }

    /**
     * @param UserStoreQualificationRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(UserStoreQualificationRequest $request)
    {
        $user = Auth::user();

        $user->qualifications()->attach($request->get('qualification_id'), $request->only(self::PIVOT_DETAILS));

        $qualification = $user->qualifications()->wherePivot('qualification_id', $request->get('qualification_id'))->withPivot(self::PIVOT_DETAILS)->first();

        return response()->json(['qualification' => $qualification]);
    }

    /**
     * @param $qualificationId
     * @param UserUpdateQualificationRequest|UserStoreQualificationRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function update($qualificationId, UserUpdateQualificationRequest $request)
    {
        $user = Auth::user();

        $user->qualifications()->updateExistingPivot($qualificationId, $request->only(self::PIVOT_DETAILS));

        $qualification = $user->qualifications()->wherePivot('qualification_id', $qualificationId) ->withPivot(self::PIVOT_DETAILS)->first();

        return response()->json(['qualification' => $qualification]);
    }

    /**
     * @param $qualificationId
     * @param UserRemoveQualificationRequest $request
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Symfony\Component\HttpFoundation\Response
     */
    public function destroy($qualificationId, UserRemoveQualificationRequest $request)
    {
        $user = Auth::user();

        $user->qualifications()->detach($qualificationId);

        return response('', 200);
    }
}
