<?php namespace ToStartWork\Helpers;

class Misc
{
    const IMAGE_FOLDER = 'app/';

    /**
     * Format phone number to Australian standard
     *
     * @param $phone
     * @return string
     */
    public static function formatPhone($phone)
    {
        if (preg_match('/(\d{4})(\d{3})(\d{3})$/', $phone, $matches)) {
            return $matches[1] . ' ' . $matches[2] . ' ' . $matches[3];
        }

        return $phone;
    }

    /**
     * Encode image to base64 string
     *
     * @param $imageName
     * @return null|string
     */
    public static function encodeImageToBase64($imageName)
    {
        $file = storage_path(self::IMAGE_FOLDER . $imageName);

        if (file_exists($file)) {
            return 'data:image/png;base64,' . base64_encode(file_get_contents($file));
        }

        return null;
    }
}
