<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;
		$upload = wp_upload_bits( $post['post_name'] . '.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post['post_mime_type'] = $info['type'];
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$post_id = wp_insert_attachment( $post, $upload['file'] );
		wp_update_attachment_metadata( $post_id, wp_generate_attachment_metadata( $post_id, $upload['file'] ) );

		$placeholder_image = $post_id;
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if( ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 1,
  'name' => 'Uncategorized',
  'slug' => 'uncategorized',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 15,
  'name' => 'Dress',
  'slug' => 'dress',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 17,
  'name' => 'Sweater',
  'slug' => 'sweater',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 18,
  'name' => 'Denim',
  'slug' => 'demin',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 19,
  'name' => 'Jacket',
  'slug' => 'jacket',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 20,
  'name' => 'Sexy',
  'slug' => 'sexy',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 16,
  'name' => 'Main Navigation',
  'slug' => 'main-navigation',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 1,
  'post_date' => '2019-08-27 04:14:56',
  'post_date_gmt' => '2019-08-27 04:14:56',
  'post_content' => 'Welcome to <a href="http://themify.me/demo/themes/">Themify Demos</a>. This is your first post. Edit or delete it, then start blogging!',
  'post_title' => 'Hello world!',
  'post_excerpt' => '',
  'post_name' => 'hello-world',
  'post_modified' => '2019-08-27 04:14:56',
  'post_modified_gmt' => '2019-08-27 04:14:56',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?p=1',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
    'category' => 'uncategorized',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 15,
  'post_date' => '2019-08-27 04:22:55',
  'post_date_gmt' => '2019-08-27 04:22:55',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h4>About our</h4> <h1>Company</h1>
<p>We are dedicated to providing the ultimate one-stop fashion destination for all shoppers. From major fashion house designs to the latest streetwear brands, we’ve got a little something for everyone.</p>
<h3>Our Story</h3>
<img src="https://themify.me/demo/themes/ultra-fashion/files/2019/08/denim-in-hills-928x1024-720x794.jpg" width="720" alt="" />
<p>What started out as a joint venture between two best friends in 2010 has grown to one of the largest eCommerce stores with a cult following. Great news, the two founders are still best friends and co-CEOs, and they\'re still crazy about fashion.</p>
<img src="https://themify.me/demo/themes/ultra-fashion/files/2019/08/sexy-cordoray-928x1024-720x794.jpg" width="720" alt="" />
<h3>Our Team</h3>
<img src="https://themify.me/demo/themes/ultra-fashion-dev/files/2019/09/woman-with-sunglasses-600x662.jpg" width="308" title="Christine Lopez" alt="Co-CEO" /> <h3> Christine Lopez </h3> Co-CEO
<a href="https://www.instagram.com/themify/"> </a> <a href="http://twitter.com/themify"> </a> <a href="https://www.linkedin.com/company/themify/about/"> </a>
<img src="https://themify.me/demo/themes/ultra-fashion-dev/files/2019/09/woman-with-hat-and-leather-jacket-600x662.jpg" width="308" title="Agnez May" alt="Co-CEO" /> <h3> Agnez May </h3> Co-CEO
<a href="https://www.instagram.com/themify/"> </a> <a href="http://twitter.com/themify"> </a> <a href="https://www.linkedin.com/company/themify/about/"> </a>
<img src="https://themify.me/demo/themes/ultra-fashion-dev/files/2019/09/woman-wearing-sexy-suit-600x662.jpg" width="308" title="Maxima Verre" alt="Director of Design" /> <h3> Maxima Verre </h3> Director of Design
<a href="https://www.instagram.com/themify/"> </a> <a href="http://twitter.com/themify"> </a> <a href="https://www.linkedin.com/company/themify/about/"> </a>
<h3>Locations</h3>
<h3>Los Angeles</h3> <p>777 Bohemia Drive<br />Los Angeles, 90210</p> <p>M – F: 11am – 8pm <br />Sat: 10am – 8pm <br />Sun: 12pm – 5pm<br />Phone: 416-597-0888</p>
<a href="https://themify.me/" > Get Directions </a>
<h3>New York</h3> <p>88 9th Street<br />Manhattan, 10003</p> <p>M – F: 11am – 8pm <br />Sat: 10am – 8pm <br />Sun: 12pm – 5pm<br />Phone: 416-597-0777</p>
<a href="https://themify.me/" > Get Directions </a>
<h3>Miami</h3> <p>4325 Miami Avenue<br />Miami, 33136</p> <p>M – F: 11am – 8pm <br />Sat: 10am – 8pm <br />Sun: 12pm – 5pm<br />Phone: 416-597-0999</p>
<a href="https://themify.me/" > Get Directions </a>
<link id="themify-builder-145-generated" rel="stylesheet" href="https://themify.me/demo/themes/ultra-fashion/files/themify-css/themify-builder-145-generated.css?ver=1567458973" type="text/css" /> 
 <h3>Exclusive Discounts</h3>
<p>Subscribe to our newsletter for a 10% discount.</p>
<form id="mc-embedded-subscribe-form" class="validate" action="https://themify.us2.list-manage.com/subscribe/post?u=03462cf158e86ea00590274ab&amp;id=0f2a95e5de" method="post" name="mc-embedded-subscribe-form" novalidate="novalidate" target="_blank">
 
</form>
 
 <form name="tb_optin" method="post" action="https://themify.me/demo/themes/ultra-fashion/wp-admin/admin-ajax.php" data-success="s2" > <input type="hidden" name="action" value="tb_optin_subscribe" /> <input type="hidden" name="tb_optin_redirect" value="" /> <input type="hidden" name="tb_optin_provider" value="mailchimp" />
 <input type="hidden" name="tb_optin_mailchimp_list" value="0f2a95e5de" /> <input type="hidden" name="tb_optin_fname" value="John" /> <input type="hidden" name="tb_optin_lname" value="Doe" /> <label></label> <input type="email" name="tb_optin_email" required="required" /> <button>Subscribe</button> </form> <p>Success!</p><!--/themify_builder_static-->',
  'post_title' => 'About',
  'post_excerpt' => '',
  'post_name' => 'about',
  'post_modified' => '2019-09-03 15:23:11',
  'post_modified_gmt' => '2019-09-03 15:23:11',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?page_id=15',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"skc220\\",\\"cols\\":[{\\"element_id\\":\\"otwd21\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"bb2s22\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>About our<\\\\/h4>\\\\n<h1>Company<\\\\/h1>\\",\\"line_height_h1_unit\\":\\"em\\",\\"line_height_h1\\":\\"0.8\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"margin_bottom\\":\\"40\\",\\"breakpoint_mobile\\":{\\"margin_bottom\\":\\"30\\",\\"margin_bottom_unit\\":\\"px\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"line_height_h1_unit\\":\\"em\\",\\"line_height_h1\\":\\"0.8\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"36\\"},\\"breakpoint_tablet\\":{\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"line_height_h1_unit\\":\\"em\\",\\"line_height_h1\\":\\"0.8\\",\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"50\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"line_height_h1_unit\\":\\"em\\",\\"line_height_h1\\":\\"0.8\\",\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"60\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"}}},{\\"element_id\\":\\"cprd22\\",\\"cols\\":[{\\"element_id\\":\\"lmif22\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"7nhy22\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>We are dedicated to providing the ultimate one-stop fashion destination for all shoppers. From major fashion house designs to the latest streetwear brands, we’ve got a little something for everyone.<\\\\/p>\\",\\"padding_right\\":\\"80\\",\\"margin_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"30\\",\\"padding_top\\":\\"30\\",\\"breakpoint_mobile\\":{\\"margin_bottom\\":\\"0\\",\\"margin_bottom_unit\\":\\"%\\"},\\"breakpoint_tablet\\":{\\"padding_bottom\\":\\"23\\",\\"padding_bottom_unit\\":\\"px\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"lotq22\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Our Story<\\\\/h3>\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"55\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom\\":\\"40\\",\\"margin_top\\":\\"40\\",\\"breakpoint_mobile\\":{\\"margin_top\\":\\"0\\",\\"margin_bottom\\":\\"24\\",\\"margin_bottom_unit\\":\\"px\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"35\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"margin_top\\":\\"0\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"40\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"50\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"}}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"shbi22\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fashion\\\\/files\\\\/2019\\\\/08\\\\/denim-in-hills-928x1024-720x794.jpg\\",\\"style_image\\":\\"image-center\\",\\"width_image\\":\\"720\\",\\"margin_left\\":\\"-40\\",\\"breakpoint_mobile\\":{\\"margin_left\\":\\"0\\"},\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_speed\\":\\"1\\",\\"v_dir\\":\\"down\\"}}},\\"breakpoint_tablet\\":{\\"margin_left\\":\\"0\\",\\"margin_bottom\\":\\"0\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"k7u822\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>What started out as a joint venture between two best friends in 2010 has grown to one of the largest eCommerce stores with a cult following. Great news, the two founders are still best friends and co-CEOs, and they\\\\\\\\\\\'re still crazy about fashion.<\\\\/p>\\",\\"background_position\\":\\"left-top\\",\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#ffffff\\",\\"font_color\\":\\"#000000\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_top_unit\\":\\"%\\",\\"margin_top\\":\\"-40\\",\\"margin_right_unit\\":\\"%\\",\\"margin_right\\":\\"-70\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"70\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"6\\",\\"breakpoint_mobile\\":{\\"margin_left\\":\\"0\\",\\"margin_right\\":\\"0\\",\\"margin_top\\":\\"0\\"},\\"b_sh_color\\":\\"#000000_0.12\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"20\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"3\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"0\\",\\"breakpoint_tablet\\":{\\"margin_right_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"margin_left\\":\\"0\\",\\"margin_right\\":\\"0\\",\\"margin_top\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"6\\"},\\"breakpoint_tablet_landscape\\":{\\"margin_right_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"margin_right\\":\\"-70\\",\\"margin_top\\":\\"-40\\"}}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}}],\\"styling\\":{\\"background_color\\":\\"#ebebeb\\",\\"background_position\\":\\"50,50\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"font_color\\":\\"#000000\\",\\"padding_bottom\\":\\"50\\",\\"breakpoint_mobile\\":{\\"padding_bottom\\":\\"0\\"},\\"background_type\\":\\"image\\",\\"breakpoint_tablet\\":{\\"padding_bottom\\":\\"0\\"}}}],\\"styling\\":{\\"breakpoint_tablet\\":{\\"padding_top\\":\\"34\\",\\"padding_top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"ze0t23\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"vgbt23\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":\\"1\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fashion\\\\/files\\\\/2019\\\\/08\\\\/sexy-cordoray-928x1024-720x794.jpg\\",\\"style_image\\":\\"image-top\\",\\"width_image\\":\\"720\\",\\"custom_parallax_scroll_zindex\\":\\"3\\",\\"margin_left\\":\\"-60\\",\\"breakpoint_mobile\\":{\\"margin_left\\":\\"0\\",\\"margin_bottom\\":\\"40\\"},\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_vp\\":\\"0,100\\",\\"v_speed\\":\\"1\\",\\"v_dir\\":\\"up\\"}}},\\"breakpoint_tablet\\":{\\"margin_left\\":\\"0\\"},\\"breakpoint_tablet_landscape\\":{\\"margin_left\\":\\"-20\\"}}}]}],\\"gutter\\":\\"gutter-none\\",\\"tablet_dir\\":\\"rtl\\",\\"mobile_dir\\":\\"rtl\\",\\"col_tablet\\":\\"column-full\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"breakpoint_mobile\\":{\\"padding_bottom\\":\\"0\\",\\"margin-top\\":\\"14\\",\\"margin-top_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"margin-top\\":\\"12\\",\\"margin-top_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\"},\\"breakpoint_tablet_landscape\\":{\\"margin-top\\":\\"18\\",\\"margin-top_unit\\":\\"px\\"},\\"padding_top\\":\\"127\\"}},{\\"element_id\\":\\"93xf20\\",\\"cols\\":[{\\"element_id\\":\\"d4ur23\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"uotg23\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Our Team<\\\\/h3>\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"55\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"h3_margin_bottom\\":\\"40\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"breakpoint_mobile\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"40\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"45\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"40\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"40\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"40\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"50\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"element_id\\":\\"inue23\\",\\"cols\\":[{\\"element_id\\":\\"ks4t24\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"397f24\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"308\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fashion-dev\\\\/files\\\\/2019\\\\/09\\\\/woman-with-sunglasses-600x662.jpg\\",\\"style_image\\":\\"image-center\\",\\"title_image\\":\\"Christine Lopez\\",\\"caption_image\\":\\"Co-CEO\\",\\"global_styles\\":\\"tb_gs1305d6\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"cklz24\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-instagram\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-twitter-alt\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"http:\\\\/\\\\/twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-linkedin\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.linkedin.com\\\\/company\\\\/themify\\\\/about\\\\/\\",\\"link_options\\":\\"regular\\"}],\\"icon_position\\":\\"icon_position_center\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"font_color_icon_hover\\":\\"#ddbc6a\\",\\"font_color_icon\\":\\"#999999\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"40\\"}}},{\\"element_id\\":\\"kaeh24\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"sevp24\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"308\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fashion-dev\\\\/files\\\\/2019\\\\/09\\\\/woman-with-hat-and-leather-jacket-600x662.jpg\\",\\"style_image\\":\\"image-center\\",\\"title_image\\":\\"Agnez May\\",\\"caption_image\\":\\"Co-CEO\\",\\"background_repeat\\":\\"repeat\\",\\"background_image-type\\":\\"image\\",\\"global_styles\\":\\"tb_gs1305d6\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"pqfp24\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-instagram\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-twitter-alt\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"http:\\\\/\\\\/twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-linkedin\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.linkedin.com\\\\/company\\\\/themify\\\\/about\\\\/\\",\\"link_options\\":\\"regular\\"}],\\"icon_position\\":\\"icon_position_center\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"font_color_icon_hover\\":\\"#ddbc6a\\",\\"font_color_icon\\":\\"#999999\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"40\\"}}},{\\"element_id\\":\\"rwla24\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"swy524\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"308\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fashion-dev\\\\/files\\\\/2019\\\\/09\\\\/woman-wearing-sexy-suit-600x662.jpg\\",\\"style_image\\":\\"image-center\\",\\"title_image\\":\\"Maxima Verre\\",\\"caption_image\\":\\"Director of Design\\",\\"global_styles\\":\\"tb_gs1305d6\\",\\"image_zoom_icon\\":\\"\\",\\"auto_fullwidth\\":\\"\\",\\"appearance_image\\":\\"\\",\\"caption_on_overlay\\":\\"\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"pm6x25\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-instagram\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-twitter-alt\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"http:\\\\/\\\\/twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-linkedin\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.linkedin.com\\\\/company\\\\/themify\\\\/about\\\\/\\",\\"link_options\\":\\"regular\\"}],\\"icon_position\\":\\"icon_position_center\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"font_color_icon_hover\\":\\"#ddbc6a\\",\\"font_color_icon\\":\\"#999999\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"20\\"}}}],\\"styling\\":{\\"breakpoint_tablet\\":{\\"padding_left\\":\\"20\\"},\\"breakpoint_mobile\\":{\\"padding_left\\":\\"0\\"},\\"breakpoint_tablet_landscape\\":{\\"padding_left\\":\\"20\\"}}}]}],\\"styling\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"8\\"}},{\\"element_id\\":\\"fid521\\",\\"cols\\":[{\\"element_id\\":\\"9nlr25\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"uh1025\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Locations<\\\\/h3>\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"55\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"h3_margin_bottom\\":\\"40\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"breakpoint_mobile\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"40\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"45\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_tablet\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"40\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"40\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"40\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"50\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"element_id\\":\\"ii5525\\",\\"cols\\":[{\\"element_id\\":\\"0jx125\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"hwd525\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Los Angeles<\\\\/h3>\\\\n<p>777 Bohemia Drive<br \\\\/>Los Angeles, 90210<\\\\/p>\\\\n<p>M – F: 11am – 8pm <br \\\\/>Sat: 10am – 8pm <br \\\\/>Sun: 12pm – 5pm<br \\\\/>Phone: 416-597-0888<\\\\/p>\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom\\":\\"20\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_size_h3\\":\\"2\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"breakpoint_tablet\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"30\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"nkod26\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Get Directions\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"alignment\\":\\"center\\",\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"outline\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"margin_bottom\\":\\"20\\"}}]},{\\"element_id\\":\\"hi1526\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ud4e26\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>New York<\\\\/h3>\\\\n<p>88 9th Street<br \\\\/>Manhattan, 10003<\\\\/p>\\\\n<p>M – F: 11am – 8pm <br \\\\/>Sat: 10am – 8pm <br \\\\/>Sun: 12pm – 5pm<br \\\\/>Phone: 416-597-0777<\\\\/p>\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom\\":\\"20\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_size_h3\\":\\"2\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"breakpoint_tablet\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"30\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"2n6y26\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Get Directions\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"alignment\\":\\"center\\",\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"outline\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"margin_bottom\\":\\"20\\"}}]},{\\"element_id\\":\\"ytcj26\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"x1v726\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Miami<\\\\/h3>\\\\n<p>4325 Miami Avenue<br \\\\/>Miami, 33136<\\\\/p>\\\\n<p>M – F: 11am – 8pm <br \\\\/>Sat: 10am – 8pm <br \\\\/>Sun: 12pm – 5pm<br \\\\/>Phone: 416-597-0999<\\\\/p>\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom\\":\\"20\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_size_h3\\":\\"2\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"breakpoint_tablet\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"30\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"yzxd26\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Get Directions\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"alignment\\":\\"center\\",\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"outline\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"margin_bottom\\":\\"20\\"}}]}]}]}],\\"styling\\":{\\"background_color\\":\\"f7f5f7\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"breakpoint_mobile\\":{\\"padding_top\\":\\"9\\",\\"padding_top_unit\\":\\"%\\"}}},{\\"element_id\\":\\"qls721\\",\\"cols\\":[{\\"element_id\\":\\"1wmg28\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"layout-part\\",\\"element_id\\":\\"kwz628\\",\\"mod_settings\\":{\\"selected_layout_part\\":\\"ultra-fashion-newsletter-row\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\"}}]',
    'themify_used_global_styles' => 
    array (
      0 => 'tb_gs1305d6',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6,
  'post_date' => '2019-08-27 04:19:25',
  'post_date_gmt' => '2019-08-27 04:19:25',
  'post_content' => '<!-- wp:shortcode -->[woocommerce_cart]<!-- /wp:shortcode -->',
  'post_title' => 'Cart',
  'post_excerpt' => '',
  'post_name' => 'cart',
  'post_modified' => '2019-08-27 04:19:25',
  'post_modified_gmt' => '2019-08-27 04:19:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/cart/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 7,
  'post_date' => '2019-08-27 04:19:25',
  'post_date_gmt' => '2019-08-27 04:19:25',
  'post_content' => '<!-- wp:shortcode -->[woocommerce_checkout]<!-- /wp:shortcode -->',
  'post_title' => 'Checkout',
  'post_excerpt' => '',
  'post_name' => 'checkout',
  'post_modified' => '2019-08-27 04:19:25',
  'post_modified_gmt' => '2019-08-27 04:19:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/checkout/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 18,
  'post_date' => '2019-08-27 04:23:43',
  'post_date_gmt' => '2019-08-27 04:23:43',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>Contact</h1>
<p>Please check our FAQ page for any shipping, returns, policy related issues.</p> <p>If there’s anything else you need, we’d love to hear from you! </p>
<img src="https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-wear-zig-zag-sweater-motive-529x583.jpg" width="529" alt="woman-wear-zig-zag-sweater-motive" srcset="https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-wear-zig-zag-sweater-motive-529x583.jpg 529w, https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-wear-zig-zag-sweater-motive-544x600.jpg 544w, https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-wear-zig-zag-sweater-motive-768x847.jpg 768w, https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-wear-zig-zag-sweater-motive-600x662.jpg 600w, https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-wear-zig-zag-sweater-motive.jpg 1200w" sizes="(max-width: 529px) 100vw, 529px" />
<form action="https://themify.me/demo/themes/ultra-fashion/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Name *</label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" required/> <label for="contact-0--contact-email">Email *</label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" required /> <label for="contact-0--contact-subject">Subject *</label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" required /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Send </button> </form>
<link id="themify-builder-145-generated" rel="stylesheet" href="https://themify.me/demo/themes/ultra-fashion/files/themify-css/themify-builder-145-generated.css?ver=1567458973" type="text/css" /> 
 <h3>Exclusive Discounts</h3>
<p>Subscribe to our newsletter for a 10% discount.</p>
<form id="mc-embedded-subscribe-form" class="validate" action="https://themify.us2.list-manage.com/subscribe/post?u=03462cf158e86ea00590274ab&amp;id=0f2a95e5de" method="post" name="mc-embedded-subscribe-form" novalidate="novalidate" target="_blank">
 
</form>
 
 <form name="tb_optin" method="post" action="https://themify.me/demo/themes/ultra-fashion/wp-admin/admin-ajax.php" data-success="s2" > <input type="hidden" name="action" value="tb_optin_subscribe" /> <input type="hidden" name="tb_optin_redirect" value="" /> <input type="hidden" name="tb_optin_provider" value="mailchimp" />
 <input type="hidden" name="tb_optin_mailchimp_list" value="0f2a95e5de" /> <input type="hidden" name="tb_optin_fname" value="John" /> <input type="hidden" name="tb_optin_lname" value="Doe" /> <label></label> <input type="email" name="tb_optin_email" required="required" /> <button>Subscribe</button> </form> <p>Success!</p><!--/themify_builder_static-->',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact',
  'post_modified' => '2019-09-19 15:39:31',
  'post_modified_gmt' => '2019-09-19 15:39:31',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?page_id=18',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"wome754\\",\\"cols\\":[{\\"element_id\\":\\"mgqg758\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"4pwg760\\",\\"cols\\":[{\\"element_id\\":\\"s4pw760\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"obaj761\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"yac2762\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Contact<\\\\/h1>\\",\\"text_align\\":\\"right\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"text_transform\\":\\"uppercase\\",\\"breakpoint_mobile\\":{\\"text_transform\\":\\"uppercase\\",\\"text_align\\":\\"right\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"40\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"},\\"breakpoint_tablet\\":{\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"36\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"50\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"7c5w763\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Please check our FAQ page for any shipping, returns, policy related issues.<\\\\/p>\\\\n<p>If there’s anything else you need, we’d love to hear from you! <\\\\/p>\\",\\"text_align\\":\\"right\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"margin_left\\":\\"40\\",\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.2\\",\\"breakpoint_mobile\\":{\\"text_align\\":\\"right\\",\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_tablet\\":{\\"text_align\\":\\"right\\",\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.1\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"text_align\\":\\"right\\",\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.1\\",\\"font_color_type\\":\\"font_color_solid\\"}}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"padding_top\\":\\"39\\",\\"margin-bottom\\":\\"90\\",\\"margin-bottom_unit\\":\\"px\\",\\"padding_top_unit\\":\\"px\\"}}}],\\"styling\\":{\\"breakpoint_tablet\\":{\\"padding_bottom\\":\\"50\\"}}}],\\"styling\\":{\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"5\\"}},{\\"element_id\\":\\"ck3o763\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"gfz8764\\",\\"cols\\":[{\\"element_id\\":\\"fhsr764\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"dz18764\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"529\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fashion\\\\/files\\\\/2019\\\\/08\\\\/woman-wear-zig-zag-sweater-motive-529x583.jpg\\",\\"style_image\\":\\"image-top\\",\\"margin_top_unit\\":\\"%\\",\\"margin_top\\":\\"-10\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"10\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"10\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"auto_fullwidth\\":\\"1\\",\\"breakpoint_mobile\\":{\\"margin_bottom_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"margin_left\\":\\"0\\",\\"margin_bottom\\":\\"10\\",\\"margin_top\\":\\"-10\\"}}}],\\"styling\\":{\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"breakpoint_tablet\\":{\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"lcfv764\\",\\"grid_class\\":\\"col4-1\\"}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"background_color\\":\\"#ebebeb\\",\\"background_position\\":\\"50,50\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"breakpoint_mobile\\":{\\"padding_top\\":\\"0\\",\\"padding_top_unit\\":\\"%\\"}}},{\\"element_id\\":\\"v0il754\\",\\"cols\\":[{\\"element_id\\":\\"qpk8765\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"ee73780\\",\\"mod_settings\\":{\\"field_name_label\\":\\"Name\\",\\"field_email_label\\":\\"Email\\",\\"field_subject_label\\":\\"Subject\\",\\"field_message_label\\":\\"Message\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_send_label\\":\\"Send\\",\\"gdpr_label\\":\\"I consent to my submitted data being collected and stored\\",\\"field_name_require\\":\\"yes\\",\\"field_email_require\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_email_active\\":\\"yes\\",\\"field_subject_active\\":\\"yes\\",\\"field_subject_require\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"field_send_align\\":\\"center\\",\\"field_extra\\":\\"{ \\\\\\\\\\\\\\"fields\\\\\\\\\\\\\\": [] }\\",\\"field_order\\":\\"{}\\",\\"contact_sent_from\\":\\"enable\\",\\"layout_contact\\":\\"style2\\",\\"field_sendcopy_active\\":\\"\\",\\"field_captcha_active\\":\\"\\",\\"post_author\\":\\"\\",\\"send_to_admins\\":\\"true\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_color\\":\\"f7f5f7\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"8\\",\\"breakpoint_mobile\\":{\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\"},\\"breakpoint_tablet\\":{\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\"}}},{\\"element_id\\":\\"1xyf764\\",\\"cols\\":[{\\"element_id\\":\\"gx7e764\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"layout-part\\",\\"element_id\\":\\"zv08765\\",\\"mod_settings\\":{\\"selected_layout_part\\":\\"ultra-fashion-newsletter-row\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\"}}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 10,
  'post_date' => '2019-08-27 04:21:23',
  'post_date_gmt' => '2019-08-27 04:21:23',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>Pretty In Print</h1> <p>Our new collection of tropical prints are here and ready for every season of your life! Hand-crafted by our world-class designers, get this new look exclusively online. </p>
<a href="https://themify.me/" > Shop Now </a>
<img src="https://themify.me/demo/themes/ultra-fashion/files/2019/08/ultra-fashion-top-banner-770x414.jpg" width="770" alt="ultra-fashion-top-banner" srcset="https://themify.me/demo/themes/ultra-fashion/files/2019/08/ultra-fashion-top-banner-770x414.jpg 770w, https://themify.me/demo/themes/ultra-fashion/files/2019/08/ultra-fashion-top-banner-300x162.jpg 300w, https://themify.me/demo/themes/ultra-fashion/files/2019/08/ultra-fashion-top-banner-768x414.jpg 768w, https://themify.me/demo/themes/ultra-fashion/files/2019/08/ultra-fashion-top-banner-600x323.jpg 600w, https://themify.me/demo/themes/ultra-fashion/files/2019/08/ultra-fashion-top-banner.jpg 800w" sizes="(max-width: 770px) 100vw, 770px" />
<img src="https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-accessories-928x1024-310x342.jpg" width="310" alt="" />
<h3>Women\'s Bags</h3>
<a href="https://themify.me/" > View more </a>

<img src="https://themify.me/demo/themes/ultra-fashion/files/2019/08/oriental-dress-310x341.jpg" width="310" alt="oriental-dress" srcset="https://themify.me/demo/themes/ultra-fashion/files/2019/08/oriental-dress-310x341.jpg 310w, https://themify.me/demo/themes/ultra-fashion/files/2019/08/oriental-dress-272x300.jpg 272w, https://themify.me/demo/themes/ultra-fashion/files/2019/08/oriental-dress.jpg 400w" sizes="(max-width: 310px) 100vw, 310px" />
<h3>Women\'s Dresses</h3>
<a href="https://themify.me/" > View more </a>

<img src="https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-hat-928x1024-310x342.jpg" width="310" alt="" />
<h3>Accessories</h3>
<a href="https://themify.me/" > View more </a>

<h3>Upcoming</h3>
<img src="https://themify.me/demo/themes/ultra-fashion/files/2019/08/retro-blazer-600x479.jpg" width="600" alt="retro-blazer" srcset="https://themify.me/demo/themes/ultra-fashion/files/2019/08/retro-blazer-600x479.jpg 600w, https://themify.me/demo/themes/ultra-fashion/files/2019/08/retro-blazer-300x240.jpg 300w, https://themify.me/demo/themes/ultra-fashion/files/2019/08/retro-blazer.jpg 670w" sizes="(max-width: 600px) 100vw, 600px" />
<h3>The Back-to-Work Power Suit</h3> <p>Fall is upon us and dressing up for work will be exciting all over again with these power suits.</p>
<a href="https://themify.me/" > See More </a>
<img src="https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-grayscale-600x479.jpg" width="600" alt="woman-grayscale" srcset="https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-grayscale-600x479.jpg 600w, https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-grayscale-300x240.jpg 300w, https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-grayscale.jpg 670w" sizes="(max-width: 600px) 100vw, 600px" />
<h3>The Sultriest Swimsuits</h3> <p>Let your weekend getaways take care of themselves - we\'ve got you and your assets covered.</p>
<a href="https://themify.me/" > See More </a>
<img src="https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-hat-grayscale-600x479.jpg" width="600" alt="woman-hat-grayscale" srcset="https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-hat-grayscale-600x479.jpg 600w, https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-hat-grayscale-300x240.jpg 300w, https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-hat-grayscale.jpg 670w" sizes="(max-width: 600px) 100vw, 600px" />
<h3>Top Accessory Trends</h3> <p>From caps, to headbands, to necklaces, to scarves - we\'ve got the most popular trends this season.</p>
<a href="https://themify.me/" > See More </a>
<h3>Featured Products</h3>
<figure> <a href="https://themify.me/demo/themes/ultra-fashion/product/117/"><img src="https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-in-casual-style-928x1024-262x287.jpg" width="262" height="287" alt="woman-in-casual-style" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-fashion/product/117/" title="The Perfect Jean Shorts">The Perfect Jean Shorts</a></h3> 
 &#36;165.00 <p><a href="/demo/themes/ultra-fashion/wp-admin/admin-ajax.php?add-to-cart=117" data-quantity="1" data-product_id="117" data-product_sku="" aria-label="Add &ldquo;The Perfect Jean Shorts&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-fashion/wp-admin/post.php?post=117&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-fashion/product/115/"><img src="https://themify.me/demo/themes/ultra-fashion/files/2019/08/sexy-cordoray-928x1024-262x287.jpg" width="262" height="287" alt="sexy-cordoray" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-fashion/product/115/" title="Luella Waffle Kimono">Luella Waffle Kimono</a></h3> 
 &#36;125.00 <p><a href="/demo/themes/ultra-fashion/wp-admin/admin-ajax.php?add-to-cart=115" data-quantity="1" data-product_id="115" data-product_sku="" aria-label="Add &ldquo;Luella Waffle Kimono&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-fashion/wp-admin/post.php?post=115&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-fashion/product/111/"><img src="https://themify.me/demo/themes/ultra-fashion/files/2019/08/denim-in-hills-928x1024-262x287.jpg" width="262" height="287" alt="denim-in-hills" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-fashion/product/111/" title="The Perfect Cropped Jeans">The Perfect Cropped Jeans</a></h3> 
 &#36;170.00 <p><a href="/demo/themes/ultra-fashion/wp-admin/admin-ajax.php?add-to-cart=111" data-quantity="1" data-product_id="111" data-product_sku="" aria-label="Add &ldquo;The Perfect Cropped Jeans&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-fashion/wp-admin/post.php?post=111&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-fashion/product/110/"><img src="https://themify.me/demo/themes/ultra-fashion/files/2019/08/black-tanktop-928x1024-262x287.jpg" width="262" height="287" alt="black-tanktop" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-fashion/product/110/" title="The Great V Cami">The Great V Cami</a></h3> 
 &#36;115.00 <p><a href="/demo/themes/ultra-fashion/wp-admin/admin-ajax.php?add-to-cart=110" data-quantity="1" data-product_id="110" data-product_sku="" aria-label="Add &ldquo;The Great V Cami&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-fashion/wp-admin/post.php?post=110&#038;action=edit">Edit</a>]
<link id="themify-builder-145-generated" rel="stylesheet" href="https://themify.me/demo/themes/ultra-fashion/files/themify-css/themify-builder-145-generated.css?ver=1567231849" type="text/css" /> 
 <h3>Exclusive Discounts</h3>
<p>Subscribe to our newsletter for a 10% discount!</p>
<form id="mc-embedded-subscribe-form" action="https://themify.us2.list-manage.com/subscribe/post?u=03462cf158e86ea00590274ab&amp;id=0f2a95e5de" method="post" name="mc-embedded-subscribe-form" novalidate="novalidate" target="_blank">
 
</form>
 
 <form name="tb_optin" method="post" action="https://themify.me/demo/themes/ultra-fashion/wp-admin/admin-ajax.php" data-success="s2" > <input type="hidden" name="action" value="tb_optin_subscribe" /> <input type="hidden" name="tb_optin_redirect" value="" /> <input type="hidden" name="tb_optin_provider" value="mailchimp" />
 <input type="hidden" name="tb_optin_mailchimp_list" value="0f2a95e5de" /> <input type="hidden" name="tb_optin_fname" value="John" /> <input type="hidden" name="tb_optin_lname" value="Doe" /> <label></label> <input type="email" name="tb_optin_email" required="required" /> <button>Subscribe</button> </form> <p>Success!</p><!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2019-08-31 06:10:56',
  'post_modified_gmt' => '2019-08-31 06:10:56',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?page_id=10',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"7857304\\",\\"cols\\":[{\\"element_id\\":\\"up7a312\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"32mi313\\",\\"cols\\":[{\\"element_id\\":\\"m0hr315\\",\\"grid_class\\":\\"col3-1\\"},{\\"element_id\\":\\"ifli316\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"je9k318\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Pretty In Print<\\\\/h1>\\\\n<p>Our new collection of tropical prints are here and ready for every season of your life! Hand-crafted by our world-class designers, get this new look exclusively online. <\\\\/p>\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"text_align\\":\\"left\\",\\"font_color_type\\":\\"font_color_solid\\",\\"custom_parallax_scroll_zindex\\":\\"3\\",\\"margin_right_unit\\":\\"%\\",\\"breakpoint_mobile\\":{\\"margin_right_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"10\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"10\\"},\\"padding_top_unit\\":\\"%\\",\\"breakpoint_tablet_landscape\\":{\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"40\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"fm3z321\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Shop Now\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"outline\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom\\":\\"30\\",\\"margin_top\\":\\"15\\",\\"breakpoint_mobile\\":{\\"margin_right_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"10\\",\\"margin_opp_left\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"margin_right\\":\\"10\\",\\"margin_top\\":\\"15\\"}}}]}],\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"breakpoint_mobile\\":{\\"margin_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"5\\",\\"margin_opp_top\\":\\"1\\",\\"margin_top_unit\\":\\"%\\",\\"margin_top\\":\\"5\\"},\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"6\\",\\"breakpoint_tablet\\":{\\"padding_top_unit\\":\\"%\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_bottom\\":\\"6\\",\\"padding_right\\":\\"6\\"}}}]},{\\"element_id\\":\\"6gsf325\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"pnm6326\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"770\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fashion\\\\/files\\\\/2019\\\\/08\\\\/ultra-fashion-top-banner-770x414.jpg\\",\\"style_image\\":\\"image-top\\",\\"margin_top\\":\\"-16\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"-20\\",\\"custom_parallax_scroll_zindex\\":\\"1\\",\\"breakpoint_mobile\\":{\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"0\\",\\"margin_top\\":\\"0\\"},\\"margin_top_unit\\":\\"%\\",\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_speed\\":\\"1\\",\\"v_dir\\":\\"up\\"}}},\\"breakpoint_tablet\\":{\\"margin_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"margin_left\\":\\"0\\",\\"margin_top\\":\\"0\\"},\\"breakpoint_tablet_landscape\\":{\\"margin_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"margin_left\\":\\"-20\\",\\"margin_top\\":\\"-18\\"}}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_color\\":\\"#ebebeb\\",\\"background_position\\":\\"50,50\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"margin-top_unit\\":\\"%\\",\\"margin-top\\":\\"9\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"0\\",\\"margin-bottom_unit\\":\\"%\\",\\"margin-bottom\\":\\"-10\\",\\"breakpoint_mobile\\":{\\"margin-top\\":\\"0\\",\\"padding_bottom\\":\\"13\\",\\"padding_bottom_unit\\":\\"%\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"0\\",\\"margin-top_unit\\":\\"px\\",\\"bottom-frame_location\\":\\"in_bellow\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"top-frame_location\\":\\"in_bellow\\",\\"top-frame_height_unit\\":\\"%\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_type\\":\\"top-presets\\"},\\"background_type\\":\\"image\\",\\"font_color\\":\\"#000000\\",\\"breakpoint_tablet_landscape\\":{\\"bottom-frame_location\\":\\"in_bellow\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"top-frame_location\\":\\"in_bellow\\",\\"top-frame_height_unit\\":\\"%\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_type\\":\\"top-presets\\",\\"margin-top\\":\\"4\\",\\"margin-top_unit\\":\\"%\\"},\\"bottom-frame_location\\":\\"in_bellow\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"top-frame_location\\":\\"in_bellow\\",\\"top-frame_height_unit\\":\\"%\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_type\\":\\"top-presets\\",\\"breakpoint_tablet\\":{\\"bottom-frame_location\\":\\"in_bellow\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"top-frame_location\\":\\"in_bellow\\",\\"top-frame_height_unit\\":\\"%\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_type\\":\\"top-presets\\",\\"margin-top\\":\\"0\\",\\"margin-top_unit\\":\\"%\\"}}},{\\"element_id\\":\\"rhmh305\\",\\"cols\\":[{\\"element_id\\":\\"qq0m327\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"xlfx328\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"310\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fashion\\\\/files\\\\/2019\\\\/08\\\\/woman-accessories-928x1024-310x342.jpg\\",\\"style_image\\":\\"image-center\\",\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_vp\\":\\"0,100\\",\\"v_speed\\":\\"1\\"}}}}},{\\"element_id\\":\\"cn4f688\\",\\"cols\\":[{\\"element_id\\":\\"3fam689\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"azya385\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Women\\\\\\\\\\\'s Bags<\\\\/h3>\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_size_h3\\":\\"2\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type\\":\\"font_color_solid\\",\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"breakpoint_mobile\\":{\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"26\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"28\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"28\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"ck0b689\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"View more\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"transparent\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"small\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"mr5v689\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"#000000\\",\\"divider_width\\":\\"40\\",\\"divider_align\\":\\"left\\",\\"divider_type\\":\\"custom\\"}}]}],\\"styling\\":{\\"margin_left\\":\\"-10\\",\\"margin_top\\":\\"-10\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"40\\"}}},{\\"element_id\\":\\"vp13332\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8hic333\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"310\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fashion\\\\/files\\\\/2019\\\\/08\\\\/oriental-dress-310x341.jpg\\",\\"style_image\\":\\"image-center\\"}},{\\"element_id\\":\\"pi9y71\\",\\"cols\\":[{\\"element_id\\":\\"mco872\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"g5yq672\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Women\\\\\\\\\\\'s Dresses<\\\\/h3>\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_size_h3\\":\\"2\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type\\":\\"font_color_solid\\",\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"breakpoint_mobile\\":{\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"26\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"28\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"28\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"h0mq72\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"View more\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"transparent\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"small\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"tv5j72\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"#000000\\",\\"divider_width\\":\\"40\\",\\"divider_align\\":\\"left\\",\\"divider_type\\":\\"custom\\"}}]}],\\"styling\\":{\\"margin_left\\":\\"-10\\",\\"margin_top\\":\\"-10\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"40\\",\\"checkbox_padding_apply_all\\":\\"1\\"}}},{\\"element_id\\":\\"d4a8347\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"f22h347\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"310\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fashion\\\\/files\\\\/2019\\\\/08\\\\/woman-hat-928x1024-310x342.jpg\\",\\"style_image\\":\\"image-center\\",\\"border-type\\":\\"top\\",\\"background_position\\":\\"left-top\\",\\"background_repeat\\":\\"repeat\\",\\"background_image-type\\":\\"image\\"}},{\\"element_id\\":\\"ua73296\\",\\"cols\\":[{\\"element_id\\":\\"t3ai296\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"0jq4613\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Accessories<\\\\/h3>\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_size_h3\\":\\"2\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type\\":\\"font_color_solid\\",\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"breakpoint_mobile\\":{\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"26\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"28\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"28\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"l7ve297\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"View more\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"transparent\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"small\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"bpce297\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"#000000\\",\\"divider_width\\":\\"40\\",\\"divider_align\\":\\"left\\",\\"divider_type\\":\\"custom\\"}}]}],\\"styling\\":{\\"margin_left\\":\\"-10\\",\\"margin_top\\":\\"-10\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"border-type\\":\\"top\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"40\\"}}}],\\"gutter\\":\\"gutter-narrow\\",\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"margin-top\\":\\"26\\",\\"margin-top_unit\\":\\"px\\",\\"padding_top\\":\\"0\\"}},{\\"element_id\\":\\"p2jz305\\",\\"cols\\":[{\\"element_id\\":\\"r0fn352\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"b28m457\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Upcoming<\\\\/h3>\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"75\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"breakpoint_mobile\\":{\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"45\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"45\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"60\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"j1l2353\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"600\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fashion\\\\/files\\\\/2019\\\\/08\\\\/retro-blazer-600x479.jpg\\",\\"style_image\\":\\"image-center\\",\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_vp\\":\\"30,100\\",\\"v_speed\\":\\"1\\",\\"v_dir\\":\\"up\\"}}},\\"breakpoint_mobile\\":{\\"margin_bottom\\":\\"30\\"}}}]},{\\"element_id\\":\\"dr02353\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"r99e354\\",\\"cols\\":[{\\"element_id\\":\\"7qse354\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"5hmt355\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>The Back-to-Work Power Suit<\\\\/h3>\\\\n<p>Fall is upon us and dressing up for work will be exciting all over again with these power suits.<\\\\/p>\\",\\"breakpoint_mobile\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"28\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"},\\"breakpoint_tablet\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"30\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"36\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"67nx357\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"See More\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"outline\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"margin_bottom\\":\\"20\\",\\"margin_top\\":\\"10\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\"}}]}],\\"styling\\":{\\"padding_opp_left\\":\\"1\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"-30\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"6\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_color\\":\\"#000000_0.13\\",\\"b_sh_blur\\":\\"20\\",\\"b_sh_vOffset\\":\\"0\\",\\"b_sh_hOffset\\":\\"0\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"8\\",\\"background_color\\":\\"#ffffff\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"margin_bottom_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"0\\",\\"margin_bottom\\":\\"5\\"},\\"breakpoint_tablet\\":{\\"margin_bottom_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"-10\\",\\"margin_bottom\\":\\"6\\"},\\"breakpoint_tablet_landscape\\":{\\"margin_bottom_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"-10\\",\\"margin_bottom\\":\\"6\\"}}}]}],\\"column_alignment\\":\\"col_align_bottom\\",\\"gutter\\":\\"gutter-none\\",\\"column_h\\":\\"1\\",\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"6\\"}},{\\"element_id\\":\\"kx06305\\",\\"cols\\":[{\\"element_id\\":\\"ivpf359\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"niex360\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"600\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fashion\\\\/files\\\\/2019\\\\/08\\\\/woman-grayscale-600x479.jpg\\",\\"style_image\\":\\"image-center\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"-10\\",\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_vp\\":\\"30,100\\",\\"v_speed\\":\\"1\\",\\"v_dir\\":\\"up\\"}}},\\"animation_effect_tab\\":\\"s_e_m\\",\\"breakpoint_mobile\\":{\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"0\\",\\"margin_bottom\\":\\"30\\"}}}]},{\\"element_id\\":\\"k44t360\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"6h9d361\\",\\"cols\\":[{\\"element_id\\":\\"j2rn362\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"43ne367\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>The Sultriest Swimsuits<\\\\/h3>\\\\n<p>Let your weekend getaways take care of themselves - we\\\\\\\\\\\'ve got you and your assets covered.<\\\\/p>\\",\\"breakpoint_mobile\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"28\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"30\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"36\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"h3uu368\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"See More\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"outline\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"margin_bottom\\":\\"20\\",\\"margin_top\\":\\"10\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\"}}]}],\\"styling\\":{\\"margin_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"8\\",\\"background_color\\":\\"#ffffff\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"margin_bottom\\":\\"5\\",\\"margin_right_unit\\":\\"%\\",\\"margin_right\\":\\"-30\\",\\"b_sh_color\\":\\"#000000_0.11\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"20\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"0\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"0\\"}}]}],\\"column_alignment\\":\\"col_align_bottom\\",\\"gutter\\":\\"gutter-none\\",\\"column_h\\":\\"1\\",\\"desktop_dir\\":\\"rtl\\",\\"tablet_dir\\":\\"rtl\\",\\"tablet_landscape_dir\\":\\"rtl\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_top\\":\\"0\\"}},{\\"element_id\\":\\"khs4305\\",\\"cols\\":[{\\"element_id\\":\\"8kow371\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"p41s375\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"600\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fashion\\\\/files\\\\/2019\\\\/08\\\\/woman-hat-grayscale-600x479.jpg\\",\\"style_image\\":\\"image-center\\",\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_vp\\":\\"30,100\\",\\"v_speed\\":\\"1\\",\\"v_dir\\":\\"up\\"}}},\\"breakpoint_mobile\\":{\\"margin_bottom\\":\\"30\\"}}}]},{\\"element_id\\":\\"g348376\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"g7kq377\\",\\"cols\\":[{\\"element_id\\":\\"otpw378\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"vaas378\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Top Accessory Trends<\\\\/h3>\\\\n<p>From caps, to headbands, to necklaces, to scarves - we\\\\\\\\\\\'ve got the most popular trends this season.<\\\\/p>\\",\\"breakpoint_mobile\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"28\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"30\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"36\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"9cb6379\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"See More\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"outline\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"margin_bottom\\":\\"20\\",\\"margin_top\\":\\"10\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\"}}]}],\\"styling\\":{\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"-10\\",\\"margin_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"8\\",\\"background_color\\":\\"#ffffff\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"b_sh_color\\":\\"#000000_0.10\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"20\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"0\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"0\\",\\"margin_bottom\\":\\"5\\",\\"breakpoint_mobile\\":{\\"margin_bottom_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"0\\",\\"margin_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom\\":\\"5\\",\\"padding_right\\":\\"6\\",\\"padding_top\\":\\"8\\"}}}]}],\\"column_alignment\\":\\"col_align_bottom\\",\\"gutter\\":\\"gutter-none\\",\\"column_h\\":\\"1\\",\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\"}},{\\"element_id\\":\\"hswg306\\",\\"cols\\":[{\\"element_id\\":\\"0lua380\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"7w57432\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Featured Products<\\\\/h3>\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"30\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_bottom\\":\\"35\\",\\"padding_bottom_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"24\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"products\\",\\"element_id\\":\\"ttqe381\\",\\"mod_settings\\":{\\"post_per_page_products\\":\\"4\\",\\"hide_page_nav_products\\":\\"yes\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"layout_products\\":\\"grid4\\",\\"hide_sales_badge\\":\\"no\\",\\"hide_rating_products\\":\\"no\\",\\"hide_add_to_cart_products\\":\\"no\\",\\"hide_price_products\\":\\"no\\",\\"unlink_post_title_products\\":\\"no\\",\\"show_product_tags\\":\\"no\\",\\"show_product_categories\\":\\"no\\",\\"hide_post_title_products\\":\\"no\\",\\"unlink_feat_img_products\\":\\"no\\",\\"hide_feat_img_products\\":\\"no\\",\\"description_products\\":\\"none\\",\\"height_slider\\":\\"variable\\",\\"show_arrow_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"wrap_slider\\":\\"yes\\",\\"effect_slider\\":\\"scroll\\",\\"speed_opt_slider\\":\\"normal\\",\\"scroll_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"1\\",\\"mob_visible_opt_slider\\":\\"0\\",\\"visible_opt_slider\\":\\"1\\",\\"layout_slider\\":\\"slider-default\\",\\"template_products\\":\\"list\\",\\"order_products\\":\\"desc\\",\\"orderby_products\\":\\"date\\",\\"hide_outofstock_products\\":\\"no\\",\\"hide_free_products\\":\\"no\\",\\"hide_child_products\\":\\"no\\",\\"category_products\\":\\"0|single\\",\\"query_products\\":\\"featured\\",\\"img_height_products\\":\\"287\\",\\"img_width_products\\":\\"262\\"}}]}],\\"styling\\":{\\"padding_bottom\\":\\"40\\",\\"padding_bottom_unit\\":\\"px\\"}},{\\"element_id\\":\\"jzpq781\\",\\"cols\\":[{\\"element_id\\":\\"ib4x780\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"layout-part\\",\\"element_id\\":\\"va5q782\\",\\"mod_settings\\":{\\"selected_layout_part\\":\\"ultra-fashion-newsletter-row\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\"}}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 8,
  'post_date' => '2019-08-27 04:19:25',
  'post_date_gmt' => '2019-08-27 04:19:25',
  'post_content' => '<!-- wp:shortcode -->[woocommerce_my_account]<!-- /wp:shortcode -->',
  'post_title' => 'My account',
  'post_excerpt' => '',
  'post_name' => 'my-account',
  'post_modified' => '2019-08-27 04:19:25',
  'post_modified_gmt' => '2019-08-27 04:19:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/my-account/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 2,
  'post_date' => '2019-08-27 04:14:56',
  'post_date_gmt' => '2019-08-27 04:14:56',
  'post_content' => '<!-- wp:paragraph -->
<p>This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:</p>
<!-- /wp:paragraph -->

<!-- wp:quote -->
<blockquote class="wp-block-quote"><p>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</p></blockquote>
<!-- /wp:quote -->

<!-- wp:paragraph -->
<p>...or something like this:</p>
<!-- /wp:paragraph -->

<!-- wp:quote -->
<blockquote class="wp-block-quote"><p>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</p></blockquote>
<!-- /wp:quote -->

<!-- wp:paragraph -->
<p>As a new WordPress user, you should go to <a href="https://themify.me/demo/themes/ultra-fashion/wp-admin/">your dashboard</a> to delete this page and create new pages for your content. Have fun!</p>
<!-- /wp:paragraph -->',
  'post_title' => 'Sample Page',
  'post_excerpt' => '',
  'post_name' => 'sample-page',
  'post_modified' => '2019-08-27 04:14:56',
  'post_modified_gmt' => '2019-08-27 04:14:56',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?page_id=2',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 5,
  'post_date' => '2019-08-27 04:19:25',
  'post_date_gmt' => '2019-08-27 04:19:25',
  'post_content' => '<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Shop',
  'post_excerpt' => '',
  'post_name' => 'shop',
  'post_modified' => '2019-08-29 06:56:46',
  'post_modified_gmt' => '2019-08-29 06:56:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/shop/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 149,
  'post_date' => '2019-08-30 00:52:57',
  'post_date_gmt' => '2019-08-30 00:52:57',
  'post_content' => '<!--themify_builder_static--><h3>Exclusive Discounts</h3> <p>Subscribe to our newsletter for a 10% discount!</p>
<!--/themify_builder_static-->',
  'post_title' => 'Ultra Fashion Newsletter',
  'post_excerpt' => '',
  'post_name' => 'ultra-fashion-newsletter',
  'post_modified' => '2019-08-30 18:49:29',
  'post_modified_gmt' => '2019-08-30 18:49:29',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/tbuilder-layout-part/ultra-fashion-newsletter/',
  'menu_order' => 0,
  'post_type' => 'tbuilder_layout_part',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"8wy9888\\",\\"cols\\":[{\\"element_id\\":\\"mam8888\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"btxl888\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Exclusive Discounts<\\\\/h3>\\\\n<p>Subscribe to our newsletter for a 10% discount!<\\\\/p>\\"}},{\\"mod_name\\":\\"optin\\",\\"element_id\\":\\"nlzt888\\",\\"mod_settings\\":{\\"label_firstname\\":\\"First Name\\",\\"default_fname\\":\\"John\\",\\"label_lastname\\":\\"Last Name\\",\\"default_lname\\":\\"Doe\\",\\"label_submit\\":\\"Subscribe\\",\\"message\\":\\"<p>Success!<\\\\/p>\\",\\"success_action\\":\\"s2\\",\\"lname_hide\\":\\"1\\",\\"fname_hide\\":\\"1\\",\\"layout\\":\\"tb_optin_horizontal\\",\\"provider\\":\\"mailchimp\\"}}],\\"grid_width\\":\\"36\\"},{\\"element_id\\":\\"hofc888\\",\\"grid_class\\":\\"col4-2\\",\\"grid_width\\":\\"60.8\\"}],\\"styling\\":{\\"padding_top\\":\\"16\\",\\"padding_opp_top\\":\\"1\\",\\"padding_bottom\\":\\"16\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-fashion\\\\/files\\\\/2019\\\\/08\\\\/newsletter-bg.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.1\\",\\"font_color\\":\\"#ffffff\\",\\"row_width\\":\\"fullwidth\\"}}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 145,
  'post_date' => '2019-08-30 00:43:00',
  'post_date_gmt' => '2019-08-30 00:43:00',
  'post_content' => '<!--themify_builder_static--><h3>Exclusive Discounts</h3>
<p>Subscribe to our newsletter for a 10% discount.</p>
<form id="mc-embedded-subscribe-form" class="validate" action="https://themify.us2.list-manage.com/subscribe/post?u=03462cf158e86ea00590274ab&amp;id=0f2a95e5de" method="post" name="mc-embedded-subscribe-form" novalidate="novalidate" target="_blank">
 
</form>
<!--/themify_builder_static-->',
  'post_title' => 'Ultra Fashion Newsletter Row',
  'post_excerpt' => '',
  'post_name' => 'ultra-fashion-newsletter-row',
  'post_modified' => '2019-09-02 21:16:13',
  'post_modified_gmt' => '2019-09-02 21:16:13',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/tbuilder-layout-part/ultra-fashion-newsletter-row/',
  'menu_order' => 0,
  'post_type' => 'tbuilder_layout_part',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"qakn931\\",\\"cols\\":[{\\"element_id\\":\\"414r931\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"7xvd931\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Exclusive Discounts<\\\\/h3>\\\\n<div class=\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"module module-text text-7-6-0-0     tb_lqm7542\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\">\\\\n<div class=\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"tb_text_wrap\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\">\\\\n<p>Subscribe to our newsletter for a 10% discount.<\\\\/p>\\\\n<\\\\/div>\\\\n<\\\\/div>\\\\n<div class=\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"module module-plain-text plain-text-7-6-0-1   tb_dgud896\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\">\\\\n<div class=\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"tb_text_wrap\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\">\\\\n<div id=\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"mc_embed_signup\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"><form id=\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"mc-embedded-subscribe-form\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"validate\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\" action=\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.us2.list-manage.com\\\\/subscribe\\\\/post?u=03462cf158e86ea00590274ab&amp;id=0f2a95e5de\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\" method=\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"post\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"mc-embedded-subscribe-form\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\" novalidate=\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"novalidate\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\" target=\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"_blank\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\">\\\\n<div id=\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"mc_embed_signup_scroll\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\">\\\\n<div class=\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"mc-field-group\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"> <\\\\/div>\\\\n<\\\\/div>\\\\n<\\\\/form><\\\\/div>\\\\n<\\\\/div>\\\\n<\\\\/div>\\"}},{\\"mod_name\\":\\"optin\\",\\"element_id\\":\\"r7r4931\\",\\"mod_settings\\":{\\"label_firstname\\":\\"First Name\\",\\"default_fname\\":\\"John\\",\\"label_lastname\\":\\"Last Name\\",\\"default_lname\\":\\"Doe\\",\\"label_submit\\":\\"Subscribe\\",\\"message\\":\\"<p>Success!<\\\\/p>\\",\\"success_action\\":\\"s2\\",\\"lname_hide\\":\\"1\\",\\"fname_hide\\":\\"1\\",\\"layout\\":\\"tb_optin_horizontal\\",\\"provider\\":\\"mailchimp\\",\\"b_r\\":\\"repeat\\",\\"b_i-type\\":\\"image\\",\\"mailchimp_list\\":\\"0f2a95e5de\\",\\"b_in_top_style\\":\\"none\\",\\"b_in-type\\":\\"all\\",\\"f_g_c-circle-radial\\":\\"\\",\\"f_c_t\\":\\"f_c_solid\\",\\"f_c_i\\":\\"#808080\\",\\"bg_c_i\\":\\"#ffffff\\"}}],\\"styling\\":{\\"font_color\\":\\"#ffffff\\"}},{\\"element_id\\":\\"be01931\\",\\"grid_class\\":\\"col4-2\\"}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"11\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"11\\",\\"background_position\\":\\"50,50\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-fashion\\\\/files\\\\/2019\\\\/08\\\\/newsletter-bg.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"row_width\\":\\"fullwidth\\",\\"background_type\\":\\"image\\"}}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 130,
  'post_date' => '2019-08-29 20:27:57',
  'post_date_gmt' => '2019-08-29 20:27:57',
  'post_content' => '<!--themify_builder_static--><img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/agnez-may.jpg" width="308" title="Agnez May" alt="Co-CEO" /> <h3> Agnez May </h3> Co-CEO<!--/themify_builder_static-->',
  'post_title' => 'Ultra Fashion Team GS',
  'post_excerpt' => '',
  'post_name' => 'tb_gs1305d6',
  'post_modified' => '2020-01-08 03:57:09',
  'post_modified_gmt' => '2020-01-08 03:57:09',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/tglobal-style/ultra-fashion-team-gs/',
  'menu_order' => 0,
  'post_type' => 'tglobal_style',
  'meta_input' => 
  array (
    'themify_global_style_type' => 'image',
    'hide_page_title' => 'yes',
    '_wp_old_slug' => 'ultra-fashion-team-gs',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"row5d68354d7e016\\",\\"cols\\":[{\\"element_id\\":\\"col5d68354d7e016\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"mod5d68354d7e016\\",\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"308\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/shoppe-fashion\\\\/files\\\\/2019\\\\/08\\\\/agnez-may.jpg\\",\\"style_image\\":\\"image-center\\",\\"i_t_sh_color\\":\\"#ebebeb\\",\\"i_t_sh_blur_unit\\":\\"px\\",\\"i_t_sh_blur\\":\\"0\\",\\"i_t_sh_vOffset_unit\\":\\"px\\",\\"i_t_sh_vOffset\\":\\"20\\",\\"i_t_sh_hOffset_unit\\":\\"px\\",\\"i_t_sh_hOffset\\":\\"-20\\",\\"title_image\\":\\"Agnez May\\",\\"i_t_m_bottom\\":\\"30\\",\\"caption_image\\":\\"Co-CEO\\",\\"i_t_sh_inset\\":\\"false\\",\\"background_repeat\\":\\"repeat\\",\\"background_image-circle-radial\\":\\"false\\",\\"background_image-type\\":\\"image\\",\\"b_sh_inset\\":\\"false\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient-type\\":\\"linear\\"}}]}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 125,
  'post_date' => '2019-08-29 20:12:31',
  'post_date_gmt' => '2019-08-29 20:12:31',
  'post_content' => '<!--themify_builder_static--><img src="https://themify.me/demo/themes/ultra-fashion/files/2019/08/nadya-summer.jpg" width="308" title="Nadya Catherine" alt="Nadya Catherine" /> <h3> Nadya Catherine </h3><!--/themify_builder_static-->',
  'post_title' => 'Team GS',
  'post_excerpt' => '',
  'post_name' => 'tb_gs1255d6',
  'post_modified' => '2020-01-08 03:57:09',
  'post_modified_gmt' => '2020-01-08 03:57:09',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/tglobal-style/team-gs/',
  'menu_order' => 0,
  'post_type' => 'tglobal_style',
  'meta_input' => 
  array (
    'themify_global_style_type' => 'image',
    'hide_page_title' => 'yes',
    '_wp_old_slug' => 'team-gs',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"row5d6831afa34cb\\",\\"styling\\":{\\"global_styles\\":\\" \\"},\\"cols\\":[{\\"element_id\\":\\"col5d6831afa34cb\\",\\"grid_class\\":\\"col-full\\",\\"styling\\":{\\"global_styles\\":\\" \\"},\\"modules\\":[{\\"element_id\\":\\"mod5d6831afa34cb\\",\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"308\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-fashion\\\\/files\\\\/2019\\\\/08\\\\/nadya-summer.jpg\\",\\"style_image\\":\\"image-center\\",\\"i_t_sh_color\\":\\"#ebebeb\\",\\"i_t_sh_blur_unit\\":\\"px\\",\\"i_t_sh_blur\\":\\"0\\",\\"i_t_sh_vOffset_unit\\":\\"px\\",\\"i_t_sh_vOffset\\":\\"20\\",\\"i_t_sh_hOffset_unit\\":\\"px\\",\\"i_t_sh_hOffset\\":\\"-20\\",\\"title_image\\":\\"Nadya Catherine\\",\\"i_t_m_bottom\\":\\"29\\",\\"i_t_m_bottom_unit\\":\\"px\\",\\"i_t_sh_inset\\":\\"false\\",\\"t_sh_t_blur_unit\\":\\"px\\",\\"t_sh_t_vShadow_unit\\":\\"px\\",\\"t_sh_t_hShadow_unit\\":\\"px\\",\\"letter_spacing_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_title_unit\\":\\"px\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":\\"false\\",\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"}}]}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 166,
  'post_date' => '2019-08-30 03:08:55',
  'post_date_gmt' => '2019-08-30 03:08:55',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'The Girlfriend Cropped Sleep Set',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia.',
  'post_name' => '166',
  'post_modified' => '2019-08-31 02:46:19',
  'post_modified_gmt' => '2019-08-31 02:46:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?post_type=product&#038;p=166',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1567219579:172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"fxr5661\\",\\"cols\\":[{\\"element_id\\":\\"sryv662\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_edit_last' => '172',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '164',
    '_regular_price' => '140',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '140',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'sexy',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-wearing-sexy-suit.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 163,
  'post_date' => '2019-08-30 03:07:58',
  'post_date_gmt' => '2019-08-30 03:07:58',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.

',
  'post_title' => 'Deep V Silk Cami',
  'post_excerpt' => 'Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_name' => '163',
  'post_modified' => '2019-08-31 02:46:15',
  'post_modified_gmt' => '2019-08-31 02:46:15',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?post_type=product&#038;p=163',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1567219575:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"32jr42\\",\\"cols\\":[{\\"element_id\\":\\"r37o43\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '165',
    '_regular_price' => '150',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '150',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'dress, sexy',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-with-sunglasses.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 117,
  'post_date' => '2019-08-29 04:39:28',
  'post_date_gmt' => '2019-08-29 04:39:28',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'The Perfect Jean Shorts',
  'post_excerpt' => 'Adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.',
  'post_name' => '117',
  'post_modified' => '2019-08-31 02:46:09',
  'post_modified_gmt' => '2019-08-31 02:46:09',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?post_type=product&#038;p=117',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1567219569:172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"t322497\\",\\"cols\\":[{\\"element_id\\":\\"ikie498\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_edit_last' => '172',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '108',
    '_regular_price' => '165',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '165',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_visibility' => 'featured',
    'product_cat' => 'demin',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-in-casual-style.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 116,
  'post_date' => '2019-08-29 04:38:40',
  'post_date_gmt' => '2019-08-29 04:38:40',
  'post_content' => 'Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.',
  'post_title' => 'The Coco Sunnies',
  'post_excerpt' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.',
  'post_name' => '116',
  'post_modified' => '2019-08-31 02:46:00',
  'post_modified_gmt' => '2019-08-31 02:46:00',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?post_type=product&#038;p=116',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1567219560:172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"5q9m411\\",\\"cols\\":[{\\"element_id\\":\\"el3a413\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_edit_last' => '172',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '162',
    '_regular_price' => '200',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '200',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'sweater',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-with-sunglass-and-swater.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 115,
  'post_date' => '2019-08-29 04:37:48',
  'post_date_gmt' => '2019-08-29 04:37:48',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'Luella Waffle Kimono',
  'post_excerpt' => 'Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_name' => '115',
  'post_modified' => '2019-08-31 02:45:55',
  'post_modified_gmt' => '2019-08-31 02:45:55',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?post_type=product&#038;p=115',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1567219555:172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"okjq800\\",\\"cols\\":[{\\"element_id\\":\\"b4sb800\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_edit_last' => '172',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '105',
    '_regular_price' => '125',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '125',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_visibility' => 'featured',
    'product_cat' => 'sexy',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fashion/files/2019/08/sexy-cordoray.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 114,
  'post_date' => '2019-08-29 04:36:57',
  'post_date_gmt' => '2019-08-29 04:36:57',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.',
  'post_title' => 'Alexis One-Piece Jumpsuit',
  'post_excerpt' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.',
  'post_name' => '114',
  'post_modified' => '2019-08-31 02:45:50',
  'post_modified_gmt' => '2019-08-31 02:45:50',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?post_type=product&#038;p=114',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1567219550:172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"jjhr18\\",\\"cols\\":[{\\"element_id\\":\\"vb4k19\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_edit_last' => '172',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '160',
    '_regular_price' => '180',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '180',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'dress',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-with-gray-silk.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 113,
  'post_date' => '2019-08-29 04:36:12',
  'post_date_gmt' => '2019-08-29 04:36:12',
  'post_content' => 'Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.',
  'post_title' => 'Flower Bomb Leather Jacket',
  'post_excerpt' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.
',
  'post_name' => '113',
  'post_modified' => '2019-08-31 02:45:44',
  'post_modified_gmt' => '2019-08-31 02:45:44',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?post_type=product&#038;p=113',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1567219544:172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"7hsp2\\",\\"cols\\":[{\\"element_id\\":\\"3r2j4\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_edit_last' => '172',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '159',
    '_regular_price' => '250',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '250',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'jacket',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-with-hat-and-leather-jacket.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 112,
  'post_date' => '2019-08-29 04:35:17',
  'post_date_gmt' => '2019-08-29 04:35:17',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'Rosebud Salve Wrap Blouse',
  'post_excerpt' => 'Voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.',
  'post_name' => '112',
  'post_modified' => '2019-08-31 02:45:37',
  'post_modified_gmt' => '2019-08-31 02:45:37',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?post_type=product&#038;p=112',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1567219537:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"unsx356\\",\\"cols\\":[{\\"element_id\\":\\"0psr356\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '102',
    '_regular_price' => '140',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '140',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'dress',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fashion/files/2019/08/exotic-asian-dress.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 111,
  'post_date' => '2019-08-29 04:33:02',
  'post_date_gmt' => '2019-08-29 04:33:02',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.',
  'post_title' => 'The Perfect Cropped Jeans',
  'post_excerpt' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur.',
  'post_name' => '111',
  'post_modified' => '2019-08-31 02:45:30',
  'post_modified_gmt' => '2019-08-31 02:45:30',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?post_type=product&#038;p=111',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1567219530:172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"9uxv69\\",\\"cols\\":[{\\"element_id\\":\\"2l0j70\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_edit_last' => '172',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '101',
    '_regular_price' => '170',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '170',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_visibility' => 'featured',
    'product_cat' => 'demin',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fashion/files/2019/08/denim-in-hills.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 110,
  'post_date' => '2019-08-29 04:31:01',
  'post_date_gmt' => '2019-08-29 04:31:01',
  'post_content' => 'Deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum. Excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum.',
  'post_title' => 'The Great V Cami',
  'post_excerpt' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias.',
  'post_name' => '110',
  'post_modified' => '2019-08-31 02:45:24',
  'post_modified_gmt' => '2019-08-31 02:45:24',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?post_type=product&#038;p=110',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1567219524:172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"r6rh416\\",\\"cols\\":[{\\"element_id\\":\\"g2w6417\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_edit_last' => '172',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '100',
    '_regular_price' => '115',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '115',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_visibility' => 'featured',
    'product_cat' => 'sexy',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fashion/files/2019/08/black-tanktop.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 109,
  'post_date' => '2019-08-29 04:29:35',
  'post_date_gmt' => '2019-08-29 04:29:35',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'Lisbon Sisters Dress',
  'post_excerpt' => 'Voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est qui dolorem ipsum quia dolor sit amet consectetur adipisci velit.',
  'post_name' => '109',
  'post_modified' => '2019-08-31 02:45:13',
  'post_modified_gmt' => '2019-08-31 02:45:13',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?post_type=product&#038;p=109',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1567219513:172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"ln94554\\",\\"cols\\":[{\\"element_id\\":\\"61jk554\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_edit_last' => '172',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '98',
    '_regular_price' => '170',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '170',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_visibility' => 'featured',
    'product_cat' => 'dress',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fashion/files/2019/08/asian-in-white-dress.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 97,
  'post_date' => '2019-08-29 04:28:29',
  'post_date_gmt' => '2019-08-29 04:28:29',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Hailey Amber Knit Sweater',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia.',
  'post_name' => '97',
  'post_modified' => '2019-08-31 02:45:06',
  'post_modified_gmt' => '2019-08-31 02:45:06',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?post_type=product&#038;p=97',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1567219506:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"ku2w855\\",\\"cols\\":[{\\"element_id\\":\\"pbw2856\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '161',
    '_regular_price' => '160',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '160',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'sweater',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fashion/files/2019/08/woman-wear-zig-zag-sweater-motive.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 13,
  'post_date' => '2019-08-27 04:22:11',
  'post_date_gmt' => '2019-08-27 04:22:11',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '13',
  'post_modified' => '2019-09-02 21:17:56',
  'post_modified_gmt' => '2019-09-02 21:17:56',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?p=13',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '10',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 14,
  'post_date' => '2019-08-27 04:22:11',
  'post_date_gmt' => '2019-08-27 04:22:11',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '14',
  'post_modified' => '2019-09-02 21:17:56',
  'post_modified_gmt' => '2019-09-02 21:17:56',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?p=14',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '5',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 22,
  'post_date' => '2019-08-27 04:24:46',
  'post_date_gmt' => '2019-08-27 04:24:46',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '22',
  'post_modified' => '2019-09-02 21:17:56',
  'post_modified_gmt' => '2019-09-02 21:17:56',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?p=22',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '15',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 21,
  'post_date' => '2019-08-27 04:24:46',
  'post_date_gmt' => '2019-08-27 04:24:46',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '21',
  'post_modified' => '2019-09-02 21:17:56',
  'post_modified_gmt' => '2019-09-02 21:17:56',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fashion/?p=21',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '18',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );



function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_themify-social-links" );
$widgets[1002] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_themify-social-links" );
$widgets[1003] = array (
  'title' => 'Social',
  'show_link_name' => 'on',
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'vertical',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_woocommerce_product_categories" );
$widgets[1004] = array (
  'title' => 'Product categories',
  'orderby' => 'name',
  'dropdown' => 0,
  'count' => 0,
  'hierarchical' => 1,
  'show_children_only' => 0,
  'hide_empty' => 0,
  'max_depth' => '',
);
update_option( "widget_woocommerce_product_categories", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1005] = array (
  'title' => 'Sitemap',
  'nav_menu' => themify_import_get_term_id_from_slug( "main-navigation" ),
);
update_option( "widget_nav_menu", $widgets );



$sidebars_widgets = array (
  'social-widget' => 
  array (
    0 => 'themify-social-links-1002',
  ),
  'footer-widget-1' => 
  array (
    0 => 'themify-social-links-1003',
  ),
  'footer-widget-2' => 
  array (
    0 => 'woocommerce_product_categories-1004',
  ),
  'footer-widget-3' => 
  array (
    0 => 'nav_menu-1005',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "main-navigation" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );


$homepage = get_posts( array( 'name' => 'home', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			
	ob_start(); ?>a:111:{s:21:"setting-webfonts_list";s:11:"recommended";s:22:"setting-default_layout";s:8:"sidebar1";s:27:"setting-default_post_layout";s:9:"list-post";s:19:"setting-post_filter";s:2:"no";s:23:"setting-disable_masonry";s:3:"yes";s:19:"setting-post_gutter";s:6:"gutter";s:30:"setting-default_layout_display";s:7:"content";s:25:"setting-default_more_text";s:4:"More";s:21:"setting-index_orderby";s:4:"date";s:19:"setting-index_order";s:4:"DESC";s:30:"setting-default_media_position";s:5:"above";s:31:"setting-image_post_feature_size";s:5:"blank";s:32:"setting-default_page_post_layout";s:8:"sidebar1";s:37:"setting-default_page_post_layout_type";s:7:"classic";s:42:"setting-default_page_single_media_position";s:5:"above";s:38:"setting-image_post_single_feature_size";s:5:"blank";s:36:"setting-search-result_layout_display";s:7:"content";s:36:"setting-search-result_media_position";s:5:"above";s:27:"setting-default_page_layout";s:8:"sidebar1";s:40:"setting-custom_post_tglobal_style_single";s:8:"sidebar1";s:38:"setting-default_portfolio_index_layout";s:12:"sidebar-none";s:43:"setting-default_portfolio_index_post_layout";s:5:"grid3";s:29:"setting-portfolio_post_filter";s:3:"yes";s:33:"setting-portfolio_disable_masonry";s:3:"yes";s:24:"setting-portfolio_gutter";s:6:"gutter";s:39:"setting-default_portfolio_index_display";s:4:"none";s:50:"setting-default_portfolio_index_post_meta_category";s:3:"yes";s:49:"setting-default_portfolio_index_unlink_post_image";s:3:"yes";s:39:"setting-default_portfolio_single_layout";s:12:"sidebar-none";s:54:"setting-default_portfolio_single_portfolio_layout_type";s:9:"fullwidth";s:50:"setting-default_portfolio_single_unlink_post_image";s:3:"yes";s:22:"themify_portfolio_slug";s:7:"project";s:31:"themify_portfolio_category_slug";s:18:"portfolio-category";s:19:"setting-shop_layout";s:12:"sidebar-none";s:27:"setting-shop_archive_layout";s:12:"sidebar-none";s:23:"setting-products_layout";s:5:"grid4";s:31:"setting-product_disable_masonry";s:2:"no";s:30:"setting-shop_products_per_page";s:2:"12";s:29:"setting-single_product_layout";s:12:"sidebar-none";s:30:"setting-related_products_limit";s:1:"3";s:32:"setting-product_description_type";s:4:"long";s:53:"setting-customizer_responsive_design_tablet_landscape";s:4:"1280";s:43:"setting-customizer_responsive_design_tablet";s:3:"768";s:43:"setting-customizer_responsive_design_mobile";s:3:"680";s:33:"setting-mobile_menu_trigger_point";s:3:"900";s:24:"setting-gallery_lightbox";s:8:"lightbox";s:21:"setting-header_design";s:12:"header-block";s:19:"setting_search_form";s:11:"live_search";s:19:"setting-exclude_rss";s:2:"on";s:22:"setting-header_widgets";s:17:"headerwidget-2col";s:21:"setting-footer_design";s:15:"footer-left-col";s:22:"setting-use_float_back";s:2:"on";s:22:"setting-footer_widgets";s:17:"footerwidget-3col";s:23:"setting-mega_menu_posts";s:1:"5";s:29:"setting-mega_menu_image_width";s:3:"180";s:30:"setting-mega_menu_image_height";s:3:"120";s:27:"setting-imagefilter_applyto";s:9:"allimages";s:29:"setting-color_animation_speed";s:1:"5";s:29:"setting-relationship_taxonomy";s:8:"category";s:37:"setting-relationship_taxonomy_entries";s:1:"3";s:45:"setting-relationship_taxonomy_display_content";s:4:"none";s:30:"setting-single_slider_autoplay";s:3:"off";s:27:"setting-single_slider_speed";s:6:"normal";s:28:"setting-single_slider_effect";s:5:"slide";s:28:"setting-single_slider_height";s:4:"auto";s:18:"setting-more_posts";s:8:"infinite";s:19:"setting-entries_nav";s:8:"numbered";s:24:"setting-footer_text_left";s:224:"Create the ultimate fashion destination with the Ultra Fashion skin. Ultra is a powerful eCommerce theme created by Themify, using WooCommerce, and is highly customizable. Discover the entire collection of Ultra skins today!";s:25:"setting-img_php_base_size";s:5:"large";s:27:"setting-global_feature_size";s:5:"blank";s:22:"setting-link_icon_type";s:9:"font-icon";s:32:"setting-link_type_themify-link-0";s:10:"image-icon";s:33:"setting-link_title_themify-link-0";s:7:"Twitter";s:31:"setting-link_img_themify-link-0";s:107:"https://themify.me/demo/themes/ultra-fashion/wp-content/themes/themify-ultra/themify/img/social/twitter.png";s:32:"setting-link_type_themify-link-1";s:10:"image-icon";s:33:"setting-link_title_themify-link-1";s:8:"Facebook";s:31:"setting-link_img_themify-link-1";s:108:"https://themify.me/demo/themes/ultra-fashion/wp-content/themes/themify-ultra/themify/img/social/facebook.png";s:32:"setting-link_type_themify-link-2";s:10:"image-icon";s:33:"setting-link_title_themify-link-2";s:7:"YouTube";s:31:"setting-link_img_themify-link-2";s:107:"https://themify.me/demo/themes/ultra-fashion/wp-content/themes/themify-ultra/themify/img/social/youtube.png";s:32:"setting-link_type_themify-link-3";s:10:"image-icon";s:33:"setting-link_title_themify-link-3";s:9:"Pinterest";s:31:"setting-link_img_themify-link-3";s:109:"https://themify.me/demo/themes/ultra-fashion/wp-content/themes/themify-ultra/themify/img/social/pinterest.png";s:32:"setting-link_type_themify-link-8";s:9:"font-icon";s:33:"setting-link_title_themify-link-8";s:9:"Instagram";s:32:"setting-link_link_themify-link-8";s:34:"https://www.instagram.com/themify/";s:33:"setting-link_ficon_themify-link-8";s:12:"ti-instagram";s:32:"setting-link_type_themify-link-4";s:9:"font-icon";s:33:"setting-link_title_themify-link-4";s:7:"Twitter";s:32:"setting-link_link_themify-link-4";s:27:"https://twitter.com/themify";s:33:"setting-link_ficon_themify-link-4";s:10:"fa-twitter";s:32:"setting-link_type_themify-link-5";s:9:"font-icon";s:33:"setting-link_title_themify-link-5";s:8:"Facebook";s:32:"setting-link_link_themify-link-5";s:32:"https://www.facebook.com/themify";s:33:"setting-link_ficon_themify-link-5";s:11:"fa-facebook";s:32:"setting-link_type_themify-link-6";s:9:"font-icon";s:33:"setting-link_title_themify-link-6";s:7:"YouTube";s:33:"setting-link_ficon_themify-link-6";s:10:"fa-youtube";s:32:"setting-link_type_themify-link-7";s:9:"font-icon";s:33:"setting-link_title_themify-link-7";s:9:"Pinterest";s:33:"setting-link_ficon_themify-link-7";s:12:"fa-pinterest";s:22:"setting-link_field_ids";s:307:"{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-8":"themify-link-8","themify-link-4":"themify-link-4","themify-link-5":"themify-link-5","themify-link-6":"themify-link-6","themify-link-7":"themify-link-7"}";s:23:"setting-link_field_hash";s:1:"9";s:30:"setting-page_builder_is_active";s:6:"enable";s:41:"setting-page_builder_animation_appearance";s:4:"none";s:42:"setting-page_builder_animation_parallax_bg";s:4:"none";s:44:"setting-page_builder_animation_scroll_effect";s:4:"none";s:44:"setting-page_builder_animation_sticky_scroll";s:4:"none";s:27:"setting-page_builder_expiry";s:1:"2";s:4:"skin";s:7:"fashion";s:13:"import_images";s:2:"on";}<?php $themify_data = unserialize( ob_get_clean() );

	themify_set_data( $themify_data );
	
}
themify_do_demo_import();