<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if ( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;

		$post = array();

		$upload = wp_upload_bits( 'themify-placeholder.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post = array(
				'post_mime_type' => $info['type']
			);
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$placeholder_image = wp_insert_attachment( $post, $upload['file'] );
		require_once( ABSPATH . 'wp-admin/includes/image.php' );
		wp_update_attachment_metadata( $placeholder_image, wp_generate_attachment_metadata( $placeholder_image, $upload['file'] ) );
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) || ! isset( $processed_terms[ intval( $term['parent'] ) ] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if ( ! empty( $placeholder ) && ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 5,
  'name' => 'Web',
  'slug' => 'web',
  'term_group' => 0,
  'taxonomy' => 'portfolio-category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 6,
  'name' => 'Design',
  'slug' => 'design',
  'term_group' => 0,
  'taxonomy' => 'portfolio-category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 7,
  'name' => 'Marketing',
  'slug' => 'marketing',
  'term_group' => 0,
  'taxonomy' => 'portfolio-category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 3,
  'name' => 'Main Navigation',
  'slug' => 'main-navigation',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 4,
  'name' => 'Footer Menu',
  'slug' => 'footer-menu',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 87,
  'post_date' => '2020-03-11 03:29:35',
  'post_date_gmt' => '2020-03-11 03:29:35',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/about-pic-932x530.jpg" width="932" alt="about-pic" srcset="https://themify.me/demo/themes/ultra-profile/files/2020/03/about-pic.jpg 932w, https://themify.me/demo/themes/ultra-profile/files/2020/03/about-pic-600x341.jpg 600w, https://themify.me/demo/themes/ultra-profile/files/2020/03/about-pic-768x437.jpg 768w" sizes="(max-width: 932px) 100vw, 932px" />
<h1>About</h1> <h3>I\'m Natalie Smith</h3> <p>Was born in New York City. Ever since I was a kid, my passion has always been design and creative works in general. I\'ve transited from traditional art to digital world. My core focus now is copywriting, marketing and web design.</p>
<img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/arrow-down-32x82.png" width="32" alt="arrow-down" />
<h2>Background</h2> <h4>Culture</h4> <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets.</p> <h4>Education</h4> <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. </p>
<img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/photograph-499x590.jpg" width="499" alt="photograph" />
<img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/award-icon-77x59.png" width="77" alt="award-icon" />
<h2>Awards</h2>
<h4>2020</h4>
<h3>Best Web Design</h3>
<h4>2019</h4>
<h3>Creative ad Award</h3>
<h4>2017</h4>
<h3>Best of Reel 2017</h3>
<h4>2016</h4>
<h3>Design of The Year</h3>
<img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/arrow-right-82x32.png" width="82" alt="arrow-right" />
<h2>Expertises</h2>
<h4>Design</h4>

<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. </p>
<h4>Writing</h4>

<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. </p>
<h4>Marketing</h4>

<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. </p>
<h4>Video</h4>

<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. </p>
<a href="https://themify.me/demo/themes/ultra-profile/portfolio/" > View Portfolio </a>
<h2>Social</h2>
<a href="https://twitter.com/themify"> </a>
<h4>Twitter</h4> <p>12k followers</p>
<a href="https://www.facebook.com/themify"> </a>
<h4>Facebook</h4> <p>30k likes</p>
<a href="https://www.youtube.com/user/themifyme"> </a>
<h4>Youtube</h4> <p>22k subscribers</p>
<a href="https://www.instagram.com/themify/"> </a>
<h4>Instagram</h4> <p>8k followers</p>
<h2>Have a project in mind?</h2>
<p>If you have a great idea, reach out to me. Whether it is a small or big project, I will listen first and get back to you with a plan. </p>
<a href="https://themify.me/demo/themes/ultra-profile/contact/" > Contact Me </a><!--/themify_builder_static-->',
  'post_title' => 'About',
  'post_excerpt' => '',
  'post_name' => 'about',
  'post_modified' => '2020-06-06 02:46:56',
  'post_modified_gmt' => '2020-06-06 02:46:56',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?page_id=87',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"alqw556\\",\\"cols\\":[{\\"element_id\\":\\"7tmp557\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ipqx183\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/about-pic.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"width_image\\":\\"932\\",\\"breakpoint_mobile\\":{\\"checkbox_i_t_m_apply_all\\":false,\\"i_t_m_left_unit\\":\\"px\\",\\"i_t_m_opp_left\\":false,\\"i_t_m_bottom_unit\\":\\"px\\",\\"i_t_m_right_unit\\":\\"px\\",\\"i_t_m_opp_top\\":false,\\"i_t_m_top_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"},\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_width_unit\\":\\"px\\",\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_speed\\":\\"1\\",\\"v_dir\\":\\"up\\"}}}}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"lxdg314\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"element_id\\":\\"3qt0431\\",\\"cols\\":[{\\"element_id\\":\\"k3nn432\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"tkey461\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>About<\\\\/h1>\\\\n<h3>I\\\'m Natalie Smith<\\\\/h3>\\\\n<p>Was born in New York City. Ever since I was a kid, my passion has always been design and creative works in general. I\\\'ve transited from traditional art to digital world. My core focus now is copywriting, marketing and web design.<\\\\/p>\\"}}]}],\\"styling\\":{\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"-50\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"10\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom\\":\\"8\\",\\"padding_right\\":\\"10\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"8\\",\\"background_color\\":\\"#ffffff\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"b_sh_inset\\":false,\\"b_sh_color\\":\\"#000000_0.05\\",\\"b_sh_spread_unit\\":\\"px\\",\\"b_sh_spread\\":\\"5\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"10\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"5\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"2\\",\\"border-type\\":\\"top\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"-20\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"0\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"0\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"0\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"0\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"-20\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"-20\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"},\\"global_styles\\":\\"tb_gs2765ec\\"}}]}],\\"column_alignment\\":\\"col_align_bottom\\",\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"120\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top\\":\\"120\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"80\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"70\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"70\\"},\\"hide_anchor\\":false,\\"breakpoint_tablet_landscape\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"100\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"100\\"}}},{\\"element_id\\":\\"746e397\\",\\"cols\\":[{\\"element_id\\":\\"tn4p400\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"450c106\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"32\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/arrow-down-32x82.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-top\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"50\\",\\"margin_opp_top\\":false}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"qjxw498\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Background<\\\\/h2>\\\\n<h4>Culture<\\\\/h4>\\\\n<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\\\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets.<\\\\/p>\\\\n<h4>Education<\\\\/h4>\\\\n<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\\\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. <\\\\/p>\\"}}],\\"styling\\":{\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"xe4b122\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"cepn100\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":\\"1\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/photograph-499x590.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-top\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"margin_top\\":\\"80\\",\\"width_image\\":\\"499\\",\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_speed\\":\\"1\\",\\"v_dir\\":\\"up\\"}}},\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_width_unit\\":\\"px\\"}}]}],\\"col_tablet\\":\\"column4-2\\",\\"styling\\":{\\"breakpoint_tablet\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\",\\"h4_margin_bottom_unit\\":\\"px\\",\\"h4_margin_top_unit\\":\\"px\\",\\"t_shh4_blur_unit\\":\\"px\\",\\"t_shh4_vShadow_unit\\":\\"px\\",\\"t_shh4_hShadow_unit\\":\\"px\\",\\"letter_spacing_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"25\\",\\"font_gradient_color_h4-circle-radial\\":false,\\"font_gradient_color_h4-gradient-angle\\":\\"180\\",\\"font_gradient_color_h4-gradient-type\\":\\"linear\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"45\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"element_id\\":\\"hwgb276\\",\\"cols\\":[{\\"element_id\\":\\"n3h1278\\",\\"grid_class\\":\\"col4-1\\",\\"grid_width\\":15},{\\"element_id\\":\\"hyf0100\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"h4os263\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"77\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/award-icon-77x59.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"t3f0602\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Awards<\\\\/h2>\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"element_id\\":\\"d6kq575\\",\\"cols\\":[{\\"element_id\\":\\"6tv8576\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ugxl648\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>2020<\\\\/h4>\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"40\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"25\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"}}]},{\\"element_id\\":\\"0rv0577\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"33r6864\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Best Web Design<\\\\/h3>\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"30\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"breakpoint_mobile\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"30\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_color\\":\\"#000000\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"font_color\\":\\"#ffffff\\",\\"padding_left\\":\\"30\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"30\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"30\\",\\"padding_bottom\\":\\"20\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#4d4d4d\\",\\"border-type\\":\\"bottom\\",\\"breakpoint_mobile\\":{\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_color\\":\\"#ffffff\\"},\\"animation_effect\\":\\"fadeInUp\\"}},{\\"element_id\\":\\"7i2h882\\",\\"cols\\":[{\\"element_id\\":\\"8vpn885\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"4tvc886\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>2019<\\\\/h4>\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"40\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"25\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"}}]},{\\"element_id\\":\\"cqq9886\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"lp76887\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Creative ad Award<\\\\/h3>\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"30\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_color\\":\\"#000000\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"font_color\\":\\"#ffffff\\",\\"padding_left\\":\\"30\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"30\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"30\\",\\"padding_bottom\\":\\"20\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#4d4d4d\\",\\"border-type\\":\\"bottom\\"}},{\\"element_id\\":\\"w6zz854\\",\\"cols\\":[{\\"element_id\\":\\"jlyn854\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"wgj1855\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>2017<\\\\/h4>\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"40\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"25\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"}}]},{\\"element_id\\":\\"meq4855\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"f69f855\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Best of Reel 2017<\\\\/h3>\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"30\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_color\\":\\"#000000\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"font_color\\":\\"#ffffff\\",\\"padding_left\\":\\"30\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"30\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"30\\",\\"padding_bottom\\":\\"20\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#4d4d4d\\",\\"border-type\\":\\"bottom\\"}},{\\"element_id\\":\\"3h46917\\",\\"cols\\":[{\\"element_id\\":\\"u7j4917\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"k4ol918\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>2016<\\\\/h4>\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"40\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"25\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"}}]},{\\"element_id\\":\\"jpmu918\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"mfrf918\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Design of The Year<\\\\/h3>\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"30\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_color\\":\\"#000000\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"font_color\\":\\"#ffffff\\",\\"padding_left\\":\\"30\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"30\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"30\\",\\"padding_bottom\\":\\"20\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#4d4d4d\\",\\"border-type\\":\\"bottom\\"}}],\\"grid_width\\":64},{\\"element_id\\":\\"3h71101\\",\\"grid_class\\":\\"col4-1\\",\\"grid_width\\":14.5999999999999996447286321199499070644378662109375}],\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"padding_top\\":\\"120\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"hide_anchor\\":false,\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"0\\",\\"h4_margin_bottom_unit\\":\\"px\\",\\"h4_margin_top_unit\\":\\"px\\",\\"t_shh4_blur_unit\\":\\"px\\",\\"t_shh4_vShadow_unit\\":\\"px\\",\\"t_shh4_hShadow_unit\\":\\"px\\",\\"letter_spacing_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_gradient_color_h4-circle-radial\\":false,\\"font_gradient_color_h4-gradient-angle\\":\\"180\\",\\"font_gradient_color_h4-gradient-type\\":\\"linear\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"100\\"},\\"h2_margin_bottom_unit\\":\\"px\\",\\"h2_margin_top_unit\\":\\"px\\",\\"t_shh2_blur_unit\\":\\"px\\",\\"t_shh2_vShadow_unit\\":\\"px\\",\\"t_shh2_hShadow_unit\\":\\"px\\",\\"letter_spacing_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"font_size_h2_unit\\":\\"px\\",\\"font_gradient_color_h2-circle-radial\\":false,\\"font_gradient_color_h2-gradient-angle\\":\\"180\\",\\"font_gradient_color_h2-gradient-type\\":\\"linear\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\"}},{\\"element_id\\":\\"8ru2201\\",\\"cols\\":[{\\"element_id\\":\\"z2xd202\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"z5dv533\\",\\"cols\\":[{\\"element_id\\":\\"kpmf535\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"5sfb122\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"82\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/arrow-right-82x32.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-top\\"}}],\\"grid_width\\":11.5999999999999996447286321199499070644378662109375},{\\"element_id\\":\\"ddd8536\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"um7k250\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Expertises<\\\\/h2>\\"}}],\\"grid_width\\":88.400000000000005684341886080801486968994140625,\\"styling\\":{\\"padding_bottom\\":0,\\"padding_bottom_unit\\":\\"px\\",\\"padding_top\\":13,\\"padding_top_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"padding_left\\":39,\\"padding_left_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"padding_left\\":33,\\"padding_left_unit\\":\\"px\\"}}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"checkbox_margin_apply_all\\":\\"1\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false}},{\\"element_id\\":\\"jzcn825\\",\\"cols\\":[{\\"element_id\\":\\"na6f826\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"nek1596\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Design<\\\\/h4>\\",\\"breakpoint_tablet\\":{\\"h4_margin_bottom_unit\\":\\"px\\",\\"h4_margin_top_unit\\":\\"px\\",\\"t_shh4_blur_unit\\":\\"px\\",\\"t_shh4_vShadow_unit\\":\\"px\\",\\"t_shh4_hShadow_unit\\":\\"px\\",\\"letter_spacing_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_gradient_color_h4-circle-radial\\":false,\\"font_gradient_color_h4-gradient-angle\\":\\"180\\",\\"font_gradient_color_h4-gradient-type\\":\\"linear\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h4\\":\\"25\\"}}},{\\"mod_name\\":\\"progressbar\\",\\"element_id\\":\\"emlu645\\",\\"mod_settings\\":{\\"hide_percentage_text\\":\\"yes\\",\\"progress_bars\\":[{\\"bar_percentage\\":\\"90\\",\\"bar_percentage_only_label\\":false,\\"null\\":\\"yes\\",\\"bar_color\\":\\"#000000\\"}],\\"checkbox_b_m_apply_all\\":false,\\"b_m_left_unit\\":\\"px\\",\\"b_m_opp_left\\":false,\\"b_m_bottom_unit\\":\\"px\\",\\"b_m_bottom\\":\\"30\\",\\"b_m_right_unit\\":\\"px\\",\\"b_m_opp_top\\":false,\\"b_m_top_unit\\":\\"px\\",\\"b_m_top\\":\\"0\\",\\"checkbox_b_p_apply_all\\":\\"1\\",\\"b_p_left_unit\\":\\"px\\",\\"b_p_opp_left\\":false,\\"b_p_bottom_unit\\":\\"px\\",\\"b_p_right_unit\\":\\"px\\",\\"b_p_opp_top\\":false,\\"b_p_top_unit\\":\\"px\\",\\"mx_h_unit\\":\\"px\\",\\"mi_h_unit\\":\\"px\\",\\"ht_auto_height\\":false,\\"ht_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"0\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"margin_top\\":\\"0\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"0\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"da5v755\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\\\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. <\\\\/p>\\"}}]},{\\"element_id\\":\\"lctd827\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"rxt0876\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Writing<\\\\/h4>\\",\\"breakpoint_tablet\\":{\\"h4_margin_bottom_unit\\":\\"px\\",\\"h4_margin_top_unit\\":\\"px\\",\\"t_shh4_blur_unit\\":\\"px\\",\\"t_shh4_vShadow_unit\\":\\"px\\",\\"t_shh4_hShadow_unit\\":\\"px\\",\\"letter_spacing_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"25\\",\\"font_gradient_color_h4-circle-radial\\":false,\\"font_gradient_color_h4-gradient-angle\\":\\"180\\",\\"font_gradient_color_h4-gradient-type\\":\\"linear\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"}}},{\\"mod_name\\":\\"progressbar\\",\\"element_id\\":\\"ubyf762\\",\\"mod_settings\\":{\\"hide_percentage_text\\":\\"yes\\",\\"progress_bars\\":[{\\"bar_percentage\\":\\"85\\",\\"bar_percentage_only_label\\":false,\\"null\\":\\"yes\\",\\"bar_color\\":\\"#000000\\"}],\\"checkbox_b_m_apply_all\\":false,\\"b_m_left_unit\\":\\"px\\",\\"b_m_opp_left\\":false,\\"b_m_bottom_unit\\":\\"px\\",\\"b_m_bottom\\":\\"30\\",\\"b_m_right_unit\\":\\"px\\",\\"b_m_opp_top\\":false,\\"b_m_top_unit\\":\\"px\\",\\"b_m_top\\":\\"0\\",\\"checkbox_b_p_apply_all\\":\\"1\\",\\"b_p_left_unit\\":\\"px\\",\\"b_p_opp_left\\":false,\\"b_p_bottom_unit\\":\\"px\\",\\"b_p_right_unit\\":\\"px\\",\\"b_p_opp_top\\":false,\\"b_p_top_unit\\":\\"px\\",\\"mx_h_unit\\":\\"px\\",\\"mi_h_unit\\":\\"px\\",\\"ht_auto_height\\":false,\\"ht_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"0\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"margin_top\\":\\"0\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"0\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"c0jc149\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\\\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. <\\\\/p>\\"}}]},{\\"element_id\\":\\"y835829\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"60bm420\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Marketing<\\\\/h4>\\",\\"breakpoint_tablet\\":{\\"h4_margin_bottom_unit\\":\\"px\\",\\"h4_margin_top_unit\\":\\"px\\",\\"t_shh4_blur_unit\\":\\"px\\",\\"t_shh4_vShadow_unit\\":\\"px\\",\\"t_shh4_hShadow_unit\\":\\"px\\",\\"letter_spacing_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"25\\",\\"font_gradient_color_h4-circle-radial\\":false,\\"font_gradient_color_h4-gradient-angle\\":\\"180\\",\\"font_gradient_color_h4-gradient-type\\":\\"linear\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"}}},{\\"mod_name\\":\\"progressbar\\",\\"element_id\\":\\"4jki609\\",\\"mod_settings\\":{\\"hide_percentage_text\\":\\"yes\\",\\"progress_bars\\":[{\\"bar_percentage\\":\\"80\\",\\"bar_percentage_only_label\\":false,\\"null\\":\\"yes\\",\\"bar_color\\":\\"#000000\\"}],\\"checkbox_b_m_apply_all\\":false,\\"b_m_left_unit\\":\\"px\\",\\"b_m_opp_left\\":false,\\"b_m_bottom_unit\\":\\"px\\",\\"b_m_bottom\\":\\"30\\",\\"b_m_right_unit\\":\\"px\\",\\"b_m_opp_top\\":false,\\"b_m_top_unit\\":\\"px\\",\\"b_m_top\\":\\"0\\",\\"checkbox_b_p_apply_all\\":\\"1\\",\\"b_p_left_unit\\":\\"px\\",\\"b_p_opp_left\\":false,\\"b_p_bottom_unit\\":\\"px\\",\\"b_p_right_unit\\":\\"px\\",\\"b_p_opp_top\\":false,\\"b_p_top_unit\\":\\"px\\",\\"mx_h_unit\\":\\"px\\",\\"mi_h_unit\\":\\"px\\",\\"ht_auto_height\\":false,\\"ht_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"0\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"margin_top\\":\\"0\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"0\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"v3lk257\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\\\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. <\\\\/p>\\"}}]},{\\"element_id\\":\\"e74l831\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"vwci672\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Video<\\\\/h4>\\",\\"breakpoint_tablet\\":{\\"h4_margin_bottom_unit\\":\\"px\\",\\"h4_margin_top_unit\\":\\"px\\",\\"t_shh4_blur_unit\\":\\"px\\",\\"t_shh4_vShadow_unit\\":\\"px\\",\\"t_shh4_hShadow_unit\\":\\"px\\",\\"letter_spacing_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"25\\",\\"font_gradient_color_h4-circle-radial\\":false,\\"font_gradient_color_h4-gradient-angle\\":\\"180\\",\\"font_gradient_color_h4-gradient-type\\":\\"linear\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"}}},{\\"mod_name\\":\\"progressbar\\",\\"element_id\\":\\"f442224\\",\\"mod_settings\\":{\\"hide_percentage_text\\":\\"yes\\",\\"progress_bars\\":[{\\"bar_percentage\\":\\"75\\",\\"bar_percentage_only_label\\":false,\\"null\\":\\"yes\\",\\"bar_color\\":\\"#000000\\"}],\\"checkbox_b_m_apply_all\\":false,\\"b_m_left_unit\\":\\"px\\",\\"b_m_opp_left\\":false,\\"b_m_bottom_unit\\":\\"px\\",\\"b_m_bottom\\":\\"30\\",\\"b_m_right_unit\\":\\"px\\",\\"b_m_opp_top\\":false,\\"b_m_top_unit\\":\\"px\\",\\"b_m_top\\":\\"0\\",\\"checkbox_b_p_apply_all\\":\\"1\\",\\"b_p_left_unit\\":\\"px\\",\\"b_p_opp_left\\":false,\\"b_p_bottom_unit\\":\\"px\\",\\"b_p_right_unit\\":\\"px\\",\\"b_p_opp_top\\":false,\\"b_p_top_unit\\":\\"px\\",\\"mx_h_unit\\":\\"px\\",\\"mi_h_unit\\":\\"px\\",\\"ht_auto_height\\":false,\\"ht_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"0\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"margin_top\\":\\"0\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"0\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"idwz909\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\\\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. <\\\\/p>\\"}}]}],\\"col_tablet\\":\\"column4-2\\",\\"styling\\":{\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"40\\",\\"margin_opp_top\\":\\"1\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"margin_top\\":\\"40\\",\\"breakpoint_tablet\\":{\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"fjsa22\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"View Portfolio\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/portfolio\\\\/\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"solid\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"checkbox_l_b_r_c_apply_all\\":\\"1\\",\\"l_b_r_c_left_unit\\":\\"px\\",\\"l_b_r_c_opp_left\\":false,\\"l_b_r_c_right_unit\\":\\"px\\",\\"l_b_r_c_bottom_unit\\":\\"px\\",\\"l_b_r_c_opp_bottom\\":false,\\"l_b_r_c_top_unit\\":\\"px\\",\\"l_b_r_c_top\\":\\"30\\",\\"checkbox_padding_link_apply_all\\":false,\\"padding_link_left_unit\\":\\"px\\",\\"padding_link_opp_left\\":false,\\"padding_link_bottom_unit\\":\\"px\\",\\"padding_link_right_unit\\":\\"px\\",\\"padding_link_opp_top\\":\\"1\\",\\"padding_link_top_unit\\":\\"px\\",\\"padding_link_top\\":\\"15\\",\\"checkbox_b_ra_apply_all\\":\\"1\\",\\"b_ra_left_unit\\":\\"px\\",\\"b_ra_opp_left\\":false,\\"b_ra_right_unit\\":\\"px\\",\\"b_ra_bottom_unit\\":\\"px\\",\\"b_ra_opp_bottom\\":false,\\"b_ra_top_unit\\":\\"px\\",\\"button_hover_background_color\\":\\"#e40e0e\\",\\"b_i_h-circle-radial\\":false,\\"b_i_h-gradient-angle\\":\\"180\\",\\"b_i_h-gradient-type\\":\\"linear\\",\\"b_i_h-type\\":\\"image\\",\\"button_background_color\\":\\"#000000\\",\\"b_i-circle-radial\\":false,\\"b_i-gradient-angle\\":\\"180\\",\\"b_i-gradient-type\\":\\"linear\\",\\"b_i-type\\":\\"image\\",\\"background_image-circle-radial\\":false,\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-type\\":\\"image\\",\\"b_p_h\\":\\"50,50\\",\\"b_r_h\\":\\"repeat\\",\\"b_p\\":\\"50,50\\",\\"b_r\\":\\"repeat\\",\\"padding_link_bottom\\":\\"15\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"}}],\\"styling\\":{\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}}],\\"styling\\":{\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"120\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top\\":\\"120\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"80\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\",\\"h4_margin_bottom_unit\\":\\"px\\",\\"h4_margin_top_unit\\":\\"px\\",\\"t_shh4_blur_unit\\":\\"px\\",\\"t_shh4_vShadow_unit\\":\\"px\\",\\"t_shh4_hShadow_unit\\":\\"px\\",\\"letter_spacing_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"20\\",\\"font_gradient_color_h4-circle-radial\\":false,\\"font_gradient_color_h4-gradient-angle\\":\\"180\\",\\"font_gradient_color_h4-gradient-type\\":\\"linear\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"35\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"90\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"90\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"h4_margin_bottom_unit\\":\\"px\\",\\"h4_margin_top_unit\\":\\"px\\",\\"t_shh4_blur_unit\\":\\"px\\",\\"t_shh4_vShadow_unit\\":\\"px\\",\\"t_shh4_hShadow_unit\\":\\"px\\",\\"letter_spacing_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_gradient_color_h4-circle-radial\\":false,\\"font_gradient_color_h4-gradient-angle\\":\\"180\\",\\"font_gradient_color_h4-gradient-type\\":\\"linear\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"100\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"100\\"}}},{\\"element_id\\":\\"ndj3681\\",\\"cols\\":[{\\"element_id\\":\\"cdbo682\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"aish983\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Social<\\\\/h2>\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"25\\",\\"padding_opp_top\\":false}},{\\"element_id\\":\\"se38942\\",\\"cols\\":[{\\"element_id\\":\\"cz82946\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"ouwt971\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-twitter-alt\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"}],\\"icon_position\\":\\"icon_position_center\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"normal\\",\\"f_s_i_unit\\":\\"px\\",\\"f_s_i\\":\\"70\\",\\"font_color_icon\\":\\"#ffffff\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"checkbox_p_i_apply_all\\":false,\\"p_i_left_unit\\":\\"px\\",\\"p_i_opp_left\\":false,\\"p_i_bottom_unit\\":\\"px\\",\\"p_i_right_unit\\":\\"px\\",\\"p_i_opp_top\\":false,\\"p_i_top_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"jgk9610\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Twitter<\\\\/h4>\\\\n<p>12k followers<\\\\/p>\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"20\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"breakpoint_tablet\\":{\\"h4_margin_bottom_unit\\":\\"px\\",\\"h4_margin_top_unit\\":\\"px\\",\\"t_shh4_blur_unit\\":\\"px\\",\\"t_shh4_vShadow_unit\\":\\"px\\",\\"t_shh4_hShadow_unit\\":\\"px\\",\\"letter_spacing_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"20\\",\\"font_gradient_color_h4-circle-radial\\":false,\\"font_gradient_color_h4-gradient-angle\\":\\"180\\",\\"font_gradient_color_h4-gradient-type\\":\\"linear\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"},\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}],\\"styling\\":{\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#ffffff\\",\\"border-type\\":\\"right\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"breakpoint_tablet\\":{\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#ffffff\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"},\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_top_unit\\":\\"px\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\"}},{\\"element_id\\":\\"0yan451\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"hj9t453\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-facebook\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"}],\\"icon_position\\":\\"icon_position_center\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"normal\\",\\"f_s_i_unit\\":\\"px\\",\\"f_s_i\\":\\"70\\",\\"font_color_icon\\":\\"#ffffff\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"8ayj410\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Facebook<\\\\/h4>\\\\n<p>30k likes<\\\\/p>\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"20\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"}}],\\"styling\\":{\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#ffffff\\",\\"border-type\\":\\"right\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"margin-top_opp_top\\":false,\\"breakpoint_tablet\\":{\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#ffffff\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"}}},{\\"element_id\\":\\"h0ds89\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"bj3i89\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-youtube\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/user\\\\/themifyme\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"}],\\"icon_position\\":\\"icon_position_center\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"normal\\",\\"f_s_i_unit\\":\\"px\\",\\"f_s_i\\":\\"70\\",\\"font_color_icon\\":\\"#ffffff\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"xou8969\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Youtube<\\\\/h4>\\\\n<p>22k subscribers<\\\\/p>\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"20\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"}}],\\"styling\\":{\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#ffffff\\",\\"border-type\\":\\"right\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"breakpoint_tablet\\":{\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#ffffff\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"}}},{\\"element_id\\":\\"pzf6386\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"ona8386\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-instagram\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"}],\\"icon_position\\":\\"icon_position_center\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"normal\\",\\"f_s_i_unit\\":\\"px\\",\\"f_s_i\\":\\"70\\",\\"font_color_icon\\":\\"#ffffff\\",\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"top\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"mgvk655\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Instagram<\\\\/h4>\\\\n<p>8k followers<\\\\/p>\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"20\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"}}],\\"styling\\":{\\"border-type\\":\\"right\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#ffffff\\",\\"margin-top_opp_top\\":false,\\"breakpoint_tablet\\":{\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#ffffff\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"},\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"none\\",\\"border_top_style\\":\\"solid\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column4-2\\",\\"styling\\":{\\"text_align\\":\\"center\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false}}]}],\\"styling\\":{\\"margin-top_opp_top\\":false,\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"120\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top\\":\\"120\\",\\"background_color\\":\\"#000000\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"link_color\\":\\"#ffffff\\",\\"font_color\\":\\"#ffffff\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"80\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\",\\"h4_margin_bottom_unit\\":\\"px\\",\\"h4_margin_top_unit\\":\\"px\\",\\"t_shh4_blur_unit\\":\\"px\\",\\"t_shh4_vShadow_unit\\":\\"px\\",\\"t_shh4_hShadow_unit\\":\\"px\\",\\"letter_spacing_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"20\\",\\"font_gradient_color_h4-circle-radial\\":false,\\"font_gradient_color_h4-gradient-angle\\":\\"180\\",\\"font_gradient_color_h4-gradient-type\\":\\"linear\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"35\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"hide_anchor\\":false,\\"breakpoint_tablet\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"90\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"90\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"100\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"100\\"}}},{\\"element_id\\":\\"42wa359\\",\\"cols\\":[{\\"element_id\\":\\"9ai7360\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ohf4243\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Have a project in mind?<\\\\/h2>\\",\\"breakpoint_mobile\\":{\\"h2_margin_bottom_unit\\":\\"px\\",\\"h2_margin_top_unit\\":\\"px\\",\\"t_shh2_blur_unit\\":\\"px\\",\\"t_shh2_vShadow_unit\\":\\"px\\",\\"t_shh2_hShadow_unit\\":\\"px\\",\\"letter_spacing_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"font_size_h2_unit\\":\\"px\\",\\"font_gradient_color_h2-circle-radial\\":false,\\"font_gradient_color_h2-gradient-angle\\":\\"180\\",\\"font_gradient_color_h2-gradient-type\\":\\"linear\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"left\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"}}}],\\"styling\\":{\\"border_right_width\\":\\"10\\",\\"border_right_color\\":\\"#000000\\",\\"border-type\\":\\"right\\",\\"padding_top\\":\\"30\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom\\":\\"30\\",\\"padding_opp_top\\":\\"1\\",\\"padding_left\\":20,\\"padding_right\\":20,\\"text_align\\":\\"right\\",\\"breakpoint_mobile\\":{\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"10\\",\\"border_right_color\\":\\"#000000\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\",\\"padding_right\\":30,\\"padding_right_unit\\":\\"px\\",\\"padding_left\\":30,\\"padding_left_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_right_width\\":\\"6\\",\\"border_right_color\\":\\"#000000\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"},\\"padding_right_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\"}},{\\"element_id\\":\\"4oba946\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"n64x904\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>If you have a great idea, reach out to me. Whether it is a small or big project, I will listen first and get back to you with a plan. <\\\\/p>\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":5,\\"margin_opp_top\\":false,\\"margin_bottom_unit\\":\\"px\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"mner922\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Contact Me\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/contact\\\\/\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"solid\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"checkbox_l_b_r_c_apply_all\\":\\"1\\",\\"l_b_r_c_left_unit\\":\\"px\\",\\"l_b_r_c_right_unit\\":\\"px\\",\\"l_b_r_c_bottom_unit\\":\\"px\\",\\"l_b_r_c_top_unit\\":\\"px\\",\\"l_b_r_c_top\\":\\"30\\",\\"checkbox_padding_link_apply_all\\":false,\\"padding_link_left_unit\\":\\"px\\",\\"padding_link_opp_left\\":false,\\"padding_link_bottom_unit\\":\\"px\\",\\"padding_link_right_unit\\":\\"px\\",\\"padding_link_opp_top\\":\\"1\\",\\"padding_link_top_unit\\":\\"px\\",\\"padding_link_top\\":\\"15\\",\\"checkbox_b_ra_apply_all\\":\\"1\\",\\"b_ra_left_unit\\":\\"px\\",\\"b_ra_right_unit\\":\\"px\\",\\"b_ra_bottom_unit\\":\\"px\\",\\"b_ra_top_unit\\":\\"px\\",\\"button_hover_background_color\\":\\"#e40e0e\\",\\"b_i_h-circle-radial\\":false,\\"b_i_h-gradient-angle\\":\\"180\\",\\"b_i_h-gradient-type\\":\\"linear\\",\\"b_i_h-type\\":\\"image\\",\\"button_background_color\\":\\"#000000\\",\\"b_i-circle-radial\\":false,\\"b_i-gradient-angle\\":\\"180\\",\\"b_i-gradient-type\\":\\"linear\\",\\"b_i-type\\":\\"image\\",\\"background_image-circle-radial\\":false,\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-type\\":\\"image\\",\\"b_p_h\\":\\"50,50\\",\\"b_r_h\\":\\"repeat\\",\\"b_p\\":\\"50,50\\",\\"b_r\\":\\"repeat\\",\\"padding_link_bottom\\":\\"15\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"}}],\\"styling\\":{\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"5\\",\\"padding_opp_top\\":false}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column4-2\\",\\"styling\\":{\\"padding_top\\":\\"120\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"120\\",\\"padding_opp_top\\":\\"1\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"80\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"100\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"100\\"}}}]',
    'themify_used_global_styles' => 
    array (
      0 => 'tb_gs2765ec',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 266,
  'post_date' => '2020-05-22 16:24:16',
  'post_date_gmt' => '2020-05-22 16:24:16',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>Contact</h1> <p>Don\'t be shy. I\'m a great listener. Drop me a line to start a connection. Everything starts some where.</p>
<a href="#contact-form" > Contact </a>
<img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/arrow-down-32x82.png" width="32" alt="arrow-down" />
<img src="https://themify.me/demo/themes/ultra-profile/files/2020/05/cotact-phone-image-824x540.jpg" width="824" height="540" alt="cotact-phone-image" srcset="https://themify.me/demo/themes/ultra-profile/files/2020/05/cotact-phone-image.jpg 824w, https://themify.me/demo/themes/ultra-profile/files/2020/05/cotact-phone-image-600x393.jpg 600w, https://themify.me/demo/themes/ultra-profile/files/2020/05/cotact-phone-image-768x503.jpg 768w" sizes="(max-width: 824px) 100vw, 824px" />
<h3>Contact Info</h3>
13th Street, New York, NY 518-572-8075, 631-987-0970 hello@ultra.profile
<a href="https://facebook.com/themify"> Facebook </a> <a href="https://twitter.com/themify"> Twitter </a> <a href="https://www.youtube.com/user/themifyme"> YouTube </a> <a href="https://www.linkedin.com/company/themify/"> LinkedIn </a>
<img src="https://themify.me/demo/themes/ultra-profile/files/2020/05/contact-profile-image-363x383.jpg" width="363" height="383" alt="contact-profile-image" />
<h2>Get in contact</h2>
<form action="https://themify.me/demo/themes/ultra-profile/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Name *</label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" required/> <label for="contact-0--contact-email">Email *</label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" required /> <label for="contact-0--contact-subject">Subject *</label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" required /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Contact </button> </form><!--/themify_builder_static-->',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact',
  'post_modified' => '2020-06-06 02:47:53',
  'post_modified_gmt' => '2020-06-06 02:47:53',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?page_id=266',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"kc69976\\",\\"cols\\":[{\\"element_id\\":\\"8h2j977\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"ipvw450\\",\\"cols\\":[{\\"element_id\\":\\"8qou450\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"yxbz681\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Contact<\\\\/h1>\\\\n<p>Don\\\'t be shy. I\\\'m a great listener. Drop me a line to start a connection. Everything starts some where.<\\\\/p>\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"20\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"28\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"custom_parallax_scroll_zindex\\":\\"3\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"g4ft681\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Contact\\",\\"link\\":\\"#contact-form\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"solid\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"checkbox_l_b_r_c_apply_all\\":\\"1\\",\\"l_b_r_c_left_unit\\":\\"px\\",\\"l_b_r_c_right_unit\\":\\"px\\",\\"l_b_r_c_bottom_unit\\":\\"px\\",\\"l_b_r_c_top_unit\\":\\"px\\",\\"l_b_r_c_top\\":\\"30\\",\\"checkbox_padding_link_apply_all\\":false,\\"padding_link_left_unit\\":\\"px\\",\\"padding_link_opp_left\\":false,\\"padding_link_bottom_unit\\":\\"px\\",\\"padding_link_right_unit\\":\\"px\\",\\"padding_link_opp_top\\":\\"1\\",\\"padding_link_top_unit\\":\\"px\\",\\"padding_link_top\\":\\"15\\",\\"checkbox_b_ra_apply_all\\":\\"1\\",\\"b_ra_left_unit\\":\\"px\\",\\"b_ra_right_unit\\":\\"px\\",\\"b_ra_bottom_unit\\":\\"px\\",\\"b_ra_top_unit\\":\\"px\\",\\"b_p_h\\":\\"50,50\\",\\"b_r_h\\":\\"repeat\\",\\"button_hover_background_color\\":\\"#e40e0e\\",\\"b_i_h-circle-radial\\":false,\\"b_i_h-gradient-angle\\":\\"180\\",\\"b_i_h-gradient-type\\":\\"linear\\",\\"b_i_h-type\\":\\"image\\",\\"b_p\\":\\"50,50\\",\\"b_r\\":\\"repeat\\",\\"button_background_color\\":\\"#000000\\",\\"b_i-circle-radial\\":false,\\"b_i-gradient-angle\\":\\"180\\",\\"b_i-gradient-type\\":\\"linear\\",\\"b_i-type\\":\\"image\\",\\"background_position\\":\\"50,50\\",\\"background_repeat\\":\\"repeat\\",\\"background_image-circle-radial\\":false,\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-type\\":\\"image\\",\\"padding_link_bottom\\":\\"15\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"}}]}],\\"styling\\":{\\"global_styles\\":\\"tb_gs2765ec\\",\\"b_sh_inset\\":false}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"mq8r768\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"32\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/arrow-down-32x82.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"margin_bottom\\":\\"-50\\",\\"visibility_mobile\\":\\"hide\\"}}]},{\\"element_id\\":\\"wepb835\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"aq6n247\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"540\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"824\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/05\\\\/cotact-phone-image.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-top\\",\\"custom_parallax_scroll_zindex\\":\\"1\\",\\"margin_left\\":\\"-30\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_left\\":\\"0\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"col_tablet_landscape\\":\\"column3-1-3-2\\",\\"col_tablet\\":\\"column4-2\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"padding_top\\":30,\\"padding_opp_left\\":false,\\"padding_bottom\\":102,\\"padding_opp_top\\":false,\\"margin-bottom\\":63,\\"margin-bottom_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_top_unit\\":\\"px\\",\\"hide_anchor\\":false,\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"30\\"},\\"breakpoint_tablet\\":{\\"padding_bottom\\":14,\\"padding_bottom_unit\\":\\"px\\"}}},{\\"element_id\\":\\"dst1935\\",\\"cols\\":[{\\"element_id\\":\\"gzdy937\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"element_id\\":\\"4nso279\\",\\"cols\\":[{\\"element_id\\":\\"gdl3282\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"yn13772\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Contact Info<\\\\/h3>\\",\\"background_position\\":\\"50,50\\",\\"background_repeat\\":\\"repeat\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"2\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"4\\",\\"background_color\\":\\"#000000\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_top_unit\\":\\"%\\",\\"margin_opp_left\\":\\"1\\",\\"margin_opp_top\\":false,\\"margin_top\\":\\"-27\\",\\"margin_left\\":\\"17\\",\\"margin_right\\":\\"17\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_right_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"margin_bottom\\":\\"15\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"5\\",\\"margin_opp_left\\":\\"1\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"10\\",\\"margin_right_unit\\":\\"%\\",\\"margin_right\\":\\"5\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"%\\",\\"margin_top\\":\\"-35\\",\\"background_position\\":\\"50,50\\",\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#000000\\",\\"background_image-circle-radial\\":false,\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"5\\"},\\"breakpoint_tablet\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"12\\",\\"margin_opp_left\\":\\"1\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"15\\",\\"margin_right_unit\\":\\"%\\",\\"margin_right\\":\\"12\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"%\\",\\"margin_top\\":\\"-27\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"12\\",\\"margin_opp_left\\":\\"1\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"15\\",\\"margin_right_unit\\":\\"%\\",\\"margin_right\\":\\"12\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"%\\",\\"margin_top\\":\\"-27\\"}}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"2k03549\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-location-pin\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"13th Street, New York,  NY \\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"},{\\"icon\\":\\"ti-mobile\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"518-572-8075, 631-987-0970\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"},{\\"icon\\":\\"ti-email\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"hello@ultra.profile\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"}],\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_vertical\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"normal\\",\\"f_s_i_unit\\":\\"px\\",\\"f_s_i\\":\\"20\\"}}],\\"styling\\":{\\"border_right_width\\":\\"3\\",\\"border_right_color\\":\\"#000000\\",\\"border-type\\":\\"right\\",\\"padding_opp_left\\":false,\\"padding_right\\":\\"30\\",\\"padding_opp_top\\":false,\\"breakpoint_mobile\\":{\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"3\\",\\"border_right_color\\":\\"#000000\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"},\\"breakpoint_tablet\\":{\\"checkbox_b_ra_apply_all\\":false,\\"b_ra_left_unit\\":\\"px\\",\\"b_ra_opp_left\\":false,\\"b_ra_right_unit\\":\\"px\\",\\"b_ra_bottom_unit\\":\\"px\\",\\"b_ra_opp_bottom\\":false,\\"b_ra_top_unit\\":\\"px\\",\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"3\\",\\"border_right_color\\":\\"#000000\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"}}},{\\"element_id\\":\\"pn90283\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"sm4z261\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-facebook\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Facebook\\",\\"link\\":\\"https:\\\\/\\\\/facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"},{\\"icon\\":\\"ti-twitter-alt\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Twitter\\",\\"link\\":\\"https:\\\\/\\\\/twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"},{\\"icon\\":\\"ti-youtube\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"YouTube\\",\\"link\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/user\\\\/themifyme\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"},{\\"icon\\":\\"ti-linkedin\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"LinkedIn\\",\\"link\\":\\"https:\\\\/\\\\/www.linkedin.com\\\\/company\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"}],\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_vertical\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"normal\\",\\"f_s_i_unit\\":\\"px\\",\\"f_s_i\\":\\"24\\",\\"font_color_icon\\":\\"#000000\\",\\"link_color_hover\\":\\"#e40e0e\\",\\"link_color\\":\\"#000000\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_left\\":\\"30\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_left\\":\\"0\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_left\\":\\"0\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}}]}],\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"global_styles\\":\\"tb_gs2765ec\\"}}]},{\\"element_id\\":\\"avwr365\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"1nl1454\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"383\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"363\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/05\\\\/contact-profile-image-363x383.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"custom_parallax_scroll_zindex\\":\\"3\\",\\"margin_top_unit\\":\\"%\\",\\"margin_left\\":\\"-39\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"margin_top\\":\\"-54\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_left\\":\\"0\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"margin_top\\":\\"0\\"},\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_width_unit\\":\\"px\\",\\"breakpoint_tablet\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_left\\":\\"-39\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"%\\",\\"margin_top\\":\\"-20\\"},\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_speed\\":\\"2\\",\\"v_dir\\":\\"up\\"}}}}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"col_tablet_landscape\\":\\"column3-2-3-1\\",\\"col_tablet\\":\\"column4-2\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"padding_top\\":0,\\"hide_anchor\\":false,\\"padding_opp_left\\":false,\\"padding_bottom\\":0,\\"padding_opp_top\\":\\"1\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"25\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_h3\\":\\"#ffffff\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"breakpoint_mobile\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"18\\",\\"font_color_h3\\":\\"#ffffff\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"0\\"},\\"breakpoint_tablet\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"0\\"}}},{\\"element_id\\":\\"o8lu418\\",\\"cols\\":[{\\"element_id\\":\\"yc41421\\",\\"grid_class\\":\\"col-full\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"padding_top\\":\\"234\\",\\"padding_bottom\\":\\"302\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/05\\\\/location-map.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"%\\",\\"margin-top\\":\\"-10\\",\\"hide_anchor\\":false,\\"breakpoint_tablet\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"%\\",\\"margin-top\\":\\"-20\\"}}},{\\"element_id\\":\\"dwce445\\",\\"cols\\":[{\\"element_id\\":\\"sw1o446\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"jxpg446\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Get in contact<\\\\/h2>\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"35\\",\\"padding_opp_top\\":false,\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"nn72446\\",\\"mod_settings\\":{\\"field_name_label\\":\\"Name\\",\\"field_email_label\\":\\"Email\\",\\"field_subject_label\\":\\"Subject\\",\\"field_message_label\\":\\"Message\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_send_label\\":\\"Contact\\",\\"gdpr_label\\":\\"I consent to my submitted data being collected and stored\\",\\"field_name_require\\":\\"yes\\",\\"field_email_require\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_email_active\\":\\"yes\\",\\"field_subject_active\\":\\"yes\\",\\"field_subject_require\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"field_send_align\\":\\"center\\",\\"field_extra\\":\\"{\\\\\\"fields\\\\\\":[]}\\",\\"field_order\\":\\"{\\\\\\"field_name_label\\\\\\":0,\\\\\\"field_email_label\\\\\\":1,\\\\\\"field_subject_label\\\\\\":2,\\\\\\"field_message_label\\\\\\":3}\\",\\"field_optin_label\\":\\"Subscribe to my newsletter.\\",\\"field_optin_active\\":false,\\"mailchimp_list\\":\\"0f2a95e5de\\",\\"provider\\":\\"mailchimp\\",\\"field_sendcopy_active\\":false,\\"field_captcha_active\\":false,\\"contact_sent_from\\":\\"enable\\",\\"post_author\\":false,\\"user_role\\":\\"admin\\",\\"send_to_admins\\":\\"true\\",\\"layout_contact\\":\\"animated-label\\"}}]}],\\"styling\\":{\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"120\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top\\":\\"120\\",\\"background_color\\":\\"#fbfbfb\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"80\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"80\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"90\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"90\\"},\\"background_gradient-circle-radial\\":false,\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"row_width\\":\\"fullwidth\\",\\"hide_anchor\\":false,\\"row_anchor\\":\\"contact-form\\"}}]',
    'themify_used_global_styles' => 
    array (
      0 => 'tb_gs2765ec',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 9,
  'post_date' => '2020-03-10 14:04:06',
  'post_date_gmt' => '2020-03-10 14:04:06',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>Hello</h1>
<p>Welcome to Ultra Profile. My name is Natalie Smith. I\'m a New York based freelancer who provide copywriting, marketing and web design services. Check out my <a href="https://themify.me/demo/themes/ultra-profile/portfolio/">portfolio</a> or <a href="_wp_link_placeholder" data-wplink-edit="true">contact me</a> for your projects.</p>
<img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/arrow-down-32x82.png" width="32" alt="arrow-down" />

<img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/natalie-pic-428x460.jpg" width="428" alt="natalie-pic" />
<h4>Profile</h4> <h3>I’m Natalie Smith</h3> <p>With 10+ years experience, my main focus is content writing, SEO marketing and web design. I\'ve been recognized as one of the top web designers in the city (check my <a href="_wp_link_placeholder" data-wplink-edit="true">profile page</a>).</p>
<a href="#contact-form-home" > Contact </a>
<h2>Who I have worked with</h2>
<img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/sonny-logo-370x260.png" width="370" alt="sonny-logo" />
<img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/apple-370x260.png" width="370" alt="apple" />
<img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/amazon-370x260.png" width="370" alt="amazon" />
<img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/cisco-370x260.png" width="370" alt="cisco" />
<img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/google-370x260.png" width="370" alt="google" />
<a href="#contact-form-home" > Contact </a>
<h4>Services</h4>

<img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/bulb-42x58.png" width="42" height="58" title="Content Writing" alt="I do strategic research and write content that is pin-pointed to your audience." /> <h3> Content Writing </h3> I do strategic research and write content that is pin-pointed to your audience.

<img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/copywriting-50x51.png" width="50" height="51" title="SEO Marketing" alt="Your site is not done after launch. SEO marketing is an on-going process." /> <h3> SEO Marketing </h3> Your site is not done after launch. SEO marketing is an on-going process.

<img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/digital-50x51.png" width="50" height="51" title="Web Design" alt="Design that works and flows with the marketing content." /> <h3> Web Design </h3> Design that works and flows with the marketing content.
<h2>My workflow...</h2>
<ul><li><h4>Get to know each other first</h4><p>Everything starts with an idea. If you have a great idea, reach out to me. Whether it is a small or big project, I listen first and get back to you with a plan. </p></li><li><h4>Sip a coffee and get rolling</h4><p>Great, we are matched. The next step is to grab a coffee and get to know each other more. We can also do the consultation remotely (eg. using chat or video conference). </p></li><li><h4>Execution, revisions, refine, and refine</h4><p>Based on the scope of the project, I will send you in progress work for approvals and revisions. My work is not done until you are happy with it.</p></li><li><h4>Delivery, on time.</h4><p>Awesome, time to launch. Your journey begins here. I\'m happy to provide on-going works and support for you.</p></li></ul>
<img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/testimonial-quote-128x85.png" width="128" alt="testimonial-quote" />
<h2>What do people say about me</h2>
<img src="https://themify.me/demo/themes/ultra-profile/files/2020/03/testimonial-dots-145x19.png" width="145" alt="testimonial-dots" />
<ul data-id="tb_tuao805" data-visible="1" data-tab-visible="0" data-mob-visible="0" data-scroll="1" data-auto-scroll="off" data-speed="1" data-wrap="yes" data-arrow="yes" data-pagination="no" data-effect="scroll" data-height="variable" data-pause-on-hover="resume" data-play-controller="no" data-horizontal="" > <li> 
 <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic Lorem Ipsum.</p> <figure><img src="https://themify.me/demo/themes/pro-profile/files/2020/03/jen.jpg" width="100" height="100" alt="" /></figure> Jen Allison Head of Marketing Digiflow </li> <li> 
 <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic Lorem Ipsum.</p> <figure><img src="https://themify.me/demo/themes/pro-profile/files/2020/03/james.jpg" width="100" height="100" alt="" /></figure> James Johnson CEO EXO CLOUD </li> <li> 
 <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic Lorem Ipsum.</p> <figure><img src="https://themify.me/demo/themes/pro-profile/files/2020/03/sophia.jpg" width="100" height="100" alt="" /></figure> Sophia Martinez H&R Manager Aspire </li> </ul>
<h2>Portfolio</h2>

<h2>Get in contact</h2>
<form action="https://themify.me/demo/themes/ultra-profile/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Name *</label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" required/> <label for="contact-0--contact-email">Email *</label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" required /> <label for="contact-0--contact-subject">Subject *</label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" required /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Contact </button> </form><!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2020-06-06 03:27:58',
  'post_modified_gmt' => '2020-06-06 03:27:58',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?page_id=9',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"b1yo513\\",\\"cols\\":[{\\"element_id\\":\\"syk2515\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"wumf921\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Hello<\\\\/h1>\\",\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"%\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_left\\":\\"10\\",\\"h1_margin_bottom_unit\\":\\"px\\",\\"h1_margin_top_unit\\":\\"px\\",\\"t_shh1_blur_unit\\":\\"px\\",\\"t_shh1_vShadow_unit\\":\\"px\\",\\"t_shh1_hShadow_unit\\":\\"px\\",\\"letter_spacing_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"120\\",\\"font_gradient_color_h1-circle-radial\\":false,\\"font_gradient_color_h1-gradient-angle\\":\\"180\\",\\"font_gradient_color_h1-gradient-type\\":\\"linear\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"h1_margin_bottom_unit\\":\\"px\\",\\"h1_margin_top_unit\\":\\"px\\",\\"t_shh1_blur_unit\\":\\"px\\",\\"t_shh1_vShadow_unit\\":\\"px\\",\\"t_shh1_hShadow_unit\\":\\"px\\",\\"letter_spacing_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"120\\",\\"font_gradient_color_h1-circle-radial\\":false,\\"font_gradient_color_h1-gradient-angle\\":\\"180\\",\\"font_gradient_color_h1-gradient-type\\":\\"linear\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\",\\"breakpoint_mobile\\":{\\"h1_margin_bottom_unit\\":\\"px\\",\\"h1_margin_top_unit\\":\\"px\\",\\"t_shh1_blur_unit\\":\\"px\\",\\"t_shh1_vShadow_unit\\":\\"px\\",\\"t_shh1_hShadow_unit\\":\\"px\\",\\"letter_spacing_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"48\\",\\"font_gradient_color_h1-circle-radial\\":false,\\"font_gradient_color_h1-gradient-angle\\":\\"180\\",\\"font_gradient_color_h1-gradient-type\\":\\"linear\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"h1_margin_bottom_unit\\":\\"px\\",\\"h1_margin_top_unit\\":\\"px\\",\\"t_shh1_blur_unit\\":\\"px\\",\\"t_shh1_vShadow_unit\\":\\"px\\",\\"t_shh1_hShadow_unit\\":\\"px\\",\\"letter_spacing_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"120\\",\\"font_gradient_color_h1-circle-radial\\":false,\\"font_gradient_color_h1-gradient-angle\\":\\"180\\",\\"font_gradient_color_h1-gradient-type\\":\\"linear\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"cigp36\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Welcome to Ultra Profile. My name is Natalie Smith. I\\\'m a New York based freelancer who provide copywriting, marketing and web design services. Check out my <a href=\\\\\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/portfolio\\\\/\\\\\\">portfolio<\\\\/a> or <a href=\\\\\\"_wp_link_placeholder\\\\\\" data-wplink-edit=\\\\\\"true\\\\\\">contact me<\\\\/a> for your projects.<\\\\/p>\\",\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"%\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_left\\":\\"10\\"},\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"em\\",\\"line_height\\":\\"1.6\\",\\"font_size_unit\\":\\"px\\",\\"font_size\\":\\"18\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"5fmg44\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"32\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/arrow-down-32x82.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-top\\",\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"%\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_left\\":\\"10\\"},\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_width_unit\\":\\"px\\",\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_vp\\":\\"0,100\\",\\"v_speed\\":\\"2\\",\\"v_dir\\":\\"down\\"}}}}}]},{\\"element_id\\":\\"35so382\\",\\"grid_class\\":\\"col4-2\\"}],\\"col_tablet\\":\\"column3-2-3-1\\",\\"styling\\":{\\"padding_top\\":120,\\"padding_opp_left\\":false,\\"padding_bottom\\":120,\\"padding_opp_top\\":\\"1\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_size_h1\\":\\"6\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_top_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"h1_margin_bottom_unit\\":\\"px\\",\\"h1_margin_top_unit\\":\\"px\\",\\"t_shh1_blur_unit\\":\\"px\\",\\"t_shh1_vShadow_unit\\":\\"px\\",\\"t_shh1_hShadow_unit\\":\\"px\\",\\"letter_spacing_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_size_h1\\":\\"4\\",\\"font_gradient_color_h1-circle-radial\\":false,\\"font_gradient_color_h1-gradient-angle\\":\\"180\\",\\"font_gradient_color_h1-gradient-type\\":\\"linear\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"50\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"50\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"70\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"70\\",\\"h1_margin_bottom_unit\\":\\"px\\",\\"h1_margin_top_unit\\":\\"px\\",\\"t_shh1_blur_unit\\":\\"px\\",\\"t_shh1_vShadow_unit\\":\\"px\\",\\"t_shh1_hShadow_unit\\":\\"px\\",\\"letter_spacing_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_size_h1\\":\\"4.5\\",\\"font_gradient_color_h1-circle-radial\\":false,\\"font_gradient_color_h1-gradient-angle\\":\\"180\\",\\"font_gradient_color_h1-gradient-type\\":\\"linear\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"90\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"90\\"}}},{\\"element_id\\":\\"0osn526\\",\\"cols\\":[{\\"element_id\\":\\"pynp528\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"ar44589\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"#000000\\",\\"divider_width\\":\\"120\\",\\"divider_type\\":\\"custom\\",\\"divider_align\\":\\"right\\",\\"visibility_mobile\\":\\"hide\\",\\"visibility_tablet\\":\\"hide\\",\\"style_divider\\":\\"solid\\"}}],\\"styling\\":{\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\"}},{\\"element_id\\":\\"ryjk402\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ppn7700\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":\\"1\\",\\"width_image\\":\\"428\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/natalie-pic-428x460.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"i_t_m_opp_left\\":false,\\"i_t_m_opp_top\\":false,\\"custom_parallax_scroll_zindex\\":\\"2\\",\\"breakpoint_mobile\\":{\\"checkbox_i_t_m_apply_all\\":false,\\"i_t_m_left_unit\\":\\"px\\",\\"i_t_m_opp_left\\":false,\\"i_t_m_bottom_unit\\":\\"px\\",\\"i_t_m_right_unit\\":\\"px\\",\\"i_t_m_right\\":\\"0\\",\\"i_t_m_opp_top\\":false,\\"i_t_m_top_unit\\":\\"px\\"},\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_width_unit\\":\\"px\\",\\"breakpoint_tablet\\":{\\"checkbox_i_t_m_apply_all\\":false,\\"i_t_m_left_unit\\":\\"px\\",\\"i_t_m_opp_left\\":false,\\"i_t_m_bottom_unit\\":\\"px\\",\\"i_t_m_right_unit\\":\\"px\\",\\"i_t_m_right\\":\\"0\\",\\"i_t_m_opp_top\\":false,\\"i_t_m_top_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"},\\"checkbox_i_t_m_apply_all\\":false,\\"i_t_m_left_unit\\":\\"px\\",\\"i_t_m_bottom_unit\\":\\"px\\",\\"i_t_m_right_unit\\":\\"px\\",\\"i_t_m_top_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"-170\\",\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_speed\\":\\"1\\",\\"v_dir\\":\\"up\\"}}}}}],\\"styling\\":{\\"margin-top_opp_top\\":false}},{\\"element_id\\":\\"evny224\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"sn4i772\\",\\"cols\\":[{\\"element_id\\":\\"6als773\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"dveu351\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Profile<\\\\/h4>\\\\n<h3>I’m Natalie Smith<\\\\/h3>\\\\n<p>With 10+ years experience, my main focus is content writing, SEO marketing and web design. I\\\'ve been recognized as one of the top web designers in the city (check my <a href=\\\\\\"_wp_link_placeholder\\\\\\" data-wplink-edit=\\\\\\"true\\\\\\">profile page<\\\\/a>).<\\\\/p>\\",\\"breakpoint_mobile\\":{\\"h4_margin_bottom_unit\\":\\"px\\",\\"h4_margin_top_unit\\":\\"px\\",\\"t_shh4_blur_unit\\":\\"px\\",\\"t_shh4_vShadow_unit\\":\\"px\\",\\"t_shh4_hShadow_unit\\":\\"px\\",\\"letter_spacing_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"20\\",\\"font_gradient_color_h4-circle-radial\\":false,\\"font_gradient_color_h4-gradient-angle\\":\\"180\\",\\"font_gradient_color_h4-gradient-type\\":\\"linear\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"35\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\",\\"link_color\\":\\"#fe1821\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"8fk0981\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Contact\\",\\"link\\":\\"#contact-form-home\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\",\\"icon_alignment\\":\\"left\\",\\"button_color_bg\\":\\"tb_default_color\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"solid\\",\\"buttons_shape\\":\\"circle\\",\\"buttons_size\\":\\"normal\\",\\"checkbox_l_b_r_c_apply_all\\":\\"1\\",\\"l_b_r_c_left_unit\\":\\"px\\",\\"l_b_r_c_right_unit\\":\\"px\\",\\"l_b_r_c_bottom_unit\\":\\"px\\",\\"l_b_r_c_top_unit\\":\\"px\\",\\"l_b_r_c_top\\":\\"30\\",\\"checkbox_padding_link_apply_all\\":false,\\"padding_link_left_unit\\":\\"px\\",\\"padding_link_opp_left\\":false,\\"padding_link_bottom_unit\\":\\"px\\",\\"padding_link_right_unit\\":\\"px\\",\\"padding_link_opp_top\\":\\"1\\",\\"padding_link_top_unit\\":\\"px\\",\\"checkbox_b_ra_apply_all\\":\\"1\\",\\"b_ra_left_unit\\":\\"px\\",\\"b_ra_right_unit\\":\\"px\\",\\"b_ra_bottom_unit\\":\\"px\\",\\"b_ra_top_unit\\":\\"px\\",\\"button_hover_background_color\\":\\"#e40e0e\\",\\"b_i_h-circle-radial\\":false,\\"b_i_h-gradient-angle\\":\\"180\\",\\"b_i_h-gradient-type\\":\\"linear\\",\\"b_i_h-type\\":\\"image\\",\\"button_background_color\\":\\"#ffffff\\",\\"b_i-circle-radial\\":false,\\"b_i-gradient-angle\\":\\"180\\",\\"b_i-gradient-type\\":\\"linear\\",\\"b_i-type\\":\\"image\\",\\"background_image-circle-radial\\":false,\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-type\\":\\"image\\",\\"b_p\\":\\"50,50\\",\\"b_r\\":\\"repeat\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_link_apply_all\\":false,\\"padding_link_left_unit\\":\\"px\\",\\"padding_link_opp_left\\":false,\\"padding_link_bottom_unit\\":\\"px\\",\\"padding_link_right_unit\\":\\"px\\",\\"padding_link_opp_top\\":false,\\"padding_link_top_unit\\":\\"px\\",\\"padding_link_top\\":\\"15\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"},\\"link_color_hover\\":\\"#ffffff\\",\\"link_color\\":\\"#000000\\",\\"b_p_h\\":\\"50,50\\",\\"b_r_h\\":\\"repeat\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_link_bottom\\":\\"15\\",\\"padding_link_top\\":\\"15\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_link_margin_apply_all\\":false,\\"link_margin_left_unit\\":\\"px\\",\\"link_margin_opp_left\\":false,\\"link_margin_bottom_unit\\":\\"px\\",\\"link_margin_right_unit\\":\\"px\\",\\"link_margin_opp_top\\":false,\\"link_margin_top_unit\\":\\"px\\"}}]}],\\"styling\\":{\\"background_color\\":\\"#000000\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"17\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"20\\",\\"padding_right\\":\\"15\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top\\":\\"20\\",\\"zi\\":\\"1\\",\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"12\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"12\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"12\\"},\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_color\\":\\"#ffffff\\",\\"background_gradient-circle-radial\\":false,\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient-type\\":\\"linear\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"padding_opp_left\\":false,\\"padding_opp_top\\":\\"1\\",\\"background_color\\":\\"#f2f2f2\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"row_width\\":\\"fullwidth-content\\",\\"hide_anchor\\":false}},{\\"element_id\\":\\"l9hs394\\",\\"cols\\":[{\\"element_id\\":\\"bww5396\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"flps477\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Who I have worked with<\\\\/h2>\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"margin_bottom\\":\\"30\\"}},{\\"element_id\\":\\"h4bo665\\",\\"cols\\":[{\\"element_id\\":\\"b3ku668\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"zkpy815\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/sonny-logo-370x260.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-top\\",\\"width_image\\":\\"370\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"30\\",\\"margin_opp_top\\":\\"1\\",\\"margin_top\\":\\"30\\"}}]},{\\"element_id\\":\\"8frv609\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"vbbq647\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/apple-370x260.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-top\\",\\"width_image\\":\\"370\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"30\\",\\"margin_opp_top\\":\\"1\\",\\"margin_top\\":\\"30\\"}}]},{\\"element_id\\":\\"j1cm609\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"hz9n181\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/amazon-370x260.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"width_image\\":\\"370\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"30\\",\\"margin_opp_top\\":\\"1\\",\\"margin_top\\":\\"30\\"}}],\\"grid_width\\":16.879999999999999005240169935859739780426025390625},{\\"element_id\\":\\"plpp610\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"etya516\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/cisco-370x260.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"width_image\\":\\"370\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"30\\",\\"margin_opp_top\\":\\"1\\",\\"margin_top\\":\\"30\\"}}],\\"grid_width\\":18},{\\"element_id\\":\\"msib145\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"dv3s885\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/google-370x260.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-top\\",\\"width_image\\":\\"370\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"30\\",\\"margin_opp_top\\":\\"1\\",\\"margin_top\\":\\"30\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet_landscape\\":\\"column5-1\\",\\"col_tablet\\":\\"column5-1\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"b_sh_inset\\":false,\\"b_ra_opp_left\\":false,\\"b_ra_opp_bottom\\":false,\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"global_styles\\":\\"tb_gs2765ec\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"usux897\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Contact\\",\\"link\\":\\"#contact-form-home\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"solid\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"checkbox_l_b_r_c_apply_all\\":\\"1\\",\\"l_b_r_c_left_unit\\":\\"px\\",\\"l_b_r_c_right_unit\\":\\"px\\",\\"l_b_r_c_bottom_unit\\":\\"px\\",\\"l_b_r_c_top_unit\\":\\"px\\",\\"l_b_r_c_top\\":\\"30\\",\\"checkbox_padding_link_apply_all\\":false,\\"padding_link_left_unit\\":\\"px\\",\\"padding_link_opp_left\\":false,\\"padding_link_bottom_unit\\":\\"px\\",\\"padding_link_right_unit\\":\\"px\\",\\"padding_link_opp_top\\":\\"1\\",\\"padding_link_top_unit\\":\\"px\\",\\"padding_link_top\\":\\"15\\",\\"checkbox_b_ra_apply_all\\":\\"1\\",\\"b_ra_left_unit\\":\\"px\\",\\"b_ra_right_unit\\":\\"px\\",\\"b_ra_bottom_unit\\":\\"px\\",\\"b_ra_top_unit\\":\\"px\\",\\"b_p_h\\":\\"50,50\\",\\"b_r_h\\":\\"repeat\\",\\"button_hover_background_color\\":\\"#e40e0e\\",\\"b_i_h-circle-radial\\":false,\\"b_i_h-gradient-angle\\":\\"180\\",\\"b_i_h-gradient-type\\":\\"linear\\",\\"b_i_h-type\\":\\"image\\",\\"b_p\\":\\"50,50\\",\\"b_r\\":\\"repeat\\",\\"button_background_color\\":\\"#000000\\",\\"b_i-circle-radial\\":false,\\"b_i-gradient-angle\\":\\"180\\",\\"b_i-gradient-type\\":\\"linear\\",\\"b_i-type\\":\\"image\\",\\"background_position\\":\\"50,50\\",\\"background_repeat\\":\\"repeat\\",\\"background_image-circle-radial\\":false,\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-type\\":\\"image\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_link_bottom\\":\\"15\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}]}],\\"styling\\":{\\"padding_top\\":120,\\"padding_opp_left\\":false,\\"padding_bottom\\":120,\\"padding_opp_top\\":\\"1\\",\\"background_color\\":\\"#fbfbfb\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text_align\\":\\"center\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_top_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"80\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"},\\"breakpoint_tablet\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"80\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"90\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"90\\"},\\"hide_anchor\\":false,\\"background_gradient-circle-radial\\":false,\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"h2_margin_bottom_unit\\":\\"px\\",\\"h2_margin_top_unit\\":\\"px\\",\\"t_shh2_blur_unit\\":\\"px\\",\\"t_shh2_vShadow_unit\\":\\"px\\",\\"t_shh2_hShadow_unit\\":\\"px\\",\\"letter_spacing_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"font_size_h2_unit\\":\\"px\\",\\"font_gradient_color_h2-circle-radial\\":false,\\"font_gradient_color_h2-gradient-angle\\":\\"180\\",\\"font_gradient_color_h2-gradient-type\\":\\"linear\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\"}},{\\"element_id\\":\\"mwmz431\\",\\"cols\\":[{\\"element_id\\":\\"ohtc431\\",\\"grid_class\\":\\"col4-2\\",\\"styling\\":{\\"margin-top_opp_top\\":false,\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"15\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom\\":\\"10\\",\\"padding_right\\":\\"15\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top\\":\\"10\\",\\"background_position\\":\\"50,100\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/service.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"20\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"38\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"20\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"38\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"15\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"40\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"15\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"40\\"},\\"checkbox_padding_apply_all\\":false}},{\\"element_id\\":\\"8yj5862\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"w8se354\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Services<\\\\/h4>\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"30\\",\\"margin_opp_top\\":false,\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"breakpoint_mobile\\":{\\"h4_margin_bottom_unit\\":\\"px\\",\\"h4_margin_top_unit\\":\\"px\\",\\"t_shh4_blur_unit\\":\\"px\\",\\"t_shh4_vShadow_unit\\":\\"px\\",\\"t_shh4_hShadow_unit\\":\\"px\\",\\"letter_spacing_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"25\\",\\"font_gradient_color_h4-circle-radial\\":false,\\"font_gradient_color_h4-gradient-angle\\":\\"180\\",\\"font_gradient_color_h4-gradient-type\\":\\"linear\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"etlw787\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"#4d4d4d\\",\\"divider_width\\":\\"150\\",\\"divider_type\\":\\"fullwidth\\",\\"style_divider\\":\\"solid\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"o85i332\\",\\"mod_settings\\":{\\"caption_image\\":\\"I do strategic research and write content that is pin-pointed to your audience.\\",\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/bulb-42x58.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-left\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"30\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top\\":\\"30\\",\\"title_image\\":\\"Content Writing\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"height_image\\":\\"58\\",\\"width_image\\":\\"42\\"}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"vppe671\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"#4d4d4d\\",\\"divider_width\\":\\"150\\",\\"divider_type\\":\\"fullwidth\\",\\"style_divider\\":\\"solid\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"noyg305\\",\\"mod_settings\\":{\\"caption_image\\":\\"Your site is not done after launch. SEO marketing is an on-going process.\\",\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/copywriting-50x51.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-left\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"30\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top\\":\\"30\\",\\"title_image\\":\\"SEO Marketing\\",\\"height_image\\":\\"51\\",\\"width_image\\":\\"50\\"}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"eg1b569\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"#4d4d4d\\",\\"divider_width\\":\\"150\\",\\"divider_type\\":\\"fullwidth\\",\\"style_divider\\":\\"solid\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"nlaa108\\",\\"mod_settings\\":{\\"caption_image\\":\\"Design that works and flows with the marketing content.\\",\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/digital-50x51.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-left\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"30\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top\\":\\"30\\",\\"title_image\\":\\"Web Design\\",\\"height_image\\":\\"51\\",\\"width_image\\":\\"50\\"}}],\\"styling\\":{\\"background_color\\":\\"#000000\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"8\\",\\"padding_opp_top\\":\\"1\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"8\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"10\\"},\\"checkbox_padding_apply_all\\":false,\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"6\\",\\"padding_bottom\\":\\"6\\",\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":15,\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"8\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":15},\\"background_gradient-circle-radial\\":false,\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient-type\\":\\"linear\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"30\\",\\"font_color_h4\\":\\"#ffffff\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color\\":\\"#ffffff\\"}},{\\"element_id\\":\\"ziet844\\",\\"cols\\":[{\\"element_id\\":\\"kdjs844\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"1rsn389\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>My workflow...<\\\\/h2>\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"35\\",\\"padding_opp_top\\":false,\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"element_id\\":\\"0ivo299\\",\\"cols\\":[{\\"element_id\\":\\"h5yj301\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"accordion\\",\\"element_id\\":\\"xfqd579\\",\\"mod_settings\\":{\\"content_accordion\\":[{\\"title_accordion\\":\\"Get to know each other first\\",\\"text_accordion\\":\\"<p>Everything starts with an idea. If you have a great idea, reach out to me. Whether it is a small or big project, I listen first and get back to you with a plan. <\\\\/p>\\",\\"default_accordion\\":\\"open\\"},{\\"title_accordion\\":\\"Sip a coffee and get rolling\\",\\"text_accordion\\":\\"<p>Great, we are matched. The next step is to grab a coffee and get to know each other more. We can also do the consultation remotely (eg. using chat or video conference). <\\\\/p>\\",\\"default_accordion\\":\\"closed\\"},{\\"title_accordion\\":\\"Execution, revisions, refine, and refine\\",\\"text_accordion\\":\\"<p>Based on the scope of the project, I will send you in progress work for approvals and revisions. My work is not done until you are happy with it.<\\\\/p>\\",\\"default_accordion\\":\\"closed\\"},{\\"title_accordion\\":\\"Delivery, on time.\\",\\"text_accordion\\":\\"<p>Awesome, time to launch. Your journey begins here. I\\\'m happy to provide on-going works and support for you.<\\\\/p>\\",\\"default_accordion\\":\\"closed\\"}],\\"accordion_appearance_accordion\\":false,\\"expand_collapse_accordion\\":\\"toggle\\",\\"color_accordion\\":\\"transparent\\",\\"icon_active_accordion\\":\\"ti-minus\\",\\"icon_accordion\\":\\"ti-plus\\",\\"t_sh_t_blur_unit\\":\\"px\\",\\"t_sh_t_vShadow_unit\\":\\"px\\",\\"t_sh_t_hShadow_unit\\":\\"px\\",\\"l_s_t_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_title_unit\\":\\"px\\",\\"font_size_title\\":\\"35\\",\\"b_ct_left_style\\":\\"solid\\",\\"b_ct_bottom_style\\":\\"solid\\",\\"b_ct_bottom_width\\":\\"1\\",\\"b_ct_bottom_color\\":\\"#4d4d4d\\",\\"b_ct_right_style\\":\\"solid\\",\\"b_ct_top_style\\":\\"solid\\",\\"b_ct-type\\":\\"bottom\\",\\"checkbox_p_ct_apply_all\\":false,\\"p_ct_left_unit\\":\\"%\\",\\"p_ct_opp_left\\":false,\\"p_ct_bottom_unit\\":\\"%\\",\\"p_ct_right_unit\\":\\"%\\",\\"p_ct_opp_top\\":false,\\"p_ct_top_unit\\":\\"%\\",\\"p_ct_left\\":\\"5\\",\\"p_ct_bottom\\":\\"2\\",\\"p_ct_right\\":\\"5\\",\\"p_ct_top\\":\\"2\\",\\"checkbox_m_ct_apply_all\\":false,\\"m_ct_left_unit\\":\\"px\\",\\"m_ct_opp_left\\":false,\\"m_ct_bottom_unit\\":\\"px\\",\\"m_ct_right_unit\\":\\"px\\",\\"m_ct_opp_top\\":false,\\"m_ct_top_unit\\":\\"px\\",\\"border_accordion_left_style\\":\\"solid\\",\\"border_accordion_bottom_style\\":\\"solid\\",\\"border_accordion_right_style\\":\\"solid\\",\\"border_accordion_top_style\\":\\"solid\\",\\"border_accordion-type\\":\\"top\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"b_a_c_left_style\\":\\"solid\\",\\"b_a_c_bottom_style\\":\\"solid\\",\\"b_a_c_right_style\\":\\"solid\\",\\"b_a_c_top_style\\":\\"solid\\",\\"b_a_c-type\\":\\"bottom\\",\\"checkbox_r_c_ct_apply_all\\":false,\\"r_c_ct_left_unit\\":\\"px\\",\\"r_c_ct_opp_left\\":false,\\"r_c_ct_right_unit\\":\\"px\\",\\"r_c_ct_bottom_unit\\":\\"px\\",\\"r_c_ct_opp_bottom\\":false,\\"r_c_ct_top_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"t_sh_t_blur_unit\\":\\"px\\",\\"t_sh_t_vShadow_unit\\":\\"px\\",\\"t_sh_t_hShadow_unit\\":\\"px\\",\\"l_s_t_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_title_unit\\":\\"px\\",\\"font_size_title\\":\\"28\\"},\\"breakpoint_tablet_landscape\\":{\\"t_sh_t_blur_unit\\":\\"px\\",\\"t_sh_t_vShadow_unit\\":\\"px\\",\\"t_sh_t_hShadow_unit\\":\\"px\\",\\"l_s_t_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_title_unit\\":\\"px\\",\\"font_size_title\\":\\"30\\"},\\"t_sh_c_blur_unit\\":\\"px\\",\\"t_sh_c_vShadow_unit\\":\\"px\\",\\"t_sh_c_hShadow_unit\\":\\"px\\",\\"line_height_content_unit\\":\\"em\\",\\"line_height_content\\":\\"1.6\\",\\"font_size_content_unit\\":\\"px\\",\\"font_size_content\\":\\"18\\"}}],\\"styling\\":{\\"padding_bottom\\":0,\\"padding_bottom_unit\\":\\"px\\"}}],\\"styling\\":{\\"background_color\\":\\"#000000\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"font_color\\":\\"#ffffff\\",\\"padding_top_unit\\":\\"%\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"3\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false}}]}],\\"styling\\":{\\"padding_top\\":\\"120\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"0\\",\\"padding_opp_top\\":false,\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_top_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"80\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"80\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"90\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"90\\"},\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"hide_anchor\\":false,\\"background_gradient-circle-radial\\":false,\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient-type\\":\\"linear\\"}},{\\"element_id\\":\\"yvwq567\\",\\"cols\\":[{\\"element_id\\":\\"lebm568\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"zit5958\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/testimonial-quote-128x85.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"35\\",\\"margin_opp_top\\":false,\\"width_image\\":\\"128\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"saal836\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>What do people say about me<\\\\/h2>\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"i6a9797\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/03\\\\/testimonial-dots-145x19.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"35\\",\\"margin_opp_top\\":false,\\"width_image\\":\\"145\\"}},{\\"mod_name\\":\\"testimonial-slider\\",\\"element_id\\":\\"tuao805\\",\\"mod_settings\\":{\\"layout_testimonial\\":\\"image-bottom\\",\\"img_h_slider\\":\\"100\\",\\"img_w_slider\\":\\"100\\",\\"visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"off\\",\\"tab_content_testimonial\\":[{\\"content_testimonial\\":\\"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\\\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic Lorem Ipsum.<\\\\/p>\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/pro-profile\\\\/files\\\\/2020\\\\/03\\\\/jen.jpg\\",\\"person_name_testimonial\\":\\"Jen Allison\\",\\"person_position_testimonial\\":\\"Head of Marketing\\",\\"company_testimonial\\":\\"Digiflow\\"},{\\"content_testimonial\\":\\"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\\\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic Lorem Ipsum.<\\\\/p>\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/pro-profile\\\\/files\\\\/2020\\\\/03\\\\/james.jpg\\",\\"person_name_testimonial\\":\\"James Johnson\\",\\"person_position_testimonial\\":\\"CEO\\",\\"company_testimonial\\":\\"EXO CLOUD\\"},{\\"content_testimonial\\":\\"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\\\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic Lorem Ipsum.<\\\\/p>\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/pro-profile\\\\/files\\\\/2020\\\\/03\\\\/sophia.jpg\\",\\"person_name_testimonial\\":\\"Sophia Martinez\\",\\"person_position_testimonial\\":\\"H&R Manager\\",\\"company_testimonial\\":\\"Aspire\\"}],\\"height_slider\\":\\"variable\\",\\"show_arrow_buttons_vertical\\":\\"vertical\\",\\"show_arrow_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"no\\",\\"wrap_slider\\":\\"yes\\",\\"play_pause_control\\":\\"no\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"effect_slider\\":\\"scroll\\",\\"speed_opt_slider\\":\\"normal\\",\\"scroll_opt_slider\\":\\"1\\",\\"mob_visible_opt_slider\\":\\"0\\",\\"masonry\\":\\"disable\\",\\"grid_layout_testimonial\\":\\"list-post\\",\\"type_testimonial\\":\\"slider\\",\\"tab_visible_opt_slider\\":\\"0\\",\\"font_color_arrows_controls\\":\\"#000000\\",\\"background_color_arrows_controls\\":\\"#ffffff_0.00\\"}}]}],\\"styling\\":{\\"padding_top\\":\\"120\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"120\\",\\"padding_opp_top\\":false,\\"background_color\\":\\"#eeeeee\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_top_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"80\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"80\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"90\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"90\\"},\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"background_gradient-circle-radial\\":false,\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient-type\\":\\"linear\\"}},{\\"element_id\\":\\"th63777\\",\\"cols\\":[{\\"element_id\\":\\"tl3g778\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"f1uv362\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Portfolio<\\\\/h2>\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"35\\",\\"padding_opp_top\\":false,\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"mod_name\\":\\"portfolio\\",\\"element_id\\":\\"fgba162\\",\\"mod_settings\\":{\\"post_per_page_portfolio\\":\\"3\\",\\"hide_page_nav_portfolio\\":\\"yes\\",\\"display_portfolio\\":\\"none\\",\\"hide_post_meta_portfolio\\":\\"no\\",\\"hide_post_date_portfolio\\":\\"yes\\",\\"unlink_post_title_portfolio\\":\\"no\\",\\"hide_post_title_portfolio\\":\\"no\\",\\"unlink_feat_img_portfolio\\":\\"no\\",\\"auto_fullwidth_portfolio\\":false,\\"hide_feat_img_portfolio\\":\\"no\\",\\"orderby_portfolio\\":\\"date\\",\\"order_portfolio\\":\\"desc\\",\\"post_filter\\":\\"no\\",\\"layout_portfolio\\":\\"grid3\\",\\"category_portfolio\\":\\"0|single\\",\\"term_type\\":\\"category\\",\\"img_height_portfolio\\":\\"460\\",\\"img_width_portfolio\\":\\"360\\",\\"portfolio_content_layout\\":\\"overlay\\"}}]}],\\"styling\\":{\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"120\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top\\":\\"120\\",\\"hide_anchor\\":false,\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"80\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"80\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"90\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"90\\"}}},{\\"element_id\\":\\"d5pv601\\",\\"cols\\":[{\\"element_id\\":\\"gnqe602\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"nfpj619\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Get in contact<\\\\/h2>\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"35\\",\\"padding_opp_top\\":false,\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"z86w980\\",\\"mod_settings\\":{\\"field_name_label\\":\\"Name\\",\\"field_email_label\\":\\"Email\\",\\"field_subject_label\\":\\"Subject\\",\\"field_message_label\\":\\"Message\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_send_label\\":\\"Contact\\",\\"gdpr_label\\":\\"I consent to my submitted data being collected and stored\\",\\"field_name_require\\":\\"yes\\",\\"field_email_require\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_email_active\\":\\"yes\\",\\"field_subject_active\\":\\"yes\\",\\"field_subject_require\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"field_send_align\\":\\"center\\",\\"field_extra\\":\\"{\\\\\\"fields\\\\\\":[]}\\",\\"field_order\\":\\"{\\\\\\"field_name_label\\\\\\":0,\\\\\\"field_email_label\\\\\\":1,\\\\\\"field_subject_label\\\\\\":2,\\\\\\"field_message_label\\\\\\":3}\\",\\"field_optin_label\\":\\"Subscribe to my newsletter.\\",\\"field_optin_active\\":false,\\"mailchimp_list\\":\\"0f2a95e5de\\",\\"provider\\":\\"mailchimp\\",\\"field_sendcopy_active\\":false,\\"field_captcha_active\\":false,\\"contact_sent_from\\":\\"enable\\",\\"post_author\\":false,\\"user_role\\":\\"admin\\",\\"send_to_admins\\":\\"true\\",\\"layout_contact\\":\\"animated-label\\"}}]}],\\"styling\\":{\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"120\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top\\":\\"120\\",\\"background_color\\":\\"#fbfbfb\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"80\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"80\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"90\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"90\\"},\\"background_gradient-circle-radial\\":false,\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"hide_anchor\\":false,\\"row_anchor\\":\\"contact-form-home\\"}}]',
    'themify_used_global_styles' => 
    array (
      0 => 'tb_gs2765ec',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 263,
  'post_date' => '2020-05-22 16:23:23',
  'post_date_gmt' => '2020-05-22 16:23:23',
  'post_content' => '<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Portfolio',
  'post_excerpt' => '',
  'post_name' => 'portfolio',
  'post_modified' => '2020-06-03 03:46:33',
  'post_modified_gmt' => '2020-06-03 03:46:33',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?page_id=263',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"pgb7872\\",\\"cols\\":[{\\"element_id\\":\\"zgrq873\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"cu2m4\\",\\"cols\\":[{\\"element_id\\":\\"4u764\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"7f5u824\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Portfolio<\\\\/h1>\\\\n<p>You can find some of my previous projects below. If you are inspired to start a project, <a href=\\\\\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/about\\\\/\\\\\\">contact me<\\\\/a> to get a free consultation.<\\\\/p>\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"25\\",\\"margin_opp_top\\":false}}]}],\\"styling\\":{\\"global_styles\\":\\"tb_gs2765ec\\"}}]},{\\"element_id\\":\\"7b9g897\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"yl6d300\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/files\\\\/2020\\\\/05\\\\/girl-with-camera-600x760.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-top\\",\\"height_image\\":\\"760\\",\\"width_image\\":\\"600\\",\\"custom_parallax_scroll_zindex\\":\\"1\\",\\"margin_left\\":\\"-40\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"margin_bottom\\":\\"-40\\",\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_speed\\":\\"1\\",\\"v_dir\\":\\"up\\"}}},\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_width_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_left\\":\\"0\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"0\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}],\\"styling\\":{\\"background_color\\":\\"#f5f5f5\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"40\\",\\"breakpoint_mobile\\":{\\"cover_gradient-circle-radial\\":false,\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_color-type\\":\\"color\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_gradient-circle-radial\\":false,\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"background_color\\":\\"#ffffff\\"}}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"column_h\\":1,\\"col_tablet_landscape\\":\\"column4-2\\",\\"col_tablet\\":\\"column4-2\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"row_width\\":\\"fullwidth\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"padding_bottom\\":0,\\"padding_bottom_unit\\":\\"px\\"}},{\\"element_id\\":\\"cwms641\\",\\"cols\\":[{\\"element_id\\":\\"2wka642\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"it0z723\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>10+ years<\\\\/h3>\\\\n<h4>experience<\\\\/h4>\\",\\"breakpoint_mobile\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"50\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"h4_margin_bottom_unit\\":\\"px\\",\\"h4_margin_bottom\\":\\"40\\",\\"h4_margin_top_unit\\":\\"px\\",\\"t_shh4_blur_unit\\":\\"px\\",\\"t_shh4_vShadow_unit\\":\\"px\\",\\"t_shh4_hShadow_unit\\":\\"px\\",\\"letter_spacing_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_gradient_color_h4-circle-radial\\":false,\\"font_gradient_color_h4-gradient-angle\\":\\"180\\",\\"font_gradient_color_h4-gradient-type\\":\\"linear\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"},\\"breakpoint_tablet\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"50\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"}}]},{\\"element_id\\":\\"nuno719\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"lg0x206\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>108 projects<\\\\/h3>\\\\n<h4>completed<\\\\/h4>\\",\\"breakpoint_mobile\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"50\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"h4_margin_bottom_unit\\":\\"px\\",\\"h4_margin_bottom\\":\\"40\\",\\"h4_margin_top_unit\\":\\"px\\",\\"t_shh4_blur_unit\\":\\"px\\",\\"t_shh4_vShadow_unit\\":\\"px\\",\\"t_shh4_hShadow_unit\\":\\"px\\",\\"letter_spacing_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_gradient_color_h4-circle-radial\\":false,\\"font_gradient_color_h4-gradient-angle\\":\\"180\\",\\"font_gradient_color_h4-gradient-type\\":\\"linear\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"},\\"breakpoint_tablet\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"50\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"}}}]},{\\"element_id\\":\\"8pcw719\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2y4s917\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>23 awards<\\\\/h3>\\\\n<h4>received<\\\\/h4>\\",\\"breakpoint_mobile\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"50\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"h4_margin_bottom_unit\\":\\"px\\",\\"h4_margin_bottom\\":\\"40\\",\\"h4_margin_top_unit\\":\\"px\\",\\"t_shh4_blur_unit\\":\\"px\\",\\"t_shh4_vShadow_unit\\":\\"px\\",\\"t_shh4_hShadow_unit\\":\\"px\\",\\"letter_spacing_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_gradient_color_h4-circle-radial\\":false,\\"font_gradient_color_h4-gradient-angle\\":\\"180\\",\\"font_gradient_color_h4-gradient-type\\":\\"linear\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"},\\"breakpoint_tablet\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"50\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"}}}]}],\\"col_tablet_landscape\\":\\"column3-1\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"padding_bottom\\":123,\\"padding_bottom_unit\\":\\"px\\",\\"padding_top\\":142,\\"padding_top_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"16\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"24\\",\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\"1\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"50\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_h4\\":\\"#ffffff\\",\\"row_width\\":\\"fullwidth\\",\\"font_color_h3\\":\\"#ffffff\\",\\"background_color\\":\\"#000000\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"margin-top\\":0,\\"hide_anchor\\":false,\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"80\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"100\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"100\\"},\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"h4_margin_bottom_unit\\":\\"px\\",\\"h4_margin_top_unit\\":\\"px\\",\\"t_shh4_blur_unit\\":\\"px\\",\\"t_shh4_vShadow_unit\\":\\"px\\",\\"t_shh4_hShadow_unit\\":\\"px\\",\\"letter_spacing_h4_unit\\":\\"em\\",\\"letter_spacing_h4\\":\\"0.3\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_gradient_color_h4-circle-radial\\":false,\\"font_gradient_color_h4-gradient-angle\\":\\"180\\",\\"font_gradient_color_h4-gradient-type\\":\\"linear\\"}},{\\"element_id\\":\\"u2fy967\\",\\"cols\\":[{\\"element_id\\":\\"xo9x968\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2x6u318\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Below are some of my selected works. My expertise are copywriting, SEO marketing, and web design. If you have projects in other fields, let me know. I can help as well.<\\\\/p>\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"padding_opp_left\\":\\"1\\",\\"padding_opp_top\\":false,\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"border-type\\":\\"bottom\\",\\"border_bottom_style\\":\\"none\\",\\"border_top_style\\":\\"none\\",\\"breakpoint_mobile\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"24\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"em\\",\\"line_height\\":\\"1.6\\",\\"font_size_unit\\":\\"px\\",\\"font_size\\":\\"24\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_top_unit\\":\\"px\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"em\\",\\"line_height\\":\\"1.6\\",\\"font_size_unit\\":\\"px\\",\\"font_size\\":\\"28\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ygln122\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>My latest work<\\\\/h3>\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"48\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"margin_top\\":\\"60\\",\\"margin_bottom\\":\\"40\\",\\"breakpoint_mobile\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"36\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"portfolio\\",\\"element_id\\":\\"x5g7399\\",\\"mod_settings\\":{\\"post_per_page_portfolio\\":\\"6\\",\\"hide_page_nav_portfolio\\":\\"no\\",\\"display_portfolio\\":\\"none\\",\\"hide_post_meta_portfolio\\":\\"no\\",\\"hide_post_date_portfolio\\":\\"yes\\",\\"unlink_post_title_portfolio\\":\\"no\\",\\"hide_post_title_portfolio\\":\\"no\\",\\"unlink_feat_img_portfolio\\":\\"no\\",\\"auto_fullwidth_portfolio\\":false,\\"hide_feat_img_portfolio\\":\\"no\\",\\"orderby_portfolio\\":\\"date\\",\\"order_portfolio\\":\\"desc\\",\\"post_filter\\":\\"no\\",\\"layout_portfolio\\":\\"grid3\\",\\"category_portfolio\\":\\"0|single\\",\\"term_type\\":\\"category\\",\\"img_height_portfolio\\":\\"460\\",\\"img_width_portfolio\\":\\"360\\",\\"portfolio_content_layout\\":\\"overlay\\"}}]}],\\"styling\\":{\\"margin-top\\":59,\\"margin-top_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"hide_anchor\\":false,\\"padding_top\\":\\"58\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_bottom\\":75,\\"padding_bottom_unit\\":\\"px\\"}},{\\"element_id\\":\\"mc19837\\",\\"cols\\":[{\\"element_id\\":\\"rq9v838\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"e37u273\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Free Initial Project Consultation<\\\\/h3>\\\\n<p>If you have a great idea, reach out to me. Whether it is a small or big project, I listen first and get back to you with a plan. <\\\\/p>\\",\\"text_align\\":\\"right\\",\\"font_color_type\\":\\"font_color_solid\\",\\"breakpoint_tablet_landscape\\":{\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"right\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_tablet\\":{\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"right\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_mobile\\":{\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"left\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"}}}]},{\\"element_id\\":\\"zu23705\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"o992335\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Contact\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-profile\\\\/contact\\\\/\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"solid\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"checkbox_l_b_r_c_apply_all\\":\\"1\\",\\"l_b_r_c_left_unit\\":\\"px\\",\\"l_b_r_c_right_unit\\":\\"px\\",\\"l_b_r_c_bottom_unit\\":\\"px\\",\\"l_b_r_c_top_unit\\":\\"px\\",\\"l_b_r_c_top\\":\\"30\\",\\"checkbox_padding_link_apply_all\\":false,\\"padding_link_left_unit\\":\\"px\\",\\"padding_link_opp_left\\":\\"1\\",\\"padding_link_bottom_unit\\":\\"px\\",\\"padding_link_right_unit\\":\\"px\\",\\"padding_link_opp_top\\":\\"1\\",\\"padding_link_top_unit\\":\\"px\\",\\"padding_link_top\\":\\"20\\",\\"checkbox_b_ra_apply_all\\":\\"1\\",\\"b_ra_left_unit\\":\\"px\\",\\"b_ra_right_unit\\":\\"px\\",\\"b_ra_bottom_unit\\":\\"px\\",\\"b_ra_top_unit\\":\\"px\\",\\"b_p_h\\":\\"50,50\\",\\"b_r_h\\":\\"repeat\\",\\"button_hover_background_color\\":\\"#e40e0e\\",\\"b_i_h-circle-radial\\":false,\\"b_i_h-gradient-angle\\":\\"180\\",\\"b_i_h-gradient-type\\":\\"linear\\",\\"b_i_h-type\\":\\"image\\",\\"b_p\\":\\"50,50\\",\\"b_r\\":\\"repeat\\",\\"button_background_color\\":\\"#000000\\",\\"b_i-circle-radial\\":false,\\"b_i-gradient-angle\\":\\"180\\",\\"b_i-gradient-type\\":\\"linear\\",\\"b_i-type\\":\\"image\\",\\"background_position\\":\\"50,50\\",\\"background_repeat\\":\\"repeat\\",\\"background_image-circle-radial\\":false,\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-type\\":\\"image\\",\\"alignment\\":\\"left\\",\\"padding_link_left\\":\\"30\\",\\"padding_link_bottom\\":\\"20\\",\\"padding_link_right\\":\\"30\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_size\\":\\"28\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_link_margin_apply_all\\":false,\\"link_margin_left_unit\\":\\"px\\",\\"link_margin_opp_left\\":false,\\"link_margin_bottom_unit\\":\\"px\\",\\"link_margin_right_unit\\":\\"px\\",\\"link_margin_opp_top\\":false,\\"link_margin_top_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_left\\":\\"50\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"checkbox_link_margin_apply_all\\":false,\\"link_margin_left_unit\\":\\"px\\",\\"link_margin_opp_left\\":false,\\"link_margin_bottom_unit\\":\\"px\\",\\"link_margin_right_unit\\":\\"px\\",\\"link_margin_opp_top\\":false,\\"link_margin_top_unit\\":\\"px\\",\\"checkbox_padding_link_apply_all\\":false,\\"padding_link_left_unit\\":\\"px\\",\\"padding_link_left\\":\\"20\\",\\"padding_link_opp_left\\":\\"1\\",\\"padding_link_bottom_unit\\":\\"px\\",\\"padding_link_bottom\\":\\"10\\",\\"padding_link_right_unit\\":\\"px\\",\\"padding_link_right\\":\\"20\\",\\"padding_link_opp_top\\":\\"1\\",\\"padding_link_top_unit\\":\\"px\\",\\"padding_link_top\\":\\"10\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_left\\":\\"0\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_size\\":\\"22\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_link_apply_all\\":false,\\"padding_link_left_unit\\":\\"px\\",\\"padding_link_left\\":\\"25\\",\\"padding_link_opp_left\\":\\"1\\",\\"padding_link_bottom_unit\\":\\"px\\",\\"padding_link_bottom\\":\\"15\\",\\"padding_link_right_unit\\":\\"px\\",\\"padding_link_right\\":\\"25\\",\\"padding_link_opp_top\\":\\"1\\",\\"padding_link_top_unit\\":\\"px\\",\\"padding_link_top\\":\\"15\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_size\\":\\"24\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_link_apply_all\\":false,\\"padding_link_left_unit\\":\\"px\\",\\"padding_link_left\\":\\"25\\",\\"padding_link_opp_left\\":\\"1\\",\\"padding_link_bottom_unit\\":\\"px\\",\\"padding_link_bottom\\":\\"15\\",\\"padding_link_right_unit\\":\\"px\\",\\"padding_link_right\\":\\"25\\",\\"padding_link_opp_top\\":\\"1\\",\\"padding_link_top_unit\\":\\"px\\",\\"padding_link_top\\":\\"15\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_size\\":\\"26\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"}}}],\\"styling\\":{\\"border_left_width\\":\\"3\\",\\"border_left_color\\":\\"#000000\\",\\"border-type\\":\\"left\\",\\"breakpoint_mobile\\":{\\"border_left_style\\":\\"none\\",\\"border_left_width\\":\\"3\\",\\"border_left_color\\":\\"#000000\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"left\\"}}}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet_landscape\\":\\"column3-2-3-1\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"padding_top\\":115,\\"padding_opp_left\\":false,\\"padding_bottom\\":115,\\"padding_opp_top\\":\\"1\\",\\"background_color\\":\\"#f9f9f9\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"margin-top_opp_top\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_top_unit\\":\\"px\\"}}]',
    'themify_used_global_styles' => 
    array (
      0 => 'tb_gs2765ec',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 276,
  'post_date' => '2020-05-26 04:54:30',
  'post_date_gmt' => '2020-05-26 04:54:30',
  'post_content' => '',
  'post_title' => 'Box Shadow',
  'post_excerpt' => '',
  'post_name' => 'tb_gs2765ec',
  'post_modified' => '2020-05-26 06:19:54',
  'post_modified_gmt' => '2020-05-26 06:19:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/tglobal-style/box-shadow/',
  'menu_order' => 0,
  'post_type' => 'tglobal_style',
  'meta_input' => 
  array (
    'themify_global_style_type' => 'subrow',
    'hide_page_title' => 'yes',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_wp_old_slug' => 'box-shadow',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"row5ecca106bffdc\\",\\"styling\\":{\\"b_sh_inset\\":\\"false\\",\\"b_sh_color\\":\\"#000000_0.06\\",\\"b_sh_spread_unit\\":\\"px\\",\\"b_sh_spread\\":\\"5\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"10\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"2\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"2\\",\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"top\\",\\"checkbox_margin_apply_all\\":\\"false\\",\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":\\"false\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"45\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":\\"false\\",\\"margin_top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"false\\",\\"padding_left_unit\\":\\"px\\",\\"padding_left\\":\\"50\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"50\\",\\"padding_right_unit\\":\\"px\\",\\"padding_right\\":\\"50\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"50\\",\\"zi\\":\\"3\\",\\"background_color\\":\\"#ffffff\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":\\"false\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_gradient-circle-radial\\":\\"false\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 241,
  'post_date' => '2020-03-16 07:28:48',
  'post_date_gmt' => '2020-03-16 07:28:48',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam.',
  'post_title' => 'New York Coffee',
  'post_excerpt' => '',
  'post_name' => 'new-york-coffee',
  'post_modified' => '2020-03-16 07:29:28',
  'post_modified_gmt' => '2020-03-16 07:29:28',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?post_type=portfolio&#038;p=241',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'Aug, 13 2019',
    'project_client' => 'New York Coffee',
    'project_services' => 'Marketing / Web Design / Banner Design',
    'project_launch' => 'https://themify.me/',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"smyj626\\",\\"cols\\":[{\\"element_id\\":\\"hhoh627\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'design, web',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-profile/files/2020/03/morning-coffee.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 231,
  'post_date' => '2020-03-16 07:25:24',
  'post_date_gmt' => '2020-03-16 07:25:24',
  'post_content' => 'Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'The Fighter',
  'post_excerpt' => '',
  'post_name' => 'the-fighter',
  'post_modified' => '2020-03-16 07:28:20',
  'post_modified_gmt' => '2020-03-16 07:28:20',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?post_type=portfolio&#038;p=231',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'Aug, 20 2019',
    'project_client' => 'Extreme Gym',
    'project_services' => 'Web Design / Banner Design ',
    'project_launch' => 'https://themify.me/',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"4hpu84\\",\\"cols\\":[{\\"element_id\\":\\"e5cg85\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'design, web',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-profile/files/2020/03/fighter.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 240,
  'post_date' => '2020-03-16 07:24:49',
  'post_date_gmt' => '2020-03-16 07:24:49',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”  repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.',
  'post_title' => 'Chicago',
  'post_excerpt' => '',
  'post_name' => 'chicago',
  'post_modified' => '2020-03-16 07:27:52',
  'post_modified_gmt' => '2020-03-16 07:27:52',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?post_type=portfolio&#038;p=240',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'Aug, 15 2019',
    'project_client' => 'Brandon & Friends Company',
    'project_services' => 'Web Design / Banner Design / Marketing',
    'project_launch' => 'https://themify.me/',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"xqka87\\",\\"cols\\":[{\\"element_id\\":\\"kd4f87\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'marketing, web',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-profile/files/2020/03/chicago.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 242,
  'post_date' => '2020-03-16 07:24:09',
  'post_date_gmt' => '2020-03-16 07:24:09',
  'post_content' => 'Labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.',
  'post_title' => 'All About Bread',
  'post_excerpt' => '',
  'post_name' => 'all-about-bread',
  'post_modified' => '2020-03-16 07:24:09',
  'post_modified_gmt' => '2020-03-16 07:24:09',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?post_type=portfolio&#038;p=242',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'July, 25 2019',
    'project_client' => 'All About Bread',
    'project_services' => 'Web Design / Banner Design ',
    'project_launch' => 'https://themify.me/',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"e89x696\\",\\"cols\\":[{\\"element_id\\":\\"xpj0697\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'web',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-profile/files/2020/03/bread.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 237,
  'post_date' => '2020-03-16 07:23:41',
  'post_date_gmt' => '2020-03-16 07:23:41',
  'post_content' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.',
  'post_title' => 'Color of Nature',
  'post_excerpt' => '',
  'post_name' => 'color-of-nature',
  'post_modified' => '2020-03-16 07:29:44',
  'post_modified_gmt' => '2020-03-16 07:29:44',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?post_type=portfolio&#038;p=237',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'Aug, 18 2019',
    'project_client' => 'Jennie Florist',
    'project_services' => 'Flyer Banner / Design',
    'project_launch' => 'https://themify.me/',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"c4qz9\\",\\"cols\\":[{\\"element_id\\":\\"micl10\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'design',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-profile/files/2020/03/the-florist.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 245,
  'post_date' => '2020-03-16 07:23:18',
  'post_date_gmt' => '2020-03-16 07:23:18',
  'post_content' => 'Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatu.


At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis.',
  'post_title' => 'Elegant Vintage',
  'post_excerpt' => '',
  'post_name' => 'elegant-vintage',
  'post_modified' => '2020-03-16 07:28:55',
  'post_modified_gmt' => '2020-03-16 07:28:55',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?post_type=portfolio&#038;p=245',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'July, 23 2019',
    'project_client' => 'Mercedes Benz',
    'project_services' => 'Web Design / Banner Design ',
    'project_launch' => 'https://themify.me/',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"eait407\\",\\"cols\\":[{\\"element_id\\":\\"ibv3408\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'design',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-profile/files/2020/03/vintage-car.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 239,
  'post_date' => '2020-03-16 07:18:28',
  'post_date_gmt' => '2020-03-16 07:18:28',
  'post_content' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.

Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.',
  'post_title' => 'Aura project',
  'post_excerpt' => '',
  'post_name' => 'aura-project',
  'post_modified' => '2020-03-16 07:18:28',
  'post_modified_gmt' => '2020-03-16 07:18:28',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?post_type=portfolio&#038;p=239',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'Aug, 17 2019',
    'project_client' => 'Aura Design Agency',
    'project_services' => 'Web Design / Banner Design / Marketing',
    'project_launch' => 'https://themify.me/',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"hea2628\\",\\"cols\\":[{\\"element_id\\":\\"6qsx630\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'design',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-profile/files/2020/03/designer.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 162,
  'post_date' => '2020-03-12 07:34:57',
  'post_date_gmt' => '2020-03-12 07:34:57',
  'post_content' => 'ero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.

Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.

. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.',
  'post_title' => 'Contentz.co - Content Writing Service',
  'post_excerpt' => '',
  'post_name' => 'contentz-content-writer-service',
  'post_modified' => '2020-03-16 04:22:56',
  'post_modified_gmt' => '2020-03-16 04:22:56',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?post_type=portfolio&#038;p=162',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'Aug, 29 2019',
    'project_client' => 'Contentz',
    'project_services' => 'Marketing / Web Design / Banner Design',
    'project_launch' => 'https://themify.me/',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"6mi9295\\",\\"cols\\":[{\\"element_id\\":\\"st27296\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'marketing',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-profile/files/2020/03/content-writer.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 154,
  'post_date' => '2020-03-12 07:29:27',
  'post_date_gmt' => '2020-03-12 07:29:27',
  'post_content' => 'Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'Ethnic Pet',
  'post_excerpt' => '',
  'post_name' => 'ethnic-pet',
  'post_modified' => '2020-03-16 07:28:32',
  'post_modified_gmt' => '2020-03-16 07:28:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?post_type=portfolio&#038;p=154',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'Sep, 21 2019',
    'project_client' => 'Ethnic Pet',
    'project_services' => 'Web Design - Banner Design - SEO',
    'project_launch' => 'https://themify.me/',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"kcjm249\\",\\"cols\\":[{\\"element_id\\":\\"naon251\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'web',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-profile/files/2020/03/shop-ethnic-pet.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 158,
  'post_date' => '2020-03-12 07:19:26',
  'post_date_gmt' => '2020-03-12 07:19:26',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.

Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.

',
  'post_title' => 'Wedding Anniversary',
  'post_excerpt' => '',
  'post_name' => 'wedding-anniversary',
  'post_modified' => '2020-03-12 07:19:26',
  'post_modified_gmt' => '2020-03-12 07:19:26',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?post_type=portfolio&#038;p=158',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'Sept, 27 2019',
    'project_client' => 'Bryan and May Johnson',
    'project_services' => 'Flyer Banner / Design',
    'project_launch' => 'https://themify.me/',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"epsf549\\",\\"cols\\":[{\\"element_id\\":\\"axih551\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'design',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-profile/files/2020/03/wedding-anniversary.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 92,
  'post_date' => '2020-03-11 03:35:54',
  'post_date_gmt' => '2020-03-11 03:35:54',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '92',
  'post_modified' => '2020-05-22 16:26:11',
  'post_modified_gmt' => '2020-05-22 16:26:11',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?p=92',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '9',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 91,
  'post_date' => '2020-03-11 03:35:54',
  'post_date_gmt' => '2020-03-11 03:35:54',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '91',
  'post_modified' => '2020-05-22 16:26:11',
  'post_modified_gmt' => '2020-05-22 16:26:11',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?p=91',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '87',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 271,
  'post_date' => '2020-05-22 16:26:08',
  'post_date_gmt' => '2020-05-22 16:26:08',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '271',
  'post_modified' => '2020-05-22 16:26:11',
  'post_modified_gmt' => '2020-05-22 16:26:11',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?p=271',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '263',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 270,
  'post_date' => '2020-05-22 16:26:08',
  'post_date_gmt' => '2020-05-22 16:26:08',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '270',
  'post_modified' => '2020-05-22 16:26:11',
  'post_modified_gmt' => '2020-05-22 16:26:11',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?p=270',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '266',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 90,
  'post_date' => '2020-03-11 03:35:35',
  'post_date_gmt' => '2020-03-11 03:35:35',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '90',
  'post_modified' => '2020-05-22 16:26:46',
  'post_modified_gmt' => '2020-05-22 16:26:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?p=90',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '9',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 89,
  'post_date' => '2020-03-11 03:35:35',
  'post_date_gmt' => '2020-03-11 03:35:35',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '89',
  'post_modified' => '2020-05-22 16:26:46',
  'post_modified_gmt' => '2020-05-22 16:26:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?p=89',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '87',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 273,
  'post_date' => '2020-05-22 16:26:46',
  'post_date_gmt' => '2020-05-22 16:26:46',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '273',
  'post_modified' => '2020-05-22 16:26:46',
  'post_modified_gmt' => '2020-05-22 16:26:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?p=273',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '263',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 272,
  'post_date' => '2020-05-22 16:26:46',
  'post_date_gmt' => '2020-05-22 16:26:46',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '272',
  'post_modified' => '2020-05-22 16:26:46',
  'post_modified_gmt' => '2020-05-22 16:26:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-profile/?p=272',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '266',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_themify_highlight_link' => '1',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );



function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_search" );
$widgets[1002] = array (
  'title' => '',
);
update_option( "widget_search", $widgets );

$widgets = get_option( "widget_recent-posts" );
$widgets[1003] = array (
  'title' => '',
  'number' => 5,
);
update_option( "widget_recent-posts", $widgets );

$widgets = get_option( "widget_recent-comments" );
$widgets[1004] = array (
  'title' => '',
  'number' => 5,
);
update_option( "widget_recent-comments", $widgets );

$widgets = get_option( "widget_archives" );
$widgets[1005] = array (
  'title' => '',
  'count' => 0,
  'dropdown' => 0,
);
update_option( "widget_archives", $widgets );

$widgets = get_option( "widget_categories" );
$widgets[1006] = array (
  'title' => '',
  'count' => 0,
  'hierarchical' => 0,
  'dropdown' => 0,
);
update_option( "widget_categories", $widgets );

$widgets = get_option( "widget_meta" );
$widgets[1007] = array (
  'title' => '',
);
update_option( "widget_meta", $widgets );

$widgets = get_option( "widget_themify-social-links" );
$widgets[1008] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );



$sidebars_widgets = array (
  'sidebar-main' => 
  array (
    0 => 'search-1002',
    1 => 'recent-posts-1003',
    2 => 'recent-comments-1004',
  ),
  'sidebar-alt' => 
  array (
    0 => 'archives-1005',
    1 => 'categories-1006',
    2 => 'meta-1007',
  ),
  'footer-social-widget' => 
  array (
    0 => 'themify-social-links-1008',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$homepage = get_posts( array( 'name' => 'home', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			$themify_data = array (
  'setting-webfonts_list' => 'recommended',
  'setting-default_layout' => 'sidebar1',
  'setting-default_post_layout' => 'list-post',
  'setting-post_filter' => 'no',
  'setting-disable_masonry' => 'yes',
  'setting-post_gutter' => 'gutter',
  'setting-default_layout_display' => 'content',
  'setting-default_more_text' => 'More',
  'setting-index_orderby' => 'date',
  'setting-index_order' => 'DESC',
  'setting-default_media_position' => 'above',
  'setting-image_post_feature_size' => 'blank',
  'setting-default_page_post_layout' => 'sidebar1',
  'setting-default_page_post_layout_type' => 'classic',
  'setting-default_page_single_media_position' => 'above',
  'setting-image_post_single_feature_size' => 'blank',
  'setting-search-result_layout_display' => 'content',
  'setting-search-result_media_position' => 'above',
  'setting-default_page_layout' => 'sidebar1',
  'setting-custom_post_tglobal_style_single' => 'sidebar1',
  'setting-default_portfolio_index_layout' => 'sidebar-none',
  'setting-default_portfolio_index_post_layout' => 'grid3',
  'setting-portfolio_post_filter' => 'yes',
  'setting-portfolio_disable_masonry' => 'yes',
  'setting-portfolio_gutter' => 'gutter',
  'setting-default_portfolio_index_display' => 'none',
  'setting-default_portfolio_index_title' => ' ',
  'setting-default_portfolio_index_unlink_post_title' => ' ',
  'setting-default_portfolio_index_hide_post_date' => ' ',
  'setting-default_portfolio_index_post_meta_category' => 'yes',
  'setting-default_portfolio_index_unlink_post_image' => 'yes',
  'setting-default_portfolio_single_layout' => 'sidebar-none',
  'setting-default_portfolio_single_portfolio_layout_type' => 'fullwidth',
  'setting-default_portfolio_single_title' => ' ',
  'setting-default_portfolio_single_unlink_post_title' => ' ',
  'setting-default_portfolio_single_hide_post_date' => ' ',
  'setting-default_portfolio_single_post_meta_category' => ' ',
  'setting-default_portfolio_single_unlink_post_image' => 'yes',
  'themify_portfolio_slug' => 'project',
  'themify_portfolio_category_slug' => 'portfolio-category',
  'setting-customizer_responsive_design_tablet_landscape' => '1280',
  'setting-customizer_responsive_design_tablet' => '768',
  'setting-customizer_responsive_design_mobile' => '680',
  'setting-mobile_menu_trigger_point' => '900',
  'setting-gallery_lightbox' => 'lightbox',
  'setting-header_design' => 'header-horizontal',
  'setting-exclude_site_tagline' => 'on',
  'setting_search_form' => 'live_search',
  'setting-exclude_rss' => 'on',
  'setting-header_widgets' => 'headerwidget-3col',
  'setting-footer_design' => 'footer-horizontal-left',
  'setting-use_float_back' => 'on',
  'setting-footer_widgets' => 'footerwidget-3col',
  'setting-mega_menu_posts' => '5',
  'setting-mega_menu_image_width' => '180',
  'setting-mega_menu_image_height' => '120',
  'setting-mega_menu_post_count' => 'off',
  'setting-imagefilter_applyto' => 'featuredonly',
  'setting-color_animation_speed' => '5',
  'setting-relationship_taxonomy' => 'category',
  'setting-relationship_taxonomy_entries' => '3',
  'setting-relationship_taxonomy_display_content' => 'none',
  'setting-single_slider_autoplay' => 'off',
  'setting-single_slider_speed' => 'normal',
  'setting-single_slider_effect' => 'slide',
  'setting-single_slider_height' => 'auto',
  'setting-more_posts' => 'infinite',
  'setting-entries_nav' => 'numbered',
  'setting-footer_text_left_hide' => 'hide',
  'setting-footer_text_right_hide' => 'hide',
  'setting-img_php_base_size' => 'large',
  'setting-global_feature_size' => 'blank',
  'setting-link_icon_type' => 'font-icon',
  'setting-link_type_themify-link-0' => 'image-icon',
  'setting-link_title_themify-link-0' => 'Twitter',
  'setting-link_img_themify-link-0' => 'https://themify.me/demo/themes/ultra-profile/wp-content/themes/themify-ultra/themify/img/social/twitter.png',
  'setting-link_type_themify-link-1' => 'image-icon',
  'setting-link_title_themify-link-1' => 'Facebook',
  'setting-link_img_themify-link-1' => 'https://themify.me/demo/themes/ultra-profile/wp-content/themes/themify-ultra/themify/img/social/facebook.png',
  'setting-link_type_themify-link-2' => 'image-icon',
  'setting-link_title_themify-link-2' => 'YouTube',
  'setting-link_img_themify-link-2' => 'https://themify.me/demo/themes/ultra-profile/wp-content/themes/themify-ultra/themify/img/social/youtube.png',
  'setting-link_type_themify-link-3' => 'image-icon',
  'setting-link_title_themify-link-3' => 'Pinterest',
  'setting-link_img_themify-link-3' => 'https://themify.me/demo/themes/ultra-profile/wp-content/themes/themify-ultra/themify/img/social/pinterest.png',
  'setting-link_type_themify-link-5' => 'font-icon',
  'setting-link_title_themify-link-5' => 'Facebook',
  'setting-link_link_themify-link-5' => 'https://www.facebook.com/themify',
  'setting-link_ficon_themify-link-5' => 'ti-facebook',
  'setting-link_ficolor_themify-link-5' => 'rgba(255, 255, 255, 1)',
  'setting-link_type_themify-link-4' => 'font-icon',
  'setting-link_title_themify-link-4' => 'Twitter',
  'setting-link_link_themify-link-4' => 'https://www.twitter.com/themify',
  'setting-link_ficon_themify-link-4' => 'ti-twitter-alt',
  'setting-link_ficolor_themify-link-4' => 'rgba(255, 255, 255, 1)',
  'setting-link_type_themify-link-6' => 'font-icon',
  'setting-link_title_themify-link-6' => 'YouTube',
  'setting-link_link_themify-link-6' => 'https://www.youtube.com/user/themifyme',
  'setting-link_ficon_themify-link-6' => 'ti-youtube',
  'setting-link_ficolor_themify-link-6' => 'rgba(255, 255, 255, 1)',
  'setting-link_type_themify-link-7' => 'font-icon',
  'setting-link_title_themify-link-7' => 'Linkedin',
  'setting-link_link_themify-link-7' => 'https://www.linkedin.com/company/themify/',
  'setting-link_ficon_themify-link-7' => 'ti-linkedin',
  'setting-link_ficolor_themify-link-7' => 'rgba(255, 255, 255, 1)',
  'setting-link_field_ids' => '{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-5":"themify-link-5","themify-link-4":"themify-link-4","themify-link-6":"themify-link-6","themify-link-7":"themify-link-7"}',
  'setting-link_field_hash' => '8',
  'setting-page_builder_is_active' => 'enable',
  'setting-page_builder_animation_appearance' => 'none',
  'setting-page_builder_animation_parallax_bg' => 'none',
  'setting-page_builder_animation_scroll_effect' => 'none',
  'setting-page_builder_animation_sticky_scroll' => 'none',
  'setting-page_builder_expiry' => '2',
  'skin' => 'profile',
  'import_images' => 'on',
);
themify_set_data( $themify_data );
$theme = get_option( 'stylesheet' );
$theme_mods = array (
  0 => false,
  'custom_css_post_id' => -1,
);
update_option( "theme_mods_{$theme}", $theme_mods );
$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "main-navigation" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
$menu = get_terms( "nav_menu", array( "slug" => "footer-menu" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["footer-nav"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );



}
themify_do_demo_import();