<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;
		$upload = wp_upload_bits( $post['post_name'] . '.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post['post_mime_type'] = $info['type'];
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$post_id = wp_insert_attachment( $post, $upload['file'] );
		wp_update_attachment_metadata( $post_id, wp_generate_attachment_metadata( $post_id, $upload['file'] ) );

		$placeholder_image = $post_id;
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if( ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 10,
  'name' => 'Cosmetic',
  'slug' => 'cosmetic',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 11,
  'name' => 'Cosmetic',
  'slug' => 'cosmetic',
  'term_group' => 0,
  'taxonomy' => 'product_tag',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 12,
  'name' => 'Anti Acne',
  'slug' => 'anti-acne',
  'term_group' => 0,
  'taxonomy' => 'product_tag',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 13,
  'name' => 'Soap',
  'slug' => 'soap',
  'term_group' => 0,
  'taxonomy' => 'product_tag',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 14,
  'name' => 'Supplement',
  'slug' => 'supplement',
  'term_group' => 0,
  'taxonomy' => 'product_tag',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 15,
  'name' => 'Aromatherapy',
  'slug' => 'aromatherapy',
  'term_group' => 0,
  'taxonomy' => 'product_tag',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 16,
  'name' => 'Shampoo',
  'slug' => 'shampoo',
  'term_group' => 0,
  'taxonomy' => 'product_tag',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 17,
  'name' => 'Shaving',
  'slug' => 'shaving',
  'term_group' => 0,
  'taxonomy' => 'product_tag',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 18,
  'name' => 'Cream',
  'slug' => 'cream',
  'term_group' => 0,
  'taxonomy' => 'product_tag',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 19,
  'name' => 'Nail Paint',
  'slug' => 'nail-paint',
  'term_group' => 0,
  'taxonomy' => 'product_tag',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 20,
  'name' => 'Waxing',
  'slug' => 'waxing',
  'term_group' => 0,
  'taxonomy' => 'product_tag',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 2,
  'name' => 'Main Navigation',
  'slug' => 'main-navigation',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 20,
  'post_date' => '2016-11-02 02:48:57',
  'post_date_gmt' => '2016-11-02 02:48:57',
  'post_content' => '[woocommerce_cart]',
  'post_title' => 'Cart',
  'post_excerpt' => '',
  'post_name' => 'cart',
  'post_modified' => '2016-11-02 02:48:57',
  'post_modified_gmt' => '2016-11-02 02:48:57',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/cart/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 21,
  'post_date' => '2016-11-02 02:48:57',
  'post_date_gmt' => '2016-11-02 02:48:57',
  'post_content' => '[woocommerce_checkout]',
  'post_title' => 'Checkout',
  'post_excerpt' => '',
  'post_name' => 'checkout',
  'post_modified' => '2016-11-02 02:48:57',
  'post_modified_gmt' => '2016-11-02 02:48:57',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/checkout/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 11,
  'post_date' => '2016-11-02 02:39:22',
  'post_date_gmt' => '2016-11-02 02:39:22',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static-->Yonge St, Toronto ON
<h2>Contact Form</h2>
<img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/title-white-divider.png" alt="title white divider" />
<form action="https://themify.me/demo/themes/ultra-spa/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Name </label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" /> <label for="contact-0--contact-email">Email </label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Send </button> </form>
<p>128 Main Street <br />Toronto, ON <br />M1E 2G6</p>

<h3>416-238-3368</h3>

<ul> <li><strong>Mon - Fri</strong> <em>11:00am - 8:00pm</em></li> <li><strong>Sat</strong> <em>9:00am - 8:00pm</em></li> <li><strong>Sun</strong> <em>9:00am - 5:00pm</em></li> </ul>
<!--/themify_builder_static-->',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact',
  'post_modified' => '2019-09-19 15:20:46',
  'post_modified_gmt' => '2019-09-19 15:20:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?page_id=11',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"622ae38\\",\\"cols\\":[{\\"element_id\\":\\"e76c27b\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"maps-pro\\",\\"element_id\\":\\"ef12583\\",\\"mod_settings\\":{\\"map_display_type\\":\\"dynamic\\",\\"w_map\\":\\"100\\",\\"unit_w\\":\\"%\\",\\"w_map_static\\":\\"500\\",\\"h_map\\":\\"645\\",\\"type_map\\":\\"ROADMAP\\",\\"style_map\\":\\"greyscale\\",\\"scrollwheel_map\\":\\"disable\\",\\"draggable_map\\":\\"enable\\",\\"disable_map_ui\\":\\"no\\",\\"zoom_map\\":\\"17\\",\\"map_center\\":\\"1 Yonge Street,\\\\nToronto, ON\\\\nCanada\\",\\"markers\\":[{\\"address\\":\\"1 Yonge Street,\\\\nToronto, ON\\\\nCanada\\",\\"title\\":\\"Yonge St, Toronto ON\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/map-pin.png\\"}],\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"w_map_unit\\":\\"%\\",\\"map_polyline\\":\\"no\\",\\"map_polyline_geodesic\\":\\"yes\\",\\"map_polyline_stroke\\":\\"2\\",\\"map_polyline_color\\":\\"#ff0000_1\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"4bc0805\\",\\"cols\\":[{\\"element_id\\":\\"5c8ef79\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"plain-text\\",\\"element_id\\":\\"991b7da\\",\\"mod_settings\\":{\\"plain_text\\":\\"<h2>Contact Form<\\\\/h2>\\",\\"font_color\\":\\"ffffff\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"9f7734c\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/title-white-divider.png\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"-2\\",\\"margin_top_unit\\":\\"em\\",\\"margin_bottom\\":\\"3\\",\\"margin_bottom_unit\\":\\"em\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"8f53caf\\",\\"mod_settings\\":{\\"layout_contact\\":\\"style1\\",\\"text_align_success_message_left\\":\\"left\\",\\"text_align_success_message_center\\":\\"center\\",\\"text_align_success_message_right\\":\\"right\\",\\"text_align_success_message_justify\\":\\"justify\\",\\"text_align_error_message_left\\":\\"left\\",\\"text_align_error_message_center\\":\\"center\\",\\"text_align_error_message_right\\":\\"right\\",\\"text_align_error_message_justify\\":\\"justify\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"field_email_active\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"field_send_align\\":\\"left\\",\\"field_sendcopy_active\\":\\"\\",\\"field_captcha_active\\":\\"\\",\\"field_subject_active\\":\\"\\",\\"field_subject_require\\":\\"\\",\\"field_email_require\\":\\"\\",\\"field_name_require\\":\\"\\",\\"contact_sent_from\\":\\"enable\\",\\"post_author\\":\\"\\",\\"send_to_admins\\":\\"true\\"}}],\\"grid_width\\":\\"55.8175\\",\\"styling\\":{\\"background_color\\":\\"82d3da_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"50\\",\\"padding_right\\":\\"50\\",\\"padding_bottom\\":\\"50\\",\\"padding_left\\":\\"50\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"cdead84\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"8ab3326\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>128 Main Street <br \\\\/>Toronto, ON <br \\\\/>M1E 2G6<\\\\/p>\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"30\\"}}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"b3f47be\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"dddddd_1.00\\",\\"divider_type\\":\\"fullwidth\\",\\"divider_width\\":\\"200\\",\\"divider_align\\":\\"left\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"a219b94\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>416-238-3368<\\\\/h3>\\",\\"font_color\\":\\"f1a4a4\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"2f26788\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"dddddd_1.00\\",\\"divider_type\\":\\"fullwidth\\",\\"divider_width\\":\\"200\\",\\"divider_align\\":\\"left\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"099b1f1\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<ul>\\\\n<li><strong>Mon - Fri<\\\\/strong> <em>11:00am - 8:00pm<\\\\/em><\\\\/li>\\\\n<li><strong>Sat<\\\\/strong> <em>9:00am - 8:00pm<\\\\/em><\\\\/li>\\\\n<li><strong>Sun<\\\\/strong> <em>9:00am - 5:00pm<\\\\/em><\\\\/li>\\\\n<\\\\/ul>\\",\\"add_css_text\\":\\"location-hours\\"}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"97f07a8\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"dddddd_1.00\\",\\"divider_type\\":\\"fullwidth\\",\\"divider_width\\":\\"200\\",\\"divider_align\\":\\"left\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"grid_width\\":\\"40.9828\\",\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_css_column\\":\\"contact-info\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\"}}}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"breakpoint_tablet_landscape\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 10,
  'post_date' => '2016-11-02 02:38:29',
  'post_date_gmt' => '2016-11-02 02:38:29',
  'post_content' => '<!--themify_builder_static--><h1>Gallery<br/>Photos</h1>
<a href="https://themify.me/demo/themes/ultra-spa/services/" rel="noopener noreferrer" target="_blank"> <img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/PeopleImages.com-ID377634-476x353.jpg" width="476" height="353" title="Lily Aromatheraphy" alt="Lily Aromatheraphy" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-spa/services/" rel="noopener noreferrer" target="_blank"> Lily Aromatheraphy </a> </h3>
<img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/massage-476x353-1-476x353.jpg" width="476" height="353" title="Massage" alt="Massage" srcset="https://themify.me/demo/themes/ultra-spa/files/2016/11/massage-476x353-1.jpg 476w, https://themify.me/demo/themes/ultra-spa/files/2016/11/massage-476x353-1-300x222.jpg 300w" sizes="(max-width: 476px) 100vw, 476px" /> <h3> Massage </h3>
<img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/PeopleImages.com-ID1167254-476x353.jpg" width="476" height="353" title="Rose Oil Theraphy" alt="Rose Oil Theraphy" /> <h3> Rose Oil Theraphy </h3>
<img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/PeopleImages.com-ID1301337-476x353.jpg" width="476" height="353" title="Hot Stone Massage" alt="Hot Stone Massage" /> <h3> Hot Stone Massage </h3>
<img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/PeopleImages.com-ID376407-4-750x556.jpg" width="750" height="556" title="Stay Fresh" alt="Stay Fresh" /> <h3> Stay Fresh </h3>
<img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/PeopleImages.com-ID377644-951x353.jpg" width="951" height="353" title="Lavender Aromatheraphy" alt="Lavender Aromatheraphy" /> <h3> Lavender Aromatheraphy </h3>
<img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/PeopleImages.com-ID1301286-476x353.jpg" width="476" height="353" title="Olive Oil " alt="Olive Oil " /> <h3> Olive Oil </h3>
<img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/PeopleImages.com-ID8214-476x353.jpg" width="476" height="353" title="Manicure and pedicure" alt="Manicure and pedicure" /> <h3> Manicure and pedicure </h3>
<h2>Instagram<br/>Our Instagram Photo</h2>
<img src="https://themify.me/demo/themes/ultra-spa-dev/files/2016/10/aromatheraphy-yellow.jpg" width="290" height="250" alt="" />
<img src="https://themify.me/demo/themes/ultra-spa-dev/files/2016/10/massage-oil.jpg" width="290" height="250" alt="" />
<img src="https://themify.me/demo/themes/ultra-spa-dev/files/2016/10/stone-massage.jpg" width="290" height="250" alt="" />
<img src="https://themify.me/demo/themes/ultra-spa-dev/files/2016/10/face-massages.jpg" width="290" height="250" alt="" />
<img src="https://themify.me/demo/themes/ultra-spa-dev/files/2016/10/body-massage.jpg" width="290" height="250" alt="" />
<img src="https://themify.me/demo/themes/ultra-spa-dev/files/2016/10/massage-facial.jpg" width="290" height="250" alt="" />
<img src="https://themify.me/demo/themes/ultra-spa-dev/files/2016/10/olive-spa.jpg" width="290" height="250" alt="" />
<img src="https://themify.me/demo/themes/ultra-spa-dev/files/2016/10/aromatheraphy-flower.jpg" width="290" height="250" alt="" />
<img src="https://themify.me/demo/themes/ultra-spa-dev/files/2016/10/waxing-1.jpg" width="290" height="250" alt="" />
<img src="https://themify.me/demo/themes/ultra-spa-dev/files/2016/10/aromatheraphy-2.jpg" width="290" height="250" alt="" />
<img src="https://themify.me/demo/themes/ultra-spa-dev/files/2016/10/massage-theraphy.jpg" width="290" height="250" alt="" />
<img src="https://themify.me/demo/themes/ultra-spa-dev/files/2016/10/after-facial.jpg" width="290" height="250" alt="" /><!--/themify_builder_static-->',
  'post_title' => 'Gallery',
  'post_excerpt' => '',
  'post_name' => 'gallery',
  'post_modified' => '2019-07-04 00:56:28',
  'post_modified_gmt' => '2019-07-04 00:56:28',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?page_id=10',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"rs00258\\",\\"cols\\":[{\\"element_id\\":\\"qwdr262\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"fh96262\\",\\"mod_settings\\":{\\"heading\\":\\"Gallery\\",\\"sub_heading\\":\\"Photos\\",\\"heading_tag\\":\\"h1\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"f4f4f4\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"margin_top_unit\\":\\"em\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border_bottom_color\\":\\"dddddd\\",\\"border_bottom_width\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"row_width\\":\\"fullwidth\\"}},{\\"element_id\\":\\"h8ba259\\",\\"cols\\":[{\\"element_id\\":\\"9b91264\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"ed0u264\\",\\"cols\\":[{\\"element_id\\":\\"erye265\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"t5kr265\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/PeopleImages.com-ID377634-476x353.jpg\\",\\"width_image\\":\\"476\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"353\\",\\"title_image\\":\\"Lily Aromatheraphy\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/services\\\\/\\",\\"param_image\\":\\"newtab\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"l8nl265\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/massage-476x353-1.jpg\\",\\"width_image\\":\\"476\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"353\\",\\"title_image\\":\\"Massage\\",\\"param_image\\":\\"lightbox\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"gp5b265\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"2syo265\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/PeopleImages.com-ID1167254-476x353.jpg\\",\\"width_image\\":\\"476\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"353\\",\\"title_image\\":\\"Rose Oil Theraphy\\",\\"param_image\\":\\"lightbox\\",\\"image_zoom_icon\\":\\"zoom\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"vxoc265\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/PeopleImages.com-ID1301337-476x353.jpg\\",\\"width_image\\":\\"476\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"353\\",\\"title_image\\":\\"Hot Stone Massage\\",\\"param_image\\":\\"lightbox\\",\\"image_zoom_icon\\":\\"zoom\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"vh6o265\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"arwj266\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/PeopleImages.com-ID376407-4-750x556.jpg\\",\\"width_image\\":\\"750\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"556\\",\\"title_image\\":\\"Stay Fresh\\",\\"param_image\\":\\"lightbox\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"gutter\\":\\"gutter-none\\"}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"-50\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_width\\":\\"fullwidth\\",\\"custom_css_row\\":\\"gallery-block\\"}},{\\"element_id\\":\\"d1ui259\\",\\"cols\\":[{\\"element_id\\":\\"ghsv266\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"s1oz266\\",\\"cols\\":[{\\"element_id\\":\\"6rdq266\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ao94266\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/PeopleImages.com-ID377644-951x353.jpg\\",\\"width_image\\":\\"951\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"353\\",\\"title_image\\":\\"Lavender Aromatheraphy\\",\\"param_image\\":\\"lightbox\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"cmx5267\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"33vm267\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/PeopleImages.com-ID1301286-476x353.jpg\\",\\"width_image\\":\\"476\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"353\\",\\"title_image\\":\\"Olive Oil \\",\\"param_image\\":\\"lightbox\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"apcp267\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"29u5267\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/PeopleImages.com-ID8214-476x353.jpg\\",\\"width_image\\":\\"476\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"353\\",\\"title_image\\":\\"Manicure and pedicure\\",\\"param_image\\":\\"lightbox\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"gutter\\":\\"gutter-none\\"}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"custom_css_row\\":\\"gallery-block\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"0nr5259\\",\\"cols\\":[{\\"element_id\\":\\"3yu7267\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"gsjy267\\",\\"mod_settings\\":{\\"heading\\":\\"Instagram\\",\\"sub_heading\\":\\"Our Instagram Photo\\",\\"heading_tag\\":\\"h2\\",\\"text_alignment\\":\\"themify-text-center\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"7a9q259\\",\\"cols\\":[{\\"element_id\\":\\"oy7y268\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"7zi5268\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa-dev\\\\/files\\\\/2016\\\\/10\\\\/aromatheraphy-yellow.jpg\\",\\"width_image\\":\\"290\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"0kuq268\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa-dev\\\\/files\\\\/2016\\\\/10\\\\/massage-oil.jpg\\",\\"width_image\\":\\"290\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"gsrk268\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa-dev\\\\/files\\\\/2016\\\\/10\\\\/stone-massage.jpg\\",\\"width_image\\":\\"290\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"t6im268\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"a90d268\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa-dev\\\\/files\\\\/2016\\\\/10\\\\/face-massages.jpg\\",\\"width_image\\":\\"290\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"2t1e268\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa-dev\\\\/files\\\\/2016\\\\/10\\\\/body-massage.jpg\\",\\"width_image\\":\\"290\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"5s01268\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa-dev\\\\/files\\\\/2016\\\\/10\\\\/massage-facial.jpg\\",\\"width_image\\":\\"290\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"jq3k269\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"r54y269\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa-dev\\\\/files\\\\/2016\\\\/10\\\\/olive-spa.jpg\\",\\"width_image\\":\\"290\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8doq269\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa-dev\\\\/files\\\\/2016\\\\/10\\\\/aromatheraphy-flower.jpg\\",\\"width_image\\":\\"290\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"fz14269\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa-dev\\\\/files\\\\/2016\\\\/10\\\\/waxing-1.jpg\\",\\"width_image\\":\\"290\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"qqj7269\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"9e2l269\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa-dev\\\\/files\\\\/2016\\\\/10\\\\/aromatheraphy-2.jpg\\",\\"width_image\\":\\"290\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"rf44269\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa-dev\\\\/files\\\\/2016\\\\/10\\\\/massage-theraphy.jpg\\",\\"width_image\\":\\"290\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"eshq269\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa-dev\\\\/files\\\\/2016\\\\/10\\\\/after-facial.jpg\\",\\"width_image\\":\\"290\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6,
  'post_date' => '2016-11-02 02:37:31',
  'post_date_gmt' => '2016-11-02 02:37:31',
  'post_content' => '<!--themify_builder_static--><h1>Ultra Spa</h1><h4>The best rated spa in Toronto</h4>
<h3>416-366 2886</h3>
<ul> <li><strong>Mon - Fri</strong> <em>11:00am - 8:00pm</em></li> <li><strong>Sat</strong> <em>9:00am - 8:00pm</em></li> <li><strong>Sun</strong> <em>9:00am - 5:00pm</em></li> </ul>
<h2>Services<br/></h2>
<img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/nails-400x340.jpg" width="400" height="340" alt="Nails" />
<h3 style="text-align: center;">Nails</h3><p style="text-align: center;">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud.</p>
<img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/facial-360x480.jpg" width="360" height="480" alt="Facial" srcset="https://themify.me/demo/themes/ultra-spa/files/2016/11/facial.jpg 360w, https://themify.me/demo/themes/ultra-spa/files/2016/11/facial-225x300.jpg 225w" sizes="(max-width: 360px) 100vw, 360px" />
<h3>Facial</h3> <p>With endless modalities and customization, we have thousands of spa and wellness location for your next massage</p> <ul> <li> Lorem ipsum dolor sit amet.</li> <li> Duis aute irure dolor.</li> <li> Nemo enim ipsam voluptatem.</li> <li> Temporibus autem quibusdam.</li> </ul>
<img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/massage-560x340.jpg" width="560" height="340" alt="massage" srcset="https://themify.me/demo/themes/ultra-spa/files/2016/11/massage.jpg 560w, https://themify.me/demo/themes/ultra-spa/files/2016/11/massage-300x182.jpg 300w" sizes="(max-width: 560px) 100vw, 560px" />
<h3 style="text-align: right;">Massage</h3><p style="text-align: right;">Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda.</p>
<img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/waxing-360x240.jpg" width="360" height="240" alt="waxing" srcset="https://themify.me/demo/themes/ultra-spa/files/2016/11/waxing.jpg 360w, https://themify.me/demo/themes/ultra-spa/files/2016/11/waxing-300x200.jpg 300w" sizes="(max-width: 360px) 100vw, 360px" />
<h3>Waxing</h3><p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet.</p>
<a href="http://themify.me/" > View service & pricing </a>
<h2 style="text-align: right;">Promotions</h2> <p style="text-align: right;">Subscribe our newsletter and receive monthly promotions &amp; new products.</p>
<h2>Get 15% discount</h2><p>[mc4wp_form id="130"]</p>
<img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/title-white-divider.png" alt="title white divider" />
<h2>This Month Special</h2>
$24 <p>Beauty</p> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
$15 <p>Massage</p> Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.
$15 <p>Yoga</p> Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.
<h5 style="text-align: center;">Visit our store &amp; present your code:<br />WEBPROMO</h5>
<h2>Our Shop<br/></h2>
<figure> <a href="https://themify.me/demo/themes/ultra-spa/product/cosmetic-set/"><img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/pink-cosmetic-258x243.jpg" width="258" height="243" alt="pink-cosmetic" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-spa/product/cosmetic-set/" title="Cosmetic Set">Cosmetic Set</a></h3> 
 &#36;70.00 <p><a href="/demo/themes/ultra-spa/wp-admin/admin-ajax.php?add-to-cart=87" data-quantity="1" data-product_id="87" data-product_sku="" aria-label="Add &ldquo;Cosmetic Set&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-spa/wp-admin/post.php?post=87&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-spa/product/anti-acne-cream-package/"><img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/anti-acne-cream-package-258x243.jpg" width="258" height="243" alt="anti-acne-cream-package" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-spa/product/anti-acne-cream-package/" title="Anti Acne Cream Package">Anti Acne Cream Package</a></h3> 
 &#36;150.00 <p><a href="/demo/themes/ultra-spa/wp-admin/admin-ajax.php?add-to-cart=85" data-quantity="1" data-product_id="85" data-product_sku="" aria-label="Add &ldquo;Anti Acne Cream Package&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-spa/wp-admin/post.php?post=85&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-spa/product/bath-salt/"><img src="https://themify.me/demo/themes/ultra-spa/files/2016/10/olive-soap-258x243.jpg" width="258" height="243" alt="olive-soap" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-spa/product/bath-salt/" title="Bath Salt">Bath Salt</a></h3> 
 &#36;25.00 <p><a href="/demo/themes/ultra-spa/wp-admin/admin-ajax.php?add-to-cart=49" data-quantity="1" data-product_id="49" data-product_sku="" aria-label="Add &ldquo;Bath Salt&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-spa/wp-admin/post.php?post=49&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-spa/product/skin-supplement/"><img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/skin-suplement-258x243.jpg" width="258" height="243" alt="skin-suplement" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-spa/product/skin-supplement/" title="Skin Supplement">Skin Supplement</a></h3> 
 &#36;25.00 <p><a href="/demo/themes/ultra-spa/wp-admin/admin-ajax.php?add-to-cart=81" data-quantity="1" data-product_id="81" data-product_sku="" aria-label="Add &ldquo;Skin Supplement&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-spa/wp-admin/post.php?post=81&#038;action=edit">Edit</a>]
<a href="https://themify.me/demo/themes/ultra-spa/shop" > Shop More </a><!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2019-07-19 18:38:29',
  'post_modified_gmt' => '2019-07-19 18:38:29',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?page_id=6',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'header_design' => 'header-horizontal',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'transparent',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"50bbc1e\\",\\"cols\\":[{\\"element_id\\":\\"3dda76d\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"99567cd\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Ultra Spa<\\\\/h1><h4>The best rated spa in Toronto<\\\\/h4>\\",\\"font_size\\":\\"1.1\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_size_h1\\":\\"4.75\\",\\"font_size_h1_unit\\":\\"em\\",\\"line_height_h1\\":\\"72\\",\\"font_size_h4\\":\\"1.5\\",\\"font_size_h4_unit\\":\\"em\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"008d8a5\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>416-366 2886<\\\\/h3>\\",\\"font_color\\":\\"f1a4a4_1.00\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"e670210\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<ul>\\\\n<li><strong>Mon - Fri<\\\\/strong> <em>11:00am - 8:00pm<\\\\/em><\\\\/li>\\\\n<li><strong>Sat<\\\\/strong> <em>9:00am - 8:00pm<\\\\/em><\\\\/li>\\\\n<li><strong>Sun<\\\\/strong> <em>9:00am - 5:00pm<\\\\/em><\\\\/li>\\\\n<\\\\/ul>\\",\\"add_css_text\\":\\"location-hours\\",\\"stick_at_position\\":\\"top\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_css_column\\":\\"spa-info\\"}},{\\"element_id\\":\\"29d8438\\",\\"grid_class\\":\\"col4-2\\"}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/ultra-spa-header-2-1024x716.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-bottom\\",\\"background_color\\":\\"eefeff\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_tablet_landscape\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/bg-header-spa-mobile-4.jpg\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/bg-header-spa-mobile-4.jpg\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/bg-header-spa-mobile-small.jpg\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"25\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"50\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"1d18bca\\",\\"cols\\":[{\\"element_id\\":\\"3166b7d\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"2e12aa6\\",\\"mod_settings\\":{\\"heading\\":\\"Services\\",\\"heading_tag\\":\\"h2\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"element_id\\":\\"f48ee40\\",\\"cols\\":[{\\"element_id\\":\\"51c51ee\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"1ce2387\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/nails-400x340.jpg\\",\\"width_image\\":\\"400\\",\\"height_image\\":\\"340\\",\\"param_image\\":\\"regular\\",\\"alt_image\\":\\"Nails\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"fb2a4a1\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Nails<\\\\/h3><p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud.<\\\\/p>\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"60\\",\\"margin_bottom\\":\\"30\\"}}}]},{\\"element_id\\":\\"34e77ca\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"acfa72d\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/facial.jpg\\",\\"width_image\\":\\"360\\",\\"height_image\\":\\"480\\",\\"param_image\\":\\"regular\\",\\"alt_image\\":\\"Facial\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"f0de90f\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"1164f2a\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Facial<\\\\/h3>\\\\n<p>With endless modalities and customization, we have thousands of spa and wellness location for your next massage<\\\\/p>\\\\n<ul>\\\\n<li><i class=\\\\\\\\\\\\\\"fa fa-circle\\\\\\\\\\\\\\"><\\\\/i> Lorem ipsum dolor sit amet.<\\\\/li>\\\\n<li><i class=\\\\\\\\\\\\\\"fa fa-circle\\\\\\\\\\\\\\"><\\\\/i> Duis aute irure dolor.<\\\\/li>\\\\n<li><i class=\\\\\\\\\\\\\\"fa fa-circle\\\\\\\\\\\\\\"><\\\\/i> Nemo enim ipsam voluptatem.<\\\\/li>\\\\n<li><i class=\\\\\\\\\\\\\\"fa fa-circle\\\\\\\\\\\\\\"><\\\\/i> Temporibus autem quibusdam.<\\\\/li>\\\\n<\\\\/ul>\\\\n\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"50\\",\\"margin_bottom\\":\\"30\\"}}}]}]}]}],\\"styling\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/pink-flower-1.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_position\\":\\"left-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/pink-flower-small-mobile.jpg\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"16d8327\\",\\"cols\\":[{\\"element_id\\":\\"e3b0347\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"4240289\\",\\"cols\\":[{\\"element_id\\":\\"4106353\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"3a03d88\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/massage.jpg\\",\\"width_image\\":\\"560\\",\\"height_image\\":\\"340\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"861f650\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3 style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">Massage<\\\\/h3><p style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda.<\\\\/p>\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"50\\",\\"margin_bottom\\":\\"30\\"}}}]},{\\"element_id\\":\\"7594d3a\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"7feded2\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/waxing.jpg\\",\\"width_image\\":\\"360\\",\\"height_image\\":\\"240\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"c45ad29\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Waxing<\\\\/h3><p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet.<\\\\/p>\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"50\\",\\"margin_bottom\\":\\"40\\"}}}]}]},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"0837088\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"30\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"link_color\\":\\"ffffff\\",\\"padding_link_top\\":\\"5\\",\\"padding_link_top_unit\\":\\"%\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"View service & pricing\\",\\"link\\":\\"http:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"pink\\",\\"icon_alignment\\":\\"left\\"}]}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/white-flower.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_tablet_landscape\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"}}},{\\"element_id\\":\\"49bd0a6\\",\\"cols\\":[{\\"element_id\\":\\"830f4a8\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"0ee4d6d\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">Promotions<\\\\/h2>\\\\n<p style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">Subscribe our newsletter and receive monthly promotions &amp; new products.<\\\\/p>\\\\n\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"grid_width\\":\\"33.1412\\",\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"border_right_color\\":\\"47556c_1.00\\",\\"border_right_width\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"3892a65\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"4ce933b\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Get 15% discount<\\\\/h2><p>[mc4wp_form id=\\\\\\\\\\\\\\"130\\\\\\\\\\\\\\"]<\\\\/p>\\",\\"add_css_text\\":\\"news-letter\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"grid_width\\":\\"63.6598\\",\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"styling\\":{\\"custom_css_row\\":\\"newsletter-block\\",\\"background_color\\":\\"273244_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"d361e9b\\",\\"cols\\":[{\\"element_id\\":\\"2f56d84\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"7b78d0c\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/title-white-divider.png\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"10\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"plain-text\\",\\"element_id\\":\\"0eabde8\\",\\"mod_settings\\":{\\"plain_text\\":\\"<h2>This Month Special<\\\\/h2>\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"0\\",\\"margin_right\\":\\"0\\",\\"margin_bottom\\":\\"-10\\",\\"margin_left\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"element_id\\":\\"1492b30\\",\\"cols\\":[{\\"element_id\\":\\"5429a1a\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"pricing-table\\",\\"element_id\\":\\"9716ac8\\",\\"mod_settings\\":{\\"mod_color_pricing_table\\":\\"transparent\\",\\"mod_price_pricing_table\\":\\"$24\\",\\"mod_description_pricing_table\\":\\"Beauty\\",\\"mod_feature_list_pricing_table\\":\\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\\",\\"border_right_color\\":\\"a1e8ee_1.00\\",\\"border_right_width\\":\\"1\\",\\"mod_title_font_color\\":\\"ffffff_1.00\\",\\"mod_text_align_title_left\\":\\"left\\",\\"mod_text_align_title_center\\":\\"center\\",\\"mod_text_align_title_right\\":\\"right\\",\\"mod_text_align_title_justify\\":\\"justify\\",\\"mod_title_background_color\\":\\"82d3da_1.00\\",\\"mod_feature_font_color\\":\\"ffffff_1.00\\",\\"mod_text_align_content_left\\":\\"left\\",\\"mod_text_align_content_center\\":\\"center\\",\\"mod_text_align_content_right\\":\\"right\\",\\"mod_text_align_content_justify\\":\\"justify\\",\\"mod_feature_bg_color\\":\\"82d3da_1.00\\",\\"mod_text_align_button_left\\":\\"left\\",\\"mod_text_align_button_center\\":\\"center\\",\\"mod_text_align_button_right\\":\\"right\\",\\"mod_text_align_button_justify\\":\\"justify\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"5318ea1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"pricing-table\\",\\"element_id\\":\\"5e6165c\\",\\"mod_settings\\":{\\"mod_color_pricing_table\\":\\"transparent\\",\\"mod_price_pricing_table\\":\\"$15\\",\\"mod_description_pricing_table\\":\\"Massage\\",\\"mod_feature_list_pricing_table\\":\\"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.\\",\\"border_right_color\\":\\"a1e8ee_1.00\\",\\"border_right_width\\":\\"1\\",\\"mod_title_font_color\\":\\"ffffff_1.00\\",\\"mod_text_align_title_left\\":\\"left\\",\\"mod_text_align_title_center\\":\\"center\\",\\"mod_text_align_title_right\\":\\"right\\",\\"mod_text_align_title_justify\\":\\"justify\\",\\"mod_title_background_color\\":\\"82d3da_1.00\\",\\"mod_feature_font_color\\":\\"ffffff_1.00\\",\\"mod_text_align_content_left\\":\\"left\\",\\"mod_text_align_content_center\\":\\"center\\",\\"mod_text_align_content_right\\":\\"right\\",\\"mod_text_align_content_justify\\":\\"justify\\",\\"mod_feature_bg_color\\":\\"82d3da_1.00\\",\\"mod_text_align_button_left\\":\\"left\\",\\"mod_text_align_button_center\\":\\"center\\",\\"mod_text_align_button_right\\":\\"right\\",\\"mod_text_align_button_justify\\":\\"justify\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\"}},{\\"element_id\\":\\"d879b85\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"pricing-table\\",\\"element_id\\":\\"c499176\\",\\"mod_settings\\":{\\"mod_color_pricing_table\\":\\"transparent\\",\\"mod_price_pricing_table\\":\\"$15\\",\\"mod_description_pricing_table\\":\\"Yoga\\",\\"mod_feature_list_pricing_table\\":\\"Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.\\",\\"mod_title_font_color\\":\\"ffffff_1.00\\",\\"mod_text_align_title_left\\":\\"left\\",\\"mod_text_align_title_center\\":\\"center\\",\\"mod_text_align_title_right\\":\\"right\\",\\"mod_text_align_title_justify\\":\\"justify\\",\\"mod_title_background_color\\":\\"82d3da_1.00\\",\\"mod_feature_font_color\\":\\"ffffff_1.00\\",\\"mod_text_align_content_left\\":\\"left\\",\\"mod_text_align_content_center\\":\\"center\\",\\"mod_text_align_content_right\\":\\"right\\",\\"mod_text_align_content_justify\\":\\"justify\\",\\"mod_feature_bg_color\\":\\"82d3da_1.00\\",\\"mod_text_align_button_left\\":\\"left\\",\\"mod_text_align_button_center\\":\\"center\\",\\"mod_text_align_button_right\\":\\"right\\",\\"mod_text_align_button_justify\\":\\"justify\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"gutter\\":\\"gutter-none\\"},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"677906e\\",\\"mod_settings\\":{\\"content_text\\":\\"<h5 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Visit our store &amp; present your code:<br \\\\/>WEBPROMO<\\\\/h5>\\",\\"font_color\\":\\"fff\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"background_color\\":\\"82d3da_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"50\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"50\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"margin-top_opp_top\\":\\"\\",\\"margin-top_unit\\":\\"%\\",\\"margin-top\\":\\"-8\\",\\"padding_opp_left\\":\\"\\",\\"padding_opp_top\\":\\"\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"-150\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"999d0e1\\",\\"cols\\":[{\\"element_id\\":\\"2789eb0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"0f00299\\",\\"mod_settings\\":{\\"heading\\":\\"Our Shop\\",\\"heading_tag\\":\\"h2\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"mod_name\\":\\"products\\",\\"element_id\\":\\"cbb1f43\\",\\"mod_settings\\":{\\"query_products\\":\\"all\\",\\"hide_child_products\\":\\"no\\",\\"hide_free_products\\":\\"no\\",\\"post_per_page_products\\":\\"4\\",\\"orderby_products\\":\\"date\\",\\"order_products\\":\\"desc\\",\\"template_products\\":\\"list\\",\\"layout_products\\":\\"grid4\\",\\"layout_slider\\":\\"slider-default\\",\\"visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"4\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"description_products\\":\\"none\\",\\"hide_feat_img_products\\":\\"no\\",\\"img_width_products\\":\\"258\\",\\"img_height_products\\":\\"243\\",\\"unlink_feat_img_products\\":\\"no\\",\\"hide_post_title_products\\":\\"no\\",\\"unlink_post_title_products\\":\\"no\\",\\"hide_price_products\\":\\"no\\",\\"hide_add_to_cart_products\\":\\"no\\",\\"hide_rating_products\\":\\"no\\",\\"hide_sales_badge\\":\\"no\\",\\"hide_page_nav_products\\":\\"yes\\",\\"text_align\\":\\"center\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"addb95f\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"outline\\",\\"content_button\\":[{\\"label\\":\\"Shop More\\",\\"link\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/shop\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"pink\\"}],\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"padding_top_link\\":\\"20\\",\\"padding_right_link\\":\\"40\\",\\"padding_bottom_link\\":\\"20\\",\\"padding_left_link\\":\\"40\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 22,
  'post_date' => '2016-11-02 02:48:57',
  'post_date_gmt' => '2016-11-02 02:48:57',
  'post_content' => '[woocommerce_my_account]',
  'post_title' => 'My Account',
  'post_excerpt' => '',
  'post_name' => 'my-account',
  'post_modified' => '2016-11-02 02:48:57',
  'post_modified_gmt' => '2016-11-02 02:48:57',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/my-account/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 8,
  'post_date' => '2016-11-02 02:38:09',
  'post_date_gmt' => '2016-11-02 02:38:09',
  'post_content' => '<!--themify_builder_static--><h1>Services<br/>What we offer</h1>
<img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/nails-560x325.jpg" width="560" height="325" title="Nails" alt="Nails" srcset="https://themify.me/demo/themes/ultra-spa/files/2016/11/nails.jpg 560w, https://themify.me/demo/themes/ultra-spa/files/2016/11/nails-300x174.jpg 300w" sizes="(max-width: 560px) 100vw, 560px" /> <h3> Nails </h3>
<h4>Nail Manicure (Per packages)</h4> 
 $25 <br />
<h4>Hand Massage (Per packages)</h4> 
 $35 <br />
<h4>Nail Coloring (Per color)</h4> 
 $25 <br />
<h4>Nail Theraphy (50Min)</h4> 
 $30 <br />
<h4>Nail Painting (40Min)</h4> 
 $15 <br />
<h4>Customized Spa Manicure (40Min)</h4> 
 $25 <br />
<img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/massage-service-560x325.jpg" width="560" height="325" title="Massage" alt="Massage" srcset="https://themify.me/demo/themes/ultra-spa/files/2016/11/massage-service.jpg 560w, https://themify.me/demo/themes/ultra-spa/files/2016/11/massage-service-300x174.jpg 300w" sizes="(max-width: 560px) 100vw, 560px" /> <h3> Massage </h3>
<h4>Full Body Massage (55 Min)</h4> 
 $25 <br />
<h4>Hot Stone Massage (55 Min)</h4> 
 $25 <br />
<h4>Deep Tissue Massage (Per area)</h4> 
 $25 <br />
<h4>Aromatherapy Massage (50 Min)</h4> 
 $25 <br />
<img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/facial-service-560x325.jpg" width="560" height="325" title="Facial" alt="Facial" srcset="https://themify.me/demo/themes/ultra-spa/files/2016/11/facial-service.jpg 560w, https://themify.me/demo/themes/ultra-spa/files/2016/11/facial-service-300x174.jpg 300w" sizes="(max-width: 560px) 100vw, 560px" /> <h3> Facial </h3>
<h4>Face Scrub (45 Min)</h4> 
 $25 <br />
<h4>Face Massage (30 Min)</h4> 
 $35 <br />
<h4>Facial (Per packages)</h4> 
 $25 <br />
<img src="https://themify.me/demo/themes/ultra-spa/files/2016/11/waxing-service-560x325.jpg" width="560" height="325" title="Waxing" alt="Waxing" srcset="https://themify.me/demo/themes/ultra-spa/files/2016/11/waxing-service.jpg 560w, https://themify.me/demo/themes/ultra-spa/files/2016/11/waxing-service-300x174.jpg 300w" sizes="(max-width: 560px) 100vw, 560px" /> <h3> Waxing </h3>
<h4>Laser Wax (Per packages)</h4> 
 $155 <br />
<h4>Avocado wax (Per area)</h4> 
 $25 <br />
<h4>Apricott Wax (Per area)</h4> 
 $35 <br />
<h4>Natural Waxing (Per packages)</h4> 
 $55 <br />
<h2>Call To Book Your Appoinment <br/>416 - 228 - 3368</h2>
Bay st, Toronto, ON<!--/themify_builder_static-->',
  'post_title' => 'Services',
  'post_excerpt' => '',
  'post_name' => 'services',
  'post_modified' => '2019-07-19 18:28:04',
  'post_modified_gmt' => '2019-07-19 18:28:04',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?page_id=8',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"wfj2849\\",\\"cols\\":[{\\"element_id\\":\\"szfg854\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"71kd856\\",\\"mod_settings\\":{\\"heading\\":\\"Services\\",\\"sub_heading\\":\\"What we offer\\",\\"heading_tag\\":\\"h1\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_color\\":\\"f4f4f4_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_bottom_color\\":\\"dddddd_1.00\\",\\"border_bottom_width\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"ejei849\\",\\"cols\\":[{\\"element_id\\":\\"yj2j858\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"vpdz858\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/nails.jpg\\",\\"width_image\\":\\"560\\",\\"height_image\\":\\"325\\",\\"title_image\\":\\"Nails\\",\\"param_image\\":\\"regular\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_size_title\\":\\"2.5\\",\\"font_size_title_unit\\":\\"em\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"ncr2858\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-top\\",\\"title_service_menu\\":\\"Nail Manicure (Per packages)\\",\\"price_service_menu\\":\\"$25\\",\\"link_options\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"6\\",\\"margin_top_unit\\":\\"%\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"lb5p859\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-top\\",\\"title_service_menu\\":\\"Hand Massage (Per packages)\\",\\"price_service_menu\\":\\"$35\\",\\"link_options\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"zxfq859\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-top\\",\\"title_service_menu\\":\\"Nail Coloring (Per color)\\",\\"price_service_menu\\":\\"$25\\",\\"link_options\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"80r2859\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-top\\",\\"title_service_menu\\":\\"Nail Theraphy (50Min)\\",\\"price_service_menu\\":\\"$30\\",\\"link_options\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"f35n859\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-top\\",\\"title_service_menu\\":\\"Nail Painting (40Min)\\",\\"price_service_menu\\":\\"$15\\",\\"link_options\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"c3i5859\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-top\\",\\"title_service_menu\\":\\"Customized Spa Manicure (40Min)\\",\\"price_service_menu\\":\\"$25\\",\\"link_options\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"9jgq860\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/massage-service.jpg\\",\\"width_image\\":\\"560\\",\\"height_image\\":\\"325\\",\\"title_image\\":\\"Massage\\",\\"param_image\\":\\"regular\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_size_title\\":\\"2.5\\",\\"font_size_title_unit\\":\\"em\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"p86x860\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-top\\",\\"title_service_menu\\":\\"Full Body Massage (55 Min)\\",\\"price_service_menu\\":\\"$25\\",\\"link_options\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"6\\",\\"margin_top_unit\\":\\"%\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"6br8860\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-top\\",\\"title_service_menu\\":\\"Hot Stone Massage (55 Min)\\",\\"price_service_menu\\":\\"$25\\",\\"link_options\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"89q7860\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-top\\",\\"title_service_menu\\":\\"Deep Tissue Massage (Per area)\\",\\"price_service_menu\\":\\"$25\\",\\"link_options\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"5kms860\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-top\\",\\"title_service_menu\\":\\"Aromatherapy Massage (50 Min)\\",\\"price_service_menu\\":\\"$25\\",\\"link_options\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"jvh9861\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"l0jf861\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/facial-service.jpg\\",\\"width_image\\":\\"560\\",\\"height_image\\":\\"325\\",\\"title_image\\":\\"Facial\\",\\"param_image\\":\\"regular\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_size_title\\":\\"2.5\\",\\"font_size_title_unit\\":\\"em\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"j865861\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-top\\",\\"title_service_menu\\":\\"Face Scrub (45 Min)\\",\\"price_service_menu\\":\\"$25\\",\\"link_options\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"6\\",\\"margin_top_unit\\":\\"%\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"rxps861\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-top\\",\\"title_service_menu\\":\\"Face Massage (30 Min)\\",\\"price_service_menu\\":\\"$35\\",\\"link_options\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"6ala861\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-top\\",\\"title_service_menu\\":\\"Facial (Per packages)\\",\\"price_service_menu\\":\\"$25\\",\\"link_options\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"4z7f862\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/waxing-service.jpg\\",\\"width_image\\":\\"560\\",\\"height_image\\":\\"325\\",\\"title_image\\":\\"Waxing\\",\\"param_image\\":\\"regular\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_size_title\\":\\"2.5\\",\\"font_size_title_unit\\":\\"em\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"56fv862\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-top\\",\\"title_service_menu\\":\\"Laser Wax (Per packages)\\",\\"price_service_menu\\":\\"$155\\",\\"link_options\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"6\\",\\"margin_top_unit\\":\\"%\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"sq54862\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-top\\",\\"title_service_menu\\":\\"Avocado wax (Per area)\\",\\"price_service_menu\\":\\"$25\\",\\"link_options\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"v10b862\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-top\\",\\"title_service_menu\\":\\"Apricott Wax (Per area)\\",\\"price_service_menu\\":\\"$35\\",\\"link_options\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"qndy862\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-top\\",\\"title_service_menu\\":\\"Natural Waxing (Per packages)\\",\\"price_service_menu\\":\\"$55\\",\\"link_options\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"custom_css_row\\":\\"service-block\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"0hv8849\\",\\"cols\\":[{\\"element_id\\":\\"qr8t863\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"mk59863\\",\\"mod_settings\\":{\\"heading\\":\\"Call To Book Your Appoinment \\",\\"sub_heading\\":\\"416 - 228 - 3368\\",\\"heading_tag\\":\\"h2\\",\\"css_class\\":\\"white-heading\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_color\\":\\"ffffff_1.00\\",\\"font_size\\":\\"36\\",\\"font_color_subheading\\":\\"ffffff_1.00\\",\\"font_size_subheading\\":\\"36\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}}]}],\\"styling\\":{\\"background_color\\":\\"273244_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"4k3g849\\",\\"cols\\":[{\\"element_id\\":\\"semx864\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"maps-pro\\",\\"element_id\\":\\"7o8b864\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"map_display_type\\":\\"dynamic\\",\\"w_map\\":\\"100\\",\\"unit_w\\":\\"%\\",\\"w_map_static\\":\\"500\\",\\"h_map\\":\\"500\\",\\"type_map\\":\\"ROADMAP\\",\\"style_map\\":\\"greyscale\\",\\"scrollwheel_map\\":\\"disable\\",\\"draggable_map\\":\\"enable\\",\\"disable_map_ui\\":\\"no\\",\\"zoom_map\\":\\"18\\",\\"map_center\\":\\"1 Yonge Street,\\\\nToronto, ON\\\\nCanada\\",\\"markers\\":[{\\"address\\":\\"1 Yonge Street,\\\\nToronto, ON\\\\nCanada\\",\\"latlng\\":\\"43.6429251,-79.3741862\\",\\"title\\":\\"Bay st, Toronto, ON\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-spa\\\\/files\\\\/2016\\\\/11\\\\/map-pin.png\\"}],\\"w_map_unit\\":\\"%\\",\\"map_polyline\\":\\"no\\",\\"map_link\\":\\"\\",\\"margin_opp_left\\":\\"\\",\\"margin_opp_top\\":\\"\\",\\"margin_top\\":\\"-16.5\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_tablet_landscape\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"-80\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"-50\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"-50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 19,
  'post_date' => '2016-11-02 02:48:57',
  'post_date_gmt' => '2016-11-02 02:48:57',
  'post_content' => '',
  'post_title' => 'Shop',
  'post_excerpt' => '',
  'post_name' => 'shop',
  'post_modified' => '2016-11-09 03:09:51',
  'post_modified_gmt' => '2016-11-09 03:09:51',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/shop/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"u5fa721\\"}],\\"styling\\":[],\\"element_id\\":\\"h6e7991\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 87,
  'post_date' => '2016-11-01 16:20:05',
  'post_date_gmt' => '2016-11-01 16:20:05',
  'post_content' => '<div>

Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil.

</div>',
  'post_title' => 'Cosmetic Set',
  'post_excerpt' => 'Similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum.',
  'post_name' => 'cosmetic-set',
  'post_modified' => '2016-11-07 06:28:12',
  'post_modified_gmt' => '2016-11-07 06:28:12',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=87',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500092:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"sbj8190\\"}],\\"styling\\":[],\\"element_id\\":\\"eu4b802\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '88',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/pink-cosmetic.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '70',
    '_price' => '70',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'cosmetic',
    'product_tag' => 'cosmetic',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/pink-cosmetic.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 85,
  'post_date' => '2016-10-26 16:03:14',
  'post_date_gmt' => '2016-10-26 16:03:14',
  'post_content' => '<div>

Adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.

</div>',
  'post_title' => 'Anti Acne Cream Package',
  'post_excerpt' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.',
  'post_name' => 'anti-acne-cream-package',
  'post_modified' => '2016-11-07 06:28:20',
  'post_modified_gmt' => '2016-11-07 06:28:20',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=85',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500100:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"iwhn000\\"}],\\"styling\\":[],\\"element_id\\":\\"li04300\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '86',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/anti-acne-cream-package.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '150',
    '_price' => '150',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'anti-acne',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/anti-acne-cream-package.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 49,
  'post_date' => '2016-10-23 16:22:33',
  'post_date_gmt' => '2016-10-23 16:22:33',
  'post_content' => '<div>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus.

</div>',
  'post_title' => 'Bath Salt',
  'post_excerpt' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.',
  'post_name' => 'bath-salt',
  'post_modified' => '2016-11-07 06:28:29',
  'post_modified_gmt' => '2016-11-07 06:28:29',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=49',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500109:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"18a6022\\"}],\\"styling\\":[],\\"element_id\\":\\"tqxs133\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '25',
    '_price' => '25',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_thumbnail_id' => '52',
    '_wc_review_count' => '0',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/10/olive-soap.jpg',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'soap',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/10/olive-soap.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 81,
  'post_date' => '2016-10-22 15:44:37',
  'post_date_gmt' => '2016-10-22 15:44:37',
  'post_content' => '<div>

Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.

</div>',
  'post_title' => 'Skin Supplement',
  'post_excerpt' => 'Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.',
  'post_name' => 'skin-supplement',
  'post_modified' => '2019-09-26 14:46:03',
  'post_modified_gmt' => '2019-09-26 14:46:03',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=81',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500120:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"mgch764\\"}],\\"styling\\":[],\\"element_id\\":\\"6f72889\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '82',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/skin-suplement.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '25',
    '_price' => '25',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '3.6.5',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_tax_status' => 'taxable',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'supplement',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/skin-suplement.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 70,
  'post_date' => '2016-10-17 08:04:35',
  'post_date_gmt' => '2016-10-17 08:04:35',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.',
  'post_title' => 'Aromatherapy Essence',
  'post_excerpt' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_name' => 'aromatherapy-essence',
  'post_modified' => '2016-11-07 06:28:54',
  'post_modified_gmt' => '2016-11-07 06:28:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=70',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500134:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"zi3f552\\"}],\\"styling\\":[],\\"element_id\\":\\"fp8j024\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '71',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/aromatheraphy-oil.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '20',
    '_price' => '20',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'aromatherapy',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/aromatheraphy-oil.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 47,
  'post_date' => '2016-10-16 16:20:26',
  'post_date_gmt' => '2016-10-16 16:20:26',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'Flava Shampoo',
  'post_excerpt' => '<div>

Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.

</div>',
  'post_name' => 'flava-shampoo',
  'post_modified' => '2016-11-07 06:29:02',
  'post_modified_gmt' => '2016-11-07 06:29:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=47',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500142:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"hym6020\\"}],\\"styling\\":[],\\"element_id\\":\\"diel042\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '18',
    '_price' => '18',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_thumbnail_id' => '54',
    '_wc_review_count' => '0',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/10/flava-shampoo-1.jpg',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'shampoo',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/10/flava-shampoo-1.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 44,
  'post_date' => '2016-10-15 16:12:17',
  'post_date_gmt' => '2016-10-15 16:12:17',
  'post_content' => '<div>

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

</div>',
  'post_title' => 'Shaving Foam',
  'post_excerpt' => 'Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_name' => 'shaving-foam',
  'post_modified' => '2016-11-07 06:29:09',
  'post_modified_gmt' => '2016-11-07 06:29:09',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=44',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1557183429:2',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"5ycn492\\"}],\\"styling\\":[],\\"element_id\\":\\"oply308\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '35',
    '_price' => '35',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_thumbnail_id' => '56',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/10/shave-tube.jpg',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'shaving',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/10/shave-tube.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 83,
  'post_date' => '2016-10-14 15:48:16',
  'post_date_gmt' => '2016-10-14 15:48:16',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam.',
  'post_title' => 'Aloe Vera Cream',
  'post_excerpt' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit.',
  'post_name' => 'aloe-vera-cream',
  'post_modified' => '2016-11-07 06:29:17',
  'post_modified_gmt' => '2016-11-07 06:29:17',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=83',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1557178359:90',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"opqt002\\"}],\\"styling\\":[],\\"element_id\\":\\"c6my510\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '84',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/alole-vera.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '20',
    '_price' => '20',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'cream',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/alole-vera.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 42,
  'post_date' => '2016-10-14 15:42:21',
  'post_date_gmt' => '2016-10-14 15:42:21',
  'post_content' => '<div>

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.

</div>',
  'post_title' => 'Kannel N6',
  'post_excerpt' => 'Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.',
  'post_name' => 'kannel-n6',
  'post_modified' => '2016-11-07 06:30:03',
  'post_modified_gmt' => '2016-11-07 06:30:03',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=42',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500203:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"yv3u805\\"}],\\"styling\\":[],\\"element_id\\":\\"ygnu015\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '45',
    '_sale_price' => '35',
    '_price' => '35',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_thumbnail_id' => '55',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/10/kennel-n6.jpg',
    '_wc_review_count' => '0',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'soap',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/10/kennel-n6.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 79,
  'post_date' => '2016-10-04 09:19:28',
  'post_date_gmt' => '2016-10-04 09:19:28',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.',
  'post_title' => 'Cosmetic Brush Set',
  'post_excerpt' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_name' => 'cosmetic-brush-set',
  'post_modified' => '2016-11-07 06:30:11',
  'post_modified_gmt' => '2016-11-07 06:30:11',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=79',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500211:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"ju3p903\\"}],\\"styling\\":[],\\"element_id\\":\\"izep220\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '80',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/cosmetic-brush-set.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '12',
    '_price' => '12',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'cosmetic',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/cosmetic-brush-set.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 76,
  'post_date' => '2016-09-26 09:06:51',
  'post_date_gmt' => '2016-09-26 09:06:51',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.',
  'post_title' => 'Red Nail Paint',
  'post_excerpt' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur. Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.',
  'post_name' => 'red-nail-paint',
  'post_modified' => '2016-11-07 06:30:19',
  'post_modified_gmt' => '2016-11-07 06:30:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=76',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500219:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"emhk110\\"}],\\"styling\\":[],\\"element_id\\":\\"0gz9001\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '77',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/nail-paint.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '15',
    '_price' => '15',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'nail-paint',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/nail-paint.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 74,
  'post_date' => '2016-09-22 09:01:00',
  'post_date_gmt' => '2016-09-22 09:01:00',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.',
  'post_title' => 'Avocado Body Cream',
  'post_excerpt' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_name' => 'avocado-body-cream',
  'post_modified' => '2016-11-07 06:30:26',
  'post_modified_gmt' => '2016-11-07 06:30:26',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=74',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500226:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"nhdm334\\"}],\\"styling\\":[],\\"element_id\\":\\"pp2z330\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '75',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/avocado-cream.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '35',
    '_price' => '35',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'cream',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/avocado-cream.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 72,
  'post_date' => '2016-09-18 08:42:49',
  'post_date_gmt' => '2016-09-18 08:42:49',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.',
  'post_title' => 'Night Cream',
  'post_excerpt' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_name' => 'night-cream-2',
  'post_modified' => '2016-11-07 06:30:32',
  'post_modified_gmt' => '2016-11-07 06:30:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=72',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500232:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"4gds244\\"}],\\"styling\\":[],\\"element_id\\":\\"us0g404\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '73',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/whitening-cream.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '16',
    '_price' => '16',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'cream',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/whitening-cream.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 68,
  'post_date' => '2016-09-11 08:01:21',
  'post_date_gmt' => '2016-09-11 08:01:21',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.',
  'post_title' => 'Waxing Cream',
  'post_excerpt' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_name' => 'waxing-cream',
  'post_modified' => '2016-11-07 06:30:40',
  'post_modified_gmt' => '2016-11-07 06:30:40',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=68',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500240:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"rm7u006\\"}],\\"styling\\":[],\\"element_id\\":\\"ayk1404\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '69',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/waxing-cream.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '35',
    '_price' => '35',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'waxing',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/waxing-cream.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 66,
  'post_date' => '2016-09-09 07:58:29',
  'post_date_gmt' => '2016-09-09 07:58:29',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'White Pearl Soap',
  'post_excerpt' => 'Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_name' => 'white-pearl-soap',
  'post_modified' => '2016-11-07 06:30:48',
  'post_modified_gmt' => '2016-11-07 06:30:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=66',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500248:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"8px6027\\"}],\\"styling\\":[],\\"element_id\\":\\"8h63203\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '67',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/white-pearl-soap.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '55',
    '_sale_price' => '45',
    '_price' => '45',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'soap',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/white-pearl-soap.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 62,
  'post_date' => '2016-09-07 07:46:15',
  'post_date_gmt' => '2016-09-07 07:46:15',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.',
  'post_title' => 'Sunblock Cream',
  'post_excerpt' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat',
  'post_name' => 'sunblock-cream',
  'post_modified' => '2016-11-07 06:30:57',
  'post_modified_gmt' => '2016-11-07 06:30:57',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=62',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500257:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"wmvz040\\"}],\\"styling\\":[],\\"element_id\\":\\"s4ge400\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '63',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/sunblock.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '35',
    '_price' => '35',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'cream',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/sunblock.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 64,
  'post_date' => '2016-09-06 07:48:56',
  'post_date_gmt' => '2016-09-06 07:48:56',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'Whitening Skin Refill Soap',
  'post_excerpt' => 'Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_name' => 'whitening-skin-refill-soap',
  'post_modified' => '2016-11-07 06:31:05',
  'post_modified_gmt' => '2016-11-07 06:31:05',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=64',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500265:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"qywg808\\"}],\\"styling\\":[],\\"element_id\\":\\"bzyu410\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '65',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/skin-whitening-pills.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '78',
    '_price' => '78',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'soap',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/skin-whitening-pills.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 59,
  'post_date' => '2016-09-05 07:43:38',
  'post_date_gmt' => '2016-09-05 07:43:38',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.',
  'post_title' => 'Apple Shampoo',
  'post_excerpt' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?',
  'post_name' => 'apple-shampoo',
  'post_modified' => '2016-11-07 06:31:15',
  'post_modified_gmt' => '2016-11-07 06:31:15',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=59',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500275:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"xpxc705\\"}],\\"styling\\":[],\\"element_id\\":\\"ovb7303\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '60',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/apple-shampoo.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '45',
    '_price' => '45',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'shampoo',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/apple-shampoo.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 57,
  'post_date' => '2016-09-04 07:39:52',
  'post_date_gmt' => '2016-09-04 07:39:52',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.',
  'post_title' => 'Night Cream',
  'post_excerpt' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.',
  'post_name' => 'night-cream',
  'post_modified' => '2016-11-07 06:31:23',
  'post_modified_gmt' => '2016-11-07 06:31:23',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=57',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500283:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"j0j1074\\"}],\\"styling\\":[],\\"element_id\\":\\"mpq9300\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '58',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/facial-cream-2.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '25',
    '_price' => '25',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'cream',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/facial-cream-2.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 89,
  'post_date' => '2016-08-04 16:52:56',
  'post_date_gmt' => '2016-08-04 16:52:56',
  'post_content' => '<div>

Deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum.

</div>',
  'post_title' => 'After Bath Skin Treatment Set',
  'post_excerpt' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum.',
  'post_name' => 'bath-skin-treatment-set',
  'post_modified' => '2016-11-07 06:31:32',
  'post_modified_gmt' => '2016-11-07 06:31:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?post_type=product&#038;p=89',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1478500292:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"6l7n609\\"}],\\"styling\\":[],\\"element_id\\":\\"9n5t006\\"}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '90',
    'post_image' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/afterbath.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '35',
    '_price' => '35',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_tag' => 'cream',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-spa/files/2016/11/afterbath.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 18,
  'post_date' => '2016-11-02 02:42:27',
  'post_date_gmt' => '2016-11-02 02:42:27',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '18',
  'post_modified' => '2016-11-02 02:50:50',
  'post_modified_gmt' => '2016-11-02 02:50:50',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?p=18',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '6',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 17,
  'post_date' => '2016-11-02 02:42:27',
  'post_date_gmt' => '2016-11-02 02:42:27',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '17',
  'post_modified' => '2016-11-02 02:50:50',
  'post_modified_gmt' => '2016-11-02 02:50:50',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?p=17',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '8',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 16,
  'post_date' => '2016-11-02 02:42:27',
  'post_date_gmt' => '2016-11-02 02:42:27',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '16',
  'post_modified' => '2016-11-02 02:50:50',
  'post_modified_gmt' => '2016-11-02 02:50:50',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?p=16',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '10',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 24,
  'post_date' => '2016-11-02 02:50:50',
  'post_date_gmt' => '2016-11-02 02:50:50',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '24',
  'post_modified' => '2016-11-02 02:50:50',
  'post_modified_gmt' => '2016-11-02 02:50:50',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?p=24',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '19',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 15,
  'post_date' => '2016-11-02 02:42:27',
  'post_date_gmt' => '2016-11-02 02:42:27',
  'post_content' => '',
  'post_title' => 'Contact Us',
  'post_excerpt' => '',
  'post_name' => '15',
  'post_modified' => '2016-11-02 02:50:50',
  'post_modified_gmt' => '2016-11-02 02:50:50',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-spa/?p=15',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '11',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );



function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_woocommerce_products" );
$widgets[1002] = array (
  'title' => 'Recent Products',
  'number' => 5,
  'show' => '',
  'orderby' => 'date',
  'order' => 'desc',
  'hide_free' => 0,
  'show_hidden' => 0,
);
update_option( "widget_woocommerce_products", $widgets );

$widgets = get_option( "widget_woocommerce_price_filter" );
$widgets[1003] = array (
  'title' => 'Filter by price',
);
update_option( "widget_woocommerce_price_filter", $widgets );

$widgets = get_option( "widget_woocommerce_product_tag_cloud" );
$widgets[1004] = array (
  'title' => 'Product Tags',
);
update_option( "widget_woocommerce_product_tag_cloud", $widgets );



$sidebars_widgets = array (
  'sidebar-main' => 
  array (
    0 => 'woocommerce_products-1002',
    1 => 'woocommerce_price_filter-1003',
    2 => 'woocommerce_product_tag_cloud-1004',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "main-navigation" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );


$homepage = get_posts( array( 'name' => 'home', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			
	ob_start(); ?>a:118:{s:21:"setting-webfonts_list";s:11:"recommended";s:22:"setting-default_layout";s:8:"sidebar1";s:27:"setting-default_post_layout";s:9:"list-post";s:19:"setting-post_filter";s:3:"yes";s:23:"setting-disable_masonry";s:3:"yes";s:19:"setting-post_gutter";s:6:"gutter";s:30:"setting-default_layout_display";s:7:"content";s:25:"setting-default_more_text";s:4:"More";s:21:"setting-index_orderby";s:4:"date";s:19:"setting-index_order";s:4:"DESC";s:30:"setting-default_media_position";s:5:"above";s:31:"setting-image_post_feature_size";s:5:"blank";s:32:"setting-default_page_post_layout";s:8:"sidebar1";s:37:"setting-default_page_post_layout_type";s:7:"classic";s:42:"setting-default_page_single_media_position";s:5:"above";s:38:"setting-image_post_single_feature_size";s:5:"blank";s:36:"setting-search-result_layout_display";s:7:"content";s:36:"setting-search-result_media_position";s:5:"above";s:27:"setting-default_page_layout";s:8:"sidebar1";s:40:"setting-custom_post_tglobal_style_single";s:8:"sidebar1";s:38:"setting-default_portfolio_index_layout";s:12:"sidebar-none";s:43:"setting-default_portfolio_index_post_layout";s:5:"grid3";s:29:"setting-portfolio_post_filter";s:3:"yes";s:33:"setting-portfolio_disable_masonry";s:3:"yes";s:24:"setting-portfolio_gutter";s:6:"gutter";s:39:"setting-default_portfolio_index_display";s:4:"none";s:50:"setting-default_portfolio_index_post_meta_category";s:3:"yes";s:49:"setting-default_portfolio_index_unlink_post_image";s:3:"yes";s:39:"setting-default_portfolio_single_layout";s:12:"sidebar-none";s:54:"setting-default_portfolio_single_portfolio_layout_type";s:9:"fullwidth";s:50:"setting-default_portfolio_single_unlink_post_image";s:3:"yes";s:22:"themify_portfolio_slug";s:7:"project";s:31:"themify_portfolio_category_slug";s:18:"portfolio-category";s:19:"setting-shop_layout";s:8:"sidebar1";s:27:"setting-shop_archive_layout";s:12:"sidebar-none";s:23:"setting-products_layout";s:5:"grid4";s:31:"setting-product_disable_masonry";s:3:"yes";s:29:"setting-single_product_layout";s:8:"sidebar1";s:30:"setting-related_products_limit";s:1:"3";s:32:"setting-product_description_type";s:4:"long";s:53:"setting-customizer_responsive_design_tablet_landscape";s:4:"1024";s:43:"setting-customizer_responsive_design_tablet";s:3:"768";s:43:"setting-customizer_responsive_design_mobile";s:3:"480";s:33:"setting-mobile_menu_trigger_point";s:4:"1200";s:24:"setting-gallery_lightbox";s:8:"lightbox";s:11:"setting-css";s:3:"top";s:21:"setting-header_design";s:17:"header-horizontal";s:28:"setting-exclude_site_tagline";s:2:"on";s:27:"setting-exclude_search_form";s:2:"on";s:19:"setting_search_form";s:11:"live_search";s:19:"setting-exclude_rss";s:2:"on";s:29:"setting-exclude_social_widget";s:2:"on";s:22:"setting-header_widgets";s:4:"none";s:21:"setting-footer_design";s:12:"footer-block";s:32:"setting-exclude_footer_site_logo";s:2:"on";s:38:"setting-exclude_footer_menu_navigation";s:2:"on";s:22:"setting-use_float_back";s:2:"on";s:22:"setting-footer_widgets";s:17:"footerwidget-1col";s:23:"setting-mega_menu_posts";s:1:"5";s:29:"setting-mega_menu_image_width";s:3:"180";s:30:"setting-mega_menu_image_height";s:3:"120";s:27:"setting-imagefilter_applyto";s:12:"featuredonly";s:29:"setting-color_animation_speed";s:1:"5";s:29:"setting-relationship_taxonomy";s:8:"category";s:37:"setting-relationship_taxonomy_entries";s:1:"3";s:45:"setting-relationship_taxonomy_display_content";s:4:"none";s:30:"setting-single_slider_autoplay";s:3:"off";s:27:"setting-single_slider_speed";s:6:"normal";s:28:"setting-single_slider_effect";s:5:"slide";s:28:"setting-single_slider_height";s:4:"auto";s:18:"setting-more_posts";s:8:"infinite";s:19:"setting-entries_nav";s:8:"numbered";s:24:"setting-footer_text_left";s:48:"<h3>VISIT US</h3>
128 Main Street, Toronto, ON.";s:25:"setting-footer_text_right";s:21:"<h3>416-238-3368</h3>";s:25:"setting-img_php_base_size";s:5:"large";s:27:"setting-global_feature_size";s:5:"blank";s:22:"setting-link_icon_type";s:9:"font-icon";s:32:"setting-link_type_themify-link-0";s:10:"image-icon";s:33:"setting-link_title_themify-link-0";s:7:"Twitter";s:31:"setting-link_img_themify-link-0";s:103:"https://themify.me/demo/themes/ultra-spa/wp-content/themes/themify-ultra/themify/img/social/twitter.png";s:32:"setting-link_type_themify-link-1";s:10:"image-icon";s:33:"setting-link_title_themify-link-1";s:8:"Facebook";s:31:"setting-link_img_themify-link-1";s:104:"https://themify.me/demo/themes/ultra-spa/wp-content/themes/themify-ultra/themify/img/social/facebook.png";s:32:"setting-link_type_themify-link-2";s:10:"image-icon";s:33:"setting-link_title_themify-link-2";s:7:"Google+";s:31:"setting-link_img_themify-link-2";s:107:"https://themify.me/demo/themes/ultra-spa/wp-content/themes/themify-ultra/themify/img/social/google-plus.png";s:32:"setting-link_type_themify-link-3";s:10:"image-icon";s:33:"setting-link_title_themify-link-3";s:7:"YouTube";s:31:"setting-link_img_themify-link-3";s:103:"https://themify.me/demo/themes/ultra-spa/wp-content/themes/themify-ultra/themify/img/social/youtube.png";s:32:"setting-link_type_themify-link-4";s:10:"image-icon";s:33:"setting-link_title_themify-link-4";s:9:"Pinterest";s:31:"setting-link_img_themify-link-4";s:105:"https://themify.me/demo/themes/ultra-spa/wp-content/themes/themify-ultra/themify/img/social/pinterest.png";s:32:"setting-link_type_themify-link-5";s:9:"font-icon";s:33:"setting-link_title_themify-link-5";s:7:"Twitter";s:33:"setting-link_ficon_themify-link-5";s:10:"fa-twitter";s:32:"setting-link_type_themify-link-6";s:9:"font-icon";s:33:"setting-link_title_themify-link-6";s:8:"Facebook";s:33:"setting-link_ficon_themify-link-6";s:11:"fa-facebook";s:32:"setting-link_type_themify-link-7";s:9:"font-icon";s:33:"setting-link_title_themify-link-7";s:7:"Google+";s:33:"setting-link_ficon_themify-link-7";s:14:"fa-google-plus";s:32:"setting-link_type_themify-link-8";s:9:"font-icon";s:33:"setting-link_title_themify-link-8";s:7:"YouTube";s:33:"setting-link_ficon_themify-link-8";s:10:"fa-youtube";s:32:"setting-link_type_themify-link-9";s:9:"font-icon";s:33:"setting-link_title_themify-link-9";s:9:"Pinterest";s:33:"setting-link_ficon_themify-link-9";s:12:"fa-pinterest";s:22:"setting-link_field_ids";s:341:"{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-4":"themify-link-4","themify-link-5":"themify-link-5","themify-link-6":"themify-link-6","themify-link-7":"themify-link-7","themify-link-8":"themify-link-8","themify-link-9":"themify-link-9"}";s:23:"setting-link_field_hash";s:2:"10";s:30:"setting-page_builder_is_active";s:6:"enable";s:41:"setting-page_builder_animation_appearance";s:4:"none";s:42:"setting-page_builder_animation_parallax_bg";s:4:"none";s:44:"setting-page_builder_animation_scroll_effect";s:4:"none";s:44:"setting-page_builder_animation_sticky_scroll";s:4:"none";s:26:"setting-page_builder_cache";s:2:"on";s:27:"setting-page_builder_expiry";s:1:"2";s:4:"skin";s:3:"spa";s:13:"import_images";s:2:"on";}<?php $themify_data = unserialize( ob_get_clean() );

	// Fix how "skin" option used to save
	if( isset( $themify_data['skin'] ) ) {
		if ( filter_var( $themify_data['skin'], FILTER_VALIDATE_URL ) ) {
			$parsed_skin = parse_url( $value, PHP_URL_PATH );
			$themify_data['skin'] = basename( dirname( $parsed_skin ) );
		}
	}

	themify_set_data( $themify_data );
	
}
themify_do_demo_import();