<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;
		$upload = wp_upload_bits( $post['post_name'] . '.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post['post_mime_type'] = $info['type'];
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$post_id = wp_insert_attachment( $post, $upload['file'] );
		wp_update_attachment_metadata( $post_id, wp_generate_attachment_metadata( $post_id, $upload['file'] ) );

		$placeholder_image = $post_id;
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if( ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 2,
  'name' => 'News',
  'slug' => 'news',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 3,
  'name' => 'Business',
  'slug' => 'business',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 4,
  'name' => 'Sports',
  'slug' => 'sports',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 5,
  'name' => 'Tech',
  'slug' => 'tech',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 6,
  'name' => 'Health',
  'slug' => 'health',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 7,
  'name' => 'Culture',
  'slug' => 'culture',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 8,
  'name' => 'Main Navigation',
  'slug' => 'main-navigation',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 9,
  'name' => 'Footer Widget 1',
  'slug' => 'footer-widget-1',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 10,
  'name' => 'Footer Widget 2',
  'slug' => 'footer-widget-2',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 11,
  'name' => 'Footer Widget 3',
  'slug' => 'footer-widget-3',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 12,
  'name' => 'Footer Widget 4',
  'slug' => 'footer-widget-4',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 8,
  'post_date' => '2019-05-02 03:18:38',
  'post_date_gmt' => '2019-05-02 03:18:38',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur. Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae.</p>
<!-- /wp:paragraph -->',
  'post_title' => 'Japan’s Emperor Akihito Abdicates Throne, the First in 200 years',
  'post_excerpt' => '',
  'post_name' => 'japans-emperor-akihito-abdicates-throne-the-first-in-200-years',
  'post_modified' => '2019-07-25 02:50:29',
  'post_modified_gmt' => '2019-07-25 02:50:29',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=8',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/05/japan.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 58,
  'post_date' => '2019-04-30 03:51:57',
  'post_date_gmt' => '2019-04-30 03:51:57',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”&nbsp; repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.</p>
<!-- /wp:paragraph -->',
  'post_title' => 'Pilots Demand Better Training for Boeing 737 MAX',
  'post_excerpt' => '',
  'post_name' => 'pilots-demand-better-training-for-boeing-737-max',
  'post_modified' => '2019-05-21 20:05:38',
  'post_modified_gmt' => '2019-05-21 20:05:38',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=58',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'business',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/05/pilot-cabin.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 16,
  'post_date' => '2019-04-29 03:22:11',
  'post_date_gmt' => '2019-04-29 03:22:11',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam.</p>
<!-- /wp:paragraph -->',
  'post_title' => 'Magic Leaves Lakers, LeBron Is Not Happy',
  'post_excerpt' => '',
  'post_name' => 'magic-leaves-lakers-lebron-is-not-happy',
  'post_modified' => '2019-05-21 05:37:59',
  'post_modified_gmt' => '2019-05-21 05:37:59',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=16',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'sports',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/04/james-lebron.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 20,
  'post_date' => '2019-04-28 03:23:39',
  'post_date_gmt' => '2019-04-28 03:23:39',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.<br>Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.</p>
<!-- /wp:paragraph -->',
  'post_title' => 'How to Speed Up Your Smart Phone',
  'post_excerpt' => '',
  'post_name' => 'how-to-speed-up-your-smart-phone',
  'post_modified' => '2019-05-21 06:04:12',
  'post_modified_gmt' => '2019-05-21 06:04:12',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=20',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'tech',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/05/speed-up-smartphone.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 25,
  'post_date' => '2019-04-26 03:36:19',
  'post_date_gmt' => '2019-04-26 03:36:19',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”&nbsp; repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.</p>
<!-- /wp:paragraph -->',
  'post_title' => 'Congo Ebola Cases Hit Record Day Report',
  'post_excerpt' => '',
  'post_name' => 'congo-ebola-cases-hit-record-day-report',
  'post_modified' => '2019-05-21 05:38:44',
  'post_modified_gmt' => '2019-05-21 05:38:44',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=25',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'health',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/04/ebola.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 30,
  'post_date' => '2019-04-25 03:36:59',
  'post_date_gmt' => '2019-04-25 03:36:59',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.<br></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Mauris pulvinar, massa eget semper imperdiet, sapien nisl vulputate mi, ut commodo mi erat et sapien. Interdum et malesuada fames ac ante ipsum primis in faucibus. Curabitur pellentesque augue nec nisl ultricies aliquet. Integer ipsum ante, interdum ac varius quis, ullamcorper vel ante.Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Donec eu mi vitae ex aliquam porttitor. Donec a mi in mauris finibus venenatis vitae at augue. Maecenas non pulvinar purus. Vestibulum posuere faucibus libero, eu dapibus magna mollis quis. Etiam non ante urna. Curabitur tincidunt ultrices sagittis. Donec quis felis leo. Cras ullamcorper, est eget convallis dapibus, diam lacus viverra magna, volutpat maximus lorem urna ac purus. Nam felis metus, eleifend ut fringilla a, sagittis nec mauris. In id congue justo.</p>
<!-- /wp:paragraph -->',
  'post_title' => 'Avengers: Endgame Reaches Over the $1 Billion Mark',
  'post_excerpt' => '',
  'post_name' => 'avengers-endgame-reaches-over-the-1-billion-mark',
  'post_modified' => '2019-05-21 05:38:41',
  'post_modified_gmt' => '2019-05-21 05:38:41',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=30',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'culture',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/04/avenger.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 33,
  'post_date' => '2019-04-24 03:39:06',
  'post_date_gmt' => '2019-04-24 03:39:06',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>In consequat rutrum nisl quis condimentum. Sed eget tincidunt nulla, posuere elementum ligula. Nulla facilisi. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatemPraesent luctus, neque dictum feugiat maximus, sem enim maximus ipsum, sed ullamcorper est urna suscipit massa. Cras commodo eros nec eleifend vehicula. Praesent auctor augue in massa porta gravida. Nullam et ex eget diam mollis hendrerit id dignissim sem. Suspendisse viverra nibh a fringilla viverra.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Nulla tortor ex, sodales id mollis ac, feugiat sit amet leo. Suspendisse porttitor laoreet neque, et bibendum lacus euismod id. In tincidunt, tortor vel fringilla elementum, magna purus lacinia ante, id egestas nisi justo vel eros. Pellentesque orci lorem, accumsan sed aliquam sed, pretium sed nunc. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Maecenas consequat, justo sed rutrum sollicitudin, velit ante ultricies ante, et euismod arcu purus et leo. Morbi pretium non ex ut volutpat. Lorem ipsum dolor sit amet, consectetur adipiscing elit. In consequat rutrum nisl quis condimentum. Sed eget tincidunt nulla, posuere elementum ligula. Nulla facilisi. Praesent luctus, neque dictum feugiat maximus, sem enim maximus ipsum, sed ullamcorper est urna suscipit massa. Cras commodo eros nec eleifend vehicula. Praesent auctor augue in massa porta gravida. Nullam et ex eget diam mollis hendrerit id dignissim sem. Suspendisse viverra nibh a fringilla viverra.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Donec vitae volutpat erat. Donec non molestie lacus. Integer euismod leo euismod, fermentum tellus sed, consequat leo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem Cras lobortis nisl non dapibus tempor. Donec a finibus tellus. Vivamus laoreet lacinia imperdiet. Fusce tincidunt metus ac sapien feugiat, sit amet laoreet lorem aliquam. Integer pharetra egestas mi vel aliquam.</p>
<!-- /wp:paragraph -->',
  'post_title' => 'What is Happening in Venezuela is Important',
  'post_excerpt' => '',
  'post_name' => 'what-is-happening-in-venezuela-is-important',
  'post_modified' => '2019-05-21 06:04:10',
  'post_modified_gmt' => '2019-05-21 06:04:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=33',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/05/venezuela.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 36,
  'post_date' => '2019-04-23 03:40:02',
  'post_date_gmt' => '2019-04-23 03:40:02',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.&nbsp;Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.</p>
<!-- /wp:paragraph -->',
  'post_title' => '5G Technology is Coming with an Increase in Your Wireless Bills',
  'post_excerpt' => '',
  'post_name' => '5g-technology-is-coming-with-an-increase-in-your-wireless-bills',
  'post_modified' => '2019-05-21 05:39:59',
  'post_modified_gmt' => '2019-05-21 05:39:59',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=36',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'business',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/04/5g-network.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 39,
  'post_date' => '2019-04-22 03:40:54',
  'post_date_gmt' => '2019-04-22 03:40:54',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”&nbsp; repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam.</p>
<!-- /wp:paragraph -->',
  'post_title' => 'Giannis Antetokounmpo Looks Human in Game 1',
  'post_excerpt' => '',
  'post_name' => 'giannis-antetokounmpo-looks-human-in-game-1',
  'post_modified' => '2019-05-21 05:39:56',
  'post_modified_gmt' => '2019-05-21 05:39:56',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=39',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'sports',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/04/giannis-antetokounmpo.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 42,
  'post_date' => '2019-04-21 03:42:34',
  'post_date_gmt' => '2019-04-21 03:42:34',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.<br></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.<br>Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.</p>
<!-- /wp:paragraph -->',
  'post_title' => 'What You Can Expect if Instagram Starts Hiding Likes',
  'post_excerpt' => '',
  'post_name' => 'what-you-can-expect-if-instagram-starts-hiding-likes',
  'post_modified' => '2019-05-21 05:39:52',
  'post_modified_gmt' => '2019-05-21 05:39:52',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=42',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'tech',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/04/instagram-hiding-likes.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 45,
  'post_date' => '2019-04-19 03:44:35',
  'post_date_gmt' => '2019-04-19 03:44:35',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>Labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatu.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis.</p>
<!-- /wp:paragraph -->',
  'post_title' => 'This Summer’s Ticks and Mosquito Rates to Surge',
  'post_excerpt' => '',
  'post_name' => '%e2%80%a2this-summers-ticks-and-mosquito-rates-to-surge',
  'post_modified' => '2019-05-21 06:04:08',
  'post_modified_gmt' => '2019-05-21 06:04:08',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=45',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'health',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/05/mosquito.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 52,
  'post_date' => '2019-04-18 03:46:02',
  'post_date_gmt' => '2019-04-18 03:46:02',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>Mauris pulvinar, massa eget semper imperdiet, sapien nisl vulputate mi, ut commodo mi erat et sapien. Interdum et malesuada fames ac ante ipsum primis in faucibus. Curabitur pellentesque augue nec nisl ultricies aliquet. Integer ipsum ante, interdum ac varius quis, ullamcorper vel ante.Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Donec eu mi vitae ex aliquam porttitor. Donec a mi in mauris finibus venenatis vitae at augue. Maecenas non pulvinar purus. Vestibulum posuere faucibus libero, eu dapibus magna mollis quis. Etiam non ante urna. Curabitur tincidunt ultrices sagittis. Donec quis felis leo. Cras ullamcorper, est eget convallis dapibus, diam lacus viverra magna, volutpat maximus lorem urna ac purus. Nam felis metus, eleifend ut fringilla a, sagittis nec mauris. In id congue justo.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.&nbsp;Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.</p>
<!-- /wp:paragraph -->',
  'post_title' => 'The Obamas Latest Presidency, A Production Company Called Higher Ground',
  'post_excerpt' => '',
  'post_name' => 'the-obamas-latest-presidency-a-production-company-called-higher-ground',
  'post_modified' => '2019-05-21 06:04:04',
  'post_modified_gmt' => '2019-05-21 06:04:04',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=52',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'culture',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/05/obama.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 55,
  'post_date' => '2019-04-15 03:51:10',
  'post_date_gmt' => '2019-04-15 03:51:10',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. &nbsp;Ton provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?&nbsp;Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.</p>
<!-- /wp:paragraph -->',
  'post_title' => 'Sri Lanka’s Youngest Generation’s Trauma Post Easter Attacks',
  'post_excerpt' => '',
  'post_name' => 'sri-lankas-youngest-generations-trauma-post-easter-attacks',
  'post_modified' => '2019-05-21 06:04:02',
  'post_modified_gmt' => '2019-05-21 06:04:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=55',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/05/srilanka-youth.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 11,
  'post_date' => '2019-04-13 03:19:00',
  'post_date_gmt' => '2019-04-13 03:19:00',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>In consequat rutrum nisl quis condimentum. Sed eget tincidunt nulla, posuere elementum ligula. Nulla facilisi. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatemPraesent luctus, neque dictum feugiat maximus, sem enim maximus ipsum, sed ullamcorper est urna suscipit massa. Cras commodo eros nec eleifend vehicula. Praesent auctor augue in massa porta gravida. Nullam et ex eget diam mollis hendrerit id dignissim sem. Suspendisse viverra nibh a fringilla viverra.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Nulla tortor ex, sodales id mollis ac, feugiat sit amet leo. Suspendisse porttitor laoreet neque, et bibendum lacus euismod id. In tincidunt, tortor vel fringilla elementum, magna purus lacinia ante, id egestas nisi justo vel eros. Pellentesque orci lorem, accumsan sed aliquam sed, pretium sed nunc. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Maecenas consequat, justo sed rutrum sollicitudin, velit ante ultricies ante, et euismod arcu purus et leo. Morbi pretium non ex ut volutpat. Lorem ipsum dolor sit amet, consectetur adipiscing elit. In consequat rutrum nisl quis condimentum. Sed eget tincidunt nulla, posuere elementum ligula. Nulla facilisi. Praesent luctus, neque dictum feugiat maximus, sem enim maximus ipsum, sed ullamcorper est urna suscipit massa. Cras commodo eros nec eleifend vehicula. Praesent auctor augue in massa porta gravida. Nullam et ex eget diam mollis hendrerit id dignissim sem. Suspendisse viverra nibh a fringilla viverra.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Donec vitae volutpat erat. Donec non molestie lacus. Integer euismod leo euismod, fermentum tellus sed, consequat leo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem Cras lobortis nisl non dapibus tempor. Donec a finibus tellus. Vivamus laoreet lacinia imperdiet. Fusce tincidunt metus ac sapien feugiat, sit amet laoreet lorem aliquam. Integer pharetra egestas mi vel aliquam.</p>
<!-- /wp:paragraph -->',
  'post_title' => 'Canada’s Viola Desmond $10 Bill Wins International Banknote of the Year',
  'post_excerpt' => '',
  'post_name' => 'canadas-viola-desmond-10-bill-wins-international-banknote-of-the-year',
  'post_modified' => '2019-05-21 20:05:44',
  'post_modified_gmt' => '2019-05-21 20:05:44',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=11',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'business',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/04/canadian-dollar.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 69,
  'post_date' => '2019-04-12 03:56:25',
  'post_date_gmt' => '2019-04-12 03:56:25',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.&nbsp;Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.</p>
<!-- /wp:paragraph -->',
  'post_title' => 'Spotify Hits 100 Million Subscribers',
  'post_excerpt' => '',
  'post_name' => 'spotify-hits-100-million-subscribers',
  'post_modified' => '2019-05-21 05:39:49',
  'post_modified_gmt' => '2019-05-21 05:39:49',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=69',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'tech',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/04/spotify.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 61,
  'post_date' => '2019-04-11 03:53:04',
  'post_date_gmt' => '2019-04-11 03:53:04',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”&nbsp; repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.

</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p> Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates. </p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.</p>
<!-- /wp:paragraph -->',
  'post_title' => 'Leafs Suffer Major Upset, After Leading Series 3-1',
  'post_excerpt' => '',
  'post_name' => 'leafs-suffer-major-upset-after-leading-series-3-1',
  'post_modified' => '2019-05-21 06:03:59',
  'post_modified_gmt' => '2019-05-21 06:03:59',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=61',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'sports',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/05/maple-leaf.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 76,
  'post_date' => '2019-04-10 03:58:30',
  'post_date_gmt' => '2019-04-10 03:58:30',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur. Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae.</p>
<!-- /wp:paragraph -->',
  'post_title' => 'Game of Thrones: Winter is Here and Records are Broken',
  'post_excerpt' => '',
  'post_name' => 'game-of-thrones-winter-is-here-and-records-are-broken',
  'post_modified' => '2019-05-21 06:03:59',
  'post_modified_gmt' => '2019-05-21 06:03:59',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=76',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'culture',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/05/game-of-thrones.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 72,
  'post_date' => '2019-04-10 03:57:14',
  'post_date_gmt' => '2019-04-10 03:57:14',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p>Labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.</p>
<!-- /wp:paragraph -->',
  'post_title' => 'WHO Advises Zero Screen Time for Children 1-5',
  'post_excerpt' => '',
  'post_name' => 'who-advises-zero-screen-time-for-children-1-5',
  'post_modified' => '2019-05-21 06:03:56',
  'post_modified_gmt' => '2019-05-21 06:03:56',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=72',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'health',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-magazine/files/2019/04/baby.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 79,
  'post_date' => '2019-05-02 04:01:26',
  'post_date_gmt' => '2019-05-02 04:01:26',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static-->


<a href="https://themify.me/themes/ultra" > <img src="https://themify.me/demo/themes/ultra-magazine/files/2019/05/ads-banner-250-250x250.jpg" width="250" alt="ads-banner-250" srcset="https://themify.me/demo/themes/ultra-magazine/files/2019/05/ads-banner-250.jpg 250w, https://themify.me/demo/themes/ultra-magazine/files/2019/05/ads-banner-250-150x150.jpg 150w" sizes="(max-width: 250px) 100vw, 250px" /> </a>
<h3>Latest<br/></h3>


<a href="https://themify.me/themes/ultra" > <img src="https://themify.me/demo/themes/ultra-magazine/files/2019/05/ads-banner-336-336x280.jpg" width="336" alt="ads--banner-336" /> </a>
<h3>Most Popular<br/></h3>
<ul><li><a href="https://themify.me/demo/themes/ultra-magazine/2019/05/02/japans-emperor-akihito-abdicates-throne-the-first-in-200-years/"><img src="https://themify.me/demo/themes/ultra-magazine/files/2019/05/japan-1600x900-50x50.jpg" width="50" height="50" alt="japan" srcset="https://themify.me/demo/themes/ultra-magazine/files/2019/05/japan-1600x900-50x50.jpg 50w, https://themify.me/demo/themes/ultra-magazine/files/2019/05/japan-150x150.jpg 150w, https://themify.me/demo/themes/ultra-magazine/files/2019/05/japan-1600x900-70x70.jpg 70w" sizes="(max-width: 50px) 100vw, 50px" /></a><a href="https://themify.me/demo/themes/ultra-magazine/2019/05/02/japans-emperor-akihito-abdicates-throne-the-first-in-200-years/">Japan’s Emperor Akihito Abdicates Throne, the First in 200 years</a></li><li><a href="https://themify.me/demo/themes/ultra-magazine/2019/04/10/game-of-thrones-winter-is-here-and-records-are-broken/"><img src="https://themify.me/demo/themes/ultra-magazine/files/2019/05/game-of-thrones-1600x900-50x50.jpg" width="50" height="50" alt="game-of-thrones" srcset="https://themify.me/demo/themes/ultra-magazine/files/2019/05/game-of-thrones-1600x900-50x50.jpg 50w, https://themify.me/demo/themes/ultra-magazine/files/2019/05/game-of-thrones-150x150.jpg 150w" sizes="(max-width: 50px) 100vw, 50px" /></a><a href="https://themify.me/demo/themes/ultra-magazine/2019/04/10/game-of-thrones-winter-is-here-and-records-are-broken/">Game of Thrones: Winter is Here and Records are Broken</a></li><li><a href="https://themify.me/demo/themes/ultra-magazine/2019/04/11/leafs-suffer-major-upset-after-leading-series-3-1/"><img src="https://themify.me/demo/themes/ultra-magazine/files/2019/05/maple-leaf-1600x900-50x50.jpg" width="50" height="50" alt="maple-leaf" srcset="https://themify.me/demo/themes/ultra-magazine/files/2019/05/maple-leaf-1600x900-50x50.jpg 50w, https://themify.me/demo/themes/ultra-magazine/files/2019/05/maple-leaf-150x150.jpg 150w" sizes="(max-width: 50px) 100vw, 50px" /></a><a href="https://themify.me/demo/themes/ultra-magazine/2019/04/11/leafs-suffer-major-upset-after-leading-series-3-1/">Leafs Suffer Major Upset, After Leading Series 3-1</a></li><li><a href="https://themify.me/demo/themes/ultra-magazine/2019/04/12/spotify-hits-100-million-subscribers/"><img src="https://themify.me/demo/themes/ultra-magazine/files/2019/04/spotify-1600x900-50x50.jpg" width="50" height="50" alt="spotify" srcset="https://themify.me/demo/themes/ultra-magazine/files/2019/04/spotify-1600x900-50x50.jpg 50w, https://themify.me/demo/themes/ultra-magazine/files/2019/04/spotify-150x150.jpg 150w" sizes="(max-width: 50px) 100vw, 50px" /></a><a href="https://themify.me/demo/themes/ultra-magazine/2019/04/12/spotify-hits-100-million-subscribers/">Spotify Hits 100 Million Subscribers</a></li><li><a href="https://themify.me/demo/themes/ultra-magazine/2019/04/14/pilots-demand-better-training-for-boeing-737-max/"><img src="https://themify.me/demo/themes/ultra-magazine/files/2019/05/pilot-cabin-1600x900-50x50.jpg" width="50" height="50" alt="pilot-cabin" srcset="https://themify.me/demo/themes/ultra-magazine/files/2019/05/pilot-cabin-1600x900-50x50.jpg 50w, https://themify.me/demo/themes/ultra-magazine/files/2019/05/pilot-cabin-150x150.jpg 150w" sizes="(max-width: 50px) 100vw, 50px" /></a><a href="https://themify.me/demo/themes/ultra-magazine/2019/04/14/pilots-demand-better-training-for-boeing-737-max/">Pilots Demand Better Training for Boeing 737 MAX</a></li></ul>
<h3>Health<br/></h3>


<h3>Culture<br/></h3>


<h3>News<br/></h3>

<!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2019-05-21 20:04:47',
  'post_modified_gmt' => '2019-05-21 20:04:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?page_id=79',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"o4jo661\\",\\"cols\\":[{\\"element_id\\":\\"71f5663\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"y17t926\\",\\"mod_settings\\":{\\"layout_post\\":\\"list-post\\",\\"post_per_page_post\\":\\"2\\",\\"display_post\\":\\"none\\",\\"hide_page_nav_post\\":\\"yes\\",\\"post_type_post\\":\\"post\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_post_date_post\\":\\"no\\",\\"unlink_post_title_post\\":\\"no\\",\\"hide_post_title_post\\":\\"no\\",\\"unlink_feat_img_post\\":\\"no\\",\\"hide_feat_img_post\\":\\"no\\",\\"orderby_post\\":\\"date\\",\\"order_post\\":\\"desc\\",\\"post_filter\\":\\"no\\",\\"category_post\\":\\"business|single\\",\\"term_type\\":\\"category\\",\\"type_query_post\\":\\"category\\",\\"img_height_post\\":\\"200\\",\\"img_width_post\\":\\"275\\",\\"auto_fullwidth_post\\":\\"1\\"}}]},{\\"element_id\\":\\"kf13456\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"18n7963\\",\\"mod_settings\\":{\\"layout_post\\":\\"list-post\\",\\"post_per_page_post\\":\\"1\\",\\"display_post\\":\\"excerpt\\",\\"hide_page_nav_post\\":\\"yes\\",\\"post_type_post\\":\\"post\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_post_date_post\\":\\"no\\",\\"unlink_post_title_post\\":\\"no\\",\\"hide_post_title_post\\":\\"no\\",\\"unlink_feat_img_post\\":\\"no\\",\\"hide_feat_img_post\\":\\"no\\",\\"orderby_post\\":\\"date\\",\\"order_post\\":\\"desc\\",\\"post_filter\\":\\"no\\",\\"category_post\\":\\"culture|single\\",\\"term_type\\":\\"category\\",\\"type_query_post\\":\\"category\\",\\"auto_fullwidth_post\\":\\"1\\"}}]},{\\"element_id\\":\\"8b3z457\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"0079331\\",\\"mod_settings\\":{\\"layout_post\\":\\"list-post\\",\\"post_per_page_post\\":\\"3\\",\\"display_post\\":\\"none\\",\\"hide_page_nav_post\\":\\"yes\\",\\"post_type_post\\":\\"post\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_post_date_post\\":\\"no\\",\\"unlink_post_title_post\\":\\"no\\",\\"hide_post_title_post\\":\\"no\\",\\"unlink_feat_img_post\\":\\"no\\",\\"hide_feat_img_post\\":\\"yes\\",\\"orderby_post\\":\\"date\\",\\"order_post\\":\\"desc\\",\\"post_filter\\":\\"no\\",\\"category_post\\":\\"culture|single\\",\\"term_type\\":\\"category\\",\\"type_query_post\\":\\"category\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"b7h6431\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/themes\\\\/ultra\\",\\"width_image\\":\\"250\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-magazine\\\\/files\\\\/2019\\\\/05\\\\/ads-banner-250.jpg\\",\\"style_image\\":\\"image-center\\"}}]}]},{\\"element_id\\":\\"o8nv443\\",\\"cols\\":[{\\"element_id\\":\\"fz1w444\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"kzgl213\\",\\"mod_settings\\":{\\"heading\\":\\"Latest\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h3\\"}},{\\"element_id\\":\\"4h24201\\",\\"cols\\":[{\\"element_id\\":\\"9067203\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"z0q7937\\",\\"mod_settings\\":{\\"layout_post\\":\\"list-post\\",\\"post_per_page_post\\":\\"1\\",\\"display_post\\":\\"none\\",\\"hide_page_nav_post\\":\\"yes\\",\\"post_type_post\\":\\"post\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_post_date_post\\":\\"no\\",\\"unlink_post_title_post\\":\\"no\\",\\"hide_post_title_post\\":\\"no\\",\\"unlink_feat_img_post\\":\\"no\\",\\"hide_feat_img_post\\":\\"no\\",\\"orderby_post\\":\\"date\\",\\"order_post\\":\\"desc\\",\\"post_filter\\":\\"no\\",\\"category_post\\":\\"culture|single\\",\\"term_type\\":\\"category\\",\\"type_query_post\\":\\"category\\",\\"auto_fullwidth_post\\":\\"1\\"}}]},{\\"element_id\\":\\"e34m204\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"d0sb905\\",\\"mod_settings\\":{\\"layout_post\\":\\"list-post\\",\\"post_per_page_post\\":\\"1\\",\\"display_post\\":\\"none\\",\\"hide_page_nav_post\\":\\"yes\\",\\"post_type_post\\":\\"post\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_post_date_post\\":\\"no\\",\\"unlink_post_title_post\\":\\"no\\",\\"hide_post_title_post\\":\\"no\\",\\"unlink_feat_img_post\\":\\"no\\",\\"hide_feat_img_post\\":\\"no\\",\\"orderby_post\\":\\"date\\",\\"order_post\\":\\"desc\\",\\"post_filter\\":\\"no\\",\\"category_post\\":\\"news|single\\",\\"term_type\\":\\"category\\",\\"type_query_post\\":\\"category\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"hr07774\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"336\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-magazine\\\\/files\\\\/2019\\\\/05\\\\/ads-banner-336.jpg\\",\\"style_image\\":\\"image-top\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/themes\\\\/ultra\\",\\"breakpoint_mobile\\":{\\"margin_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"10\\"}}}]}]}]},{\\"element_id\\":\\"o80f835\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"pfo4865\\",\\"mod_settings\\":{\\"heading\\":\\"Most Popular\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h3\\"}},{\\"mod_name\\":\\"widget\\",\\"element_id\\":\\"qdmx564\\",\\"mod_settings\\":{\\"instance_widget\\":{\\"show_count\\":\\"5\\",\\"show_thumb\\":\\"on\\",\\"thumb_width\\":\\"50\\",\\"thumb_height\\":\\"50\\",\\"excerpt_length\\":\\"55\\",\\"widget-id\\":\\"1557453492\\"},\\"class_widget\\":\\"Themify_Most_Commented\\"}}]}],\\"styling\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"7\\",\\"breakpoint_mobile\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"7\\",\\"padding_top\\":\\"12\\"}}},{\\"element_id\\":\\"t53l21\\",\\"cols\\":[{\\"element_id\\":\\"5ejg21\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"axxb952\\",\\"mod_settings\\":{\\"heading\\":\\"Health\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h3\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"hejp385\\",\\"mod_settings\\":{\\"layout_post\\":\\"list-post\\",\\"post_per_page_post\\":\\"1\\",\\"display_post\\":\\"excerpt\\",\\"hide_page_nav_post\\":\\"yes\\",\\"post_type_post\\":\\"post\\",\\"hide_post_meta_post\\":\\"no\\",\\"hide_post_date_post\\":\\"no\\",\\"unlink_post_title_post\\":\\"no\\",\\"hide_post_title_post\\":\\"no\\",\\"unlink_feat_img_post\\":\\"no\\",\\"hide_feat_img_post\\":\\"no\\",\\"orderby_post\\":\\"date\\",\\"order_post\\":\\"desc\\",\\"post_filter\\":\\"no\\",\\"category_post\\":\\"health|single\\",\\"term_type\\":\\"category\\",\\"type_query_post\\":\\"category\\",\\"img_height_post\\":\\"240\\",\\"img_width_post\\":\\"364\\",\\"auto_fullwidth_post\\":\\"1\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"jvln661\\",\\"mod_settings\\":{\\"layout_post\\":\\"list-post\\",\\"post_per_page_post\\":\\"3\\",\\"display_post\\":\\"none\\",\\"hide_page_nav_post\\":\\"yes\\",\\"post_type_post\\":\\"post\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_post_date_post\\":\\"no\\",\\"unlink_post_title_post\\":\\"no\\",\\"hide_post_title_post\\":\\"no\\",\\"unlink_feat_img_post\\":\\"no\\",\\"hide_feat_img_post\\":\\"yes\\",\\"orderby_post\\":\\"date\\",\\"order_post\\":\\"desc\\",\\"post_filter\\":\\"no\\",\\"category_post\\":\\"health|single\\",\\"term_type\\":\\"category\\",\\"type_query_post\\":\\"category\\"}}]},{\\"element_id\\":\\"xync22\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"86be997\\",\\"mod_settings\\":{\\"heading\\":\\"Culture\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h3\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"nzbf464\\",\\"mod_settings\\":{\\"layout_post\\":\\"list-post\\",\\"post_per_page_post\\":\\"1\\",\\"display_post\\":\\"excerpt\\",\\"hide_page_nav_post\\":\\"yes\\",\\"post_type_post\\":\\"post\\",\\"hide_post_meta_post\\":\\"no\\",\\"hide_post_date_post\\":\\"no\\",\\"unlink_post_title_post\\":\\"no\\",\\"hide_post_title_post\\":\\"no\\",\\"unlink_feat_img_post\\":\\"no\\",\\"hide_feat_img_post\\":\\"no\\",\\"orderby_post\\":\\"date\\",\\"order_post\\":\\"desc\\",\\"post_filter\\":\\"no\\",\\"category_post\\":\\"culture|single\\",\\"term_type\\":\\"category\\",\\"type_query_post\\":\\"category\\",\\"img_height_post\\":\\"240\\",\\"img_width_post\\":\\"364\\",\\"auto_fullwidth_post\\":\\"1\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"hx1w123\\",\\"mod_settings\\":{\\"layout_post\\":\\"list-post\\",\\"post_per_page_post\\":\\"3\\",\\"display_post\\":\\"none\\",\\"hide_page_nav_post\\":\\"yes\\",\\"post_type_post\\":\\"post\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_post_date_post\\":\\"no\\",\\"unlink_post_title_post\\":\\"no\\",\\"hide_post_title_post\\":\\"no\\",\\"unlink_feat_img_post\\":\\"no\\",\\"hide_feat_img_post\\":\\"yes\\",\\"orderby_post\\":\\"date\\",\\"order_post\\":\\"desc\\",\\"post_filter\\":\\"no\\",\\"category_post\\":\\"culture|single\\",\\"term_type\\":\\"category\\",\\"type_query_post\\":\\"category\\"}}]},{\\"element_id\\":\\"38yb23\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"ufnc860\\",\\"mod_settings\\":{\\"heading\\":\\"News\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h3\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"86il369\\",\\"mod_settings\\":{\\"layout_post\\":\\"list-post\\",\\"post_per_page_post\\":\\"1\\",\\"display_post\\":\\"excerpt\\",\\"hide_page_nav_post\\":\\"yes\\",\\"post_type_post\\":\\"post\\",\\"hide_post_meta_post\\":\\"no\\",\\"hide_post_date_post\\":\\"no\\",\\"unlink_post_title_post\\":\\"no\\",\\"hide_post_title_post\\":\\"no\\",\\"unlink_feat_img_post\\":\\"no\\",\\"hide_feat_img_post\\":\\"no\\",\\"orderby_post\\":\\"date\\",\\"order_post\\":\\"desc\\",\\"post_filter\\":\\"no\\",\\"category_post\\":\\"news|single\\",\\"term_type\\":\\"category\\",\\"type_query_post\\":\\"category\\",\\"img_height_post\\":\\"240\\",\\"img_width_post\\":\\"364\\",\\"auto_fullwidth_post\\":\\"1\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"0pmu971\\",\\"mod_settings\\":{\\"layout_post\\":\\"list-post\\",\\"post_per_page_post\\":\\"3\\",\\"display_post\\":\\"none\\",\\"hide_page_nav_post\\":\\"yes\\",\\"post_type_post\\":\\"post\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_post_date_post\\":\\"no\\",\\"unlink_post_title_post\\":\\"no\\",\\"hide_post_title_post\\":\\"no\\",\\"unlink_feat_img_post\\":\\"no\\",\\"hide_feat_img_post\\":\\"yes\\",\\"orderby_post\\":\\"date\\",\\"order_post\\":\\"desc\\",\\"post_filter\\":\\"no\\",\\"category_post\\":\\"news|single\\",\\"term_type\\":\\"category\\",\\"type_query_post\\":\\"category\\"}}]}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 181,
  'post_date' => '2019-05-14 16:40:21',
  'post_date_gmt' => '2019-05-14 16:40:21',
  'post_content' => '',
  'post_title' => 'About',
  'post_excerpt' => '',
  'post_name' => 'about',
  'post_modified' => '2019-05-21 16:21:24',
  'post_modified_gmt' => '2019-05-21 16:21:24',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=181',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '181',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-1',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 182,
  'post_date' => '2019-05-14 16:40:21',
  'post_date_gmt' => '2019-05-14 16:40:21',
  'post_content' => '',
  'post_title' => 'Engadget',
  'post_excerpt' => '',
  'post_name' => 'engadget',
  'post_modified' => '2019-05-21 16:21:24',
  'post_modified_gmt' => '2019-05-21 16:21:24',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=182',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '182',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/tech/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-1',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 184,
  'post_date' => '2019-05-14 16:40:21',
  'post_date_gmt' => '2019-05-14 16:40:21',
  'post_content' => '',
  'post_title' => 'Our Ads',
  'post_excerpt' => '',
  'post_name' => 'our-ads',
  'post_modified' => '2019-05-21 16:21:24',
  'post_modified_gmt' => '2019-05-21 16:21:24',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=184',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '184',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-1',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 186,
  'post_date' => '2019-05-14 16:40:21',
  'post_date_gmt' => '2019-05-14 16:40:21',
  'post_content' => '',
  'post_title' => 'Brand Kit',
  'post_excerpt' => '',
  'post_name' => 'brand-kit',
  'post_modified' => '2019-05-21 16:21:24',
  'post_modified_gmt' => '2019-05-21 16:21:24',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=186',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '186',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/tech/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-1',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 185,
  'post_date' => '2019-05-14 16:40:21',
  'post_date_gmt' => '2019-05-14 16:40:21',
  'post_content' => '',
  'post_title' => 'Advertise',
  'post_excerpt' => '',
  'post_name' => 'advertise',
  'post_modified' => '2019-05-21 16:21:24',
  'post_modified_gmt' => '2019-05-21 16:21:24',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=185',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '185',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-1',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 187,
  'post_date' => '2019-05-14 16:40:21',
  'post_date_gmt' => '2019-05-14 16:40:21',
  'post_content' => '',
  'post_title' => 'Buyers Guide',
  'post_excerpt' => '',
  'post_name' => 'buyers-guide',
  'post_modified' => '2019-05-21 16:21:24',
  'post_modified_gmt' => '2019-05-21 16:21:24',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=187',
  'menu_order' => 6,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '187',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/tech/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-1',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 188,
  'post_date' => '2019-05-14 16:40:21',
  'post_date_gmt' => '2019-05-14 16:40:21',
  'post_content' => '',
  'post_title' => 'Contact Us',
  'post_excerpt' => '',
  'post_name' => 'contact-us',
  'post_modified' => '2019-05-21 16:21:24',
  'post_modified_gmt' => '2019-05-21 16:21:24',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=188',
  'menu_order' => 7,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '188',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-1',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 298,
  'post_date' => '2019-05-21 16:15:13',
  'post_date_gmt' => '2019-05-21 16:15:13',
  'post_content' => '',
  'post_title' => 'World',
  'post_excerpt' => '',
  'post_name' => 'world',
  'post_modified' => '2019-05-21 16:15:35',
  'post_modified_gmt' => '2019-05-21 16:15:35',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=298',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '298',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/news/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-2',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 299,
  'post_date' => '2019-05-21 16:15:13',
  'post_date_gmt' => '2019-05-21 16:15:13',
  'post_content' => '',
  'post_title' => 'US',
  'post_excerpt' => '',
  'post_name' => 'us',
  'post_modified' => '2019-05-21 16:15:35',
  'post_modified_gmt' => '2019-05-21 16:15:35',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=299',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '299',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/news/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-2',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 300,
  'post_date' => '2019-05-21 16:15:13',
  'post_date_gmt' => '2019-05-21 16:15:13',
  'post_content' => '',
  'post_title' => 'Politics',
  'post_excerpt' => '',
  'post_name' => 'politics',
  'post_modified' => '2019-05-21 16:15:35',
  'post_modified_gmt' => '2019-05-21 16:15:35',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=300',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '300',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/news/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-2',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 301,
  'post_date' => '2019-05-21 16:15:13',
  'post_date_gmt' => '2019-05-21 16:15:13',
  'post_content' => '',
  'post_title' => 'Business',
  'post_excerpt' => '',
  'post_name' => 'business',
  'post_modified' => '2019-05-21 16:15:35',
  'post_modified_gmt' => '2019-05-21 16:15:35',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=301',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '301',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/news/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-2',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 302,
  'post_date' => '2019-05-21 16:15:13',
  'post_date_gmt' => '2019-05-21 16:15:13',
  'post_content' => '',
  'post_title' => 'Tech',
  'post_excerpt' => '',
  'post_name' => 'tech',
  'post_modified' => '2019-05-21 16:15:35',
  'post_modified_gmt' => '2019-05-21 16:15:35',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=302',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '302',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/news/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-2',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 303,
  'post_date' => '2019-05-21 16:15:13',
  'post_date_gmt' => '2019-05-21 16:15:13',
  'post_content' => '',
  'post_title' => 'Science',
  'post_excerpt' => '',
  'post_name' => 'science',
  'post_modified' => '2019-05-21 16:15:35',
  'post_modified_gmt' => '2019-05-21 16:15:35',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=303',
  'menu_order' => 6,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '303',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/news/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-2',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 304,
  'post_date' => '2019-05-21 16:15:14',
  'post_date_gmt' => '2019-05-21 16:15:14',
  'post_content' => '',
  'post_title' => 'Sports',
  'post_excerpt' => '',
  'post_name' => 'sports',
  'post_modified' => '2019-05-21 16:15:35',
  'post_modified_gmt' => '2019-05-21 16:15:35',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=304',
  'menu_order' => 7,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '304',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/news/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-2',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 196,
  'post_date' => '2019-05-14 16:48:24',
  'post_date_gmt' => '2019-05-14 16:48:24',
  'post_content' => '',
  'post_title' => 'Review',
  'post_excerpt' => '',
  'post_name' => 'review',
  'post_modified' => '2019-05-21 16:17:38',
  'post_modified_gmt' => '2019-05-21 16:17:38',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=196',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '196',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/tech/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-3',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 197,
  'post_date' => '2019-05-14 16:48:24',
  'post_date_gmt' => '2019-05-14 16:48:24',
  'post_content' => '',
  'post_title' => 'Gear',
  'post_excerpt' => '',
  'post_name' => 'gear',
  'post_modified' => '2019-05-21 16:17:38',
  'post_modified_gmt' => '2019-05-21 16:17:38',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=197',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '197',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/tech/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-3',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 198,
  'post_date' => '2019-05-14 16:48:24',
  'post_date_gmt' => '2019-05-14 16:48:24',
  'post_content' => '',
  'post_title' => 'Gaming',
  'post_excerpt' => '',
  'post_name' => 'gaming',
  'post_modified' => '2019-05-21 16:17:38',
  'post_modified_gmt' => '2019-05-21 16:17:38',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=198',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '198',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/tech/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-3',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 199,
  'post_date' => '2019-05-14 16:48:24',
  'post_date_gmt' => '2019-05-14 16:48:24',
  'post_content' => '',
  'post_title' => 'Multimedia',
  'post_excerpt' => '',
  'post_name' => 'multimedia',
  'post_modified' => '2019-05-21 16:17:38',
  'post_modified_gmt' => '2019-05-21 16:17:38',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=199',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '199',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/tech/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-3',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 200,
  'post_date' => '2019-05-14 16:48:24',
  'post_date_gmt' => '2019-05-14 16:48:24',
  'post_content' => '',
  'post_title' => 'Entertainment',
  'post_excerpt' => '',
  'post_name' => 'entertainment',
  'post_modified' => '2019-05-21 16:17:38',
  'post_modified_gmt' => '2019-05-21 16:17:38',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=200',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '200',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/tech/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-3',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 201,
  'post_date' => '2019-05-14 16:48:24',
  'post_date_gmt' => '2019-05-14 16:48:24',
  'post_content' => '',
  'post_title' => 'Lifestyle',
  'post_excerpt' => '',
  'post_name' => 'lifestyle',
  'post_modified' => '2019-05-21 16:17:38',
  'post_modified_gmt' => '2019-05-21 16:17:38',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=201',
  'menu_order' => 6,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '201',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/tech/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-3',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 202,
  'post_date' => '2019-05-14 16:48:24',
  'post_date_gmt' => '2019-05-14 16:48:24',
  'post_content' => '',
  'post_title' => 'Social',
  'post_excerpt' => '',
  'post_name' => 'social',
  'post_modified' => '2019-05-21 16:17:38',
  'post_modified_gmt' => '2019-05-21 16:17:38',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=202',
  'menu_order' => 7,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '202',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/tech/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-3',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 203,
  'post_date' => '2019-05-14 16:51:20',
  'post_date_gmt' => '2019-05-14 16:51:20',
  'post_content' => '',
  'post_title' => 'Music',
  'post_excerpt' => '',
  'post_name' => 'music',
  'post_modified' => '2019-05-21 16:18:32',
  'post_modified_gmt' => '2019-05-21 16:18:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=203',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '203',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/culture/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-4',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 204,
  'post_date' => '2019-05-14 16:51:20',
  'post_date_gmt' => '2019-05-14 16:51:20',
  'post_content' => '',
  'post_title' => 'Movies',
  'post_excerpt' => '',
  'post_name' => 'movies',
  'post_modified' => '2019-05-21 16:18:32',
  'post_modified_gmt' => '2019-05-21 16:18:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=204',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '204',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/culture/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-4',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 205,
  'post_date' => '2019-05-14 16:51:20',
  'post_date_gmt' => '2019-05-14 16:51:20',
  'post_content' => '',
  'post_title' => 'Fashion',
  'post_excerpt' => '',
  'post_name' => 'fashion',
  'post_modified' => '2019-05-21 16:18:32',
  'post_modified_gmt' => '2019-05-21 16:18:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=205',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '205',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/culture/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-4',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 206,
  'post_date' => '2019-05-14 16:51:20',
  'post_date_gmt' => '2019-05-14 16:51:20',
  'post_content' => '',
  'post_title' => 'Humor',
  'post_excerpt' => '',
  'post_name' => 'humor',
  'post_modified' => '2019-05-21 16:18:32',
  'post_modified_gmt' => '2019-05-21 16:18:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=206',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '206',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/culture/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-4',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 207,
  'post_date' => '2019-05-14 16:51:20',
  'post_date_gmt' => '2019-05-14 16:51:20',
  'post_content' => '',
  'post_title' => 'Entertainment',
  'post_excerpt' => '',
  'post_name' => 'entertainment-2',
  'post_modified' => '2019-05-21 16:18:32',
  'post_modified_gmt' => '2019-05-21 16:18:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=207',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '207',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/culture/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-4',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 208,
  'post_date' => '2019-05-14 16:51:20',
  'post_date_gmt' => '2019-05-14 16:51:20',
  'post_content' => '',
  'post_title' => 'Critics',
  'post_excerpt' => '',
  'post_name' => 'critics',
  'post_modified' => '2019-05-21 16:18:32',
  'post_modified_gmt' => '2019-05-21 16:18:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=208',
  'menu_order' => 6,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '208',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/culture/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-4',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 209,
  'post_date' => '2019-05-14 16:51:20',
  'post_date_gmt' => '2019-05-14 16:51:20',
  'post_content' => '',
  'post_title' => 'Cultural Comments',
  'post_excerpt' => '',
  'post_name' => 'cultural-comments',
  'post_modified' => '2019-05-21 16:18:32',
  'post_modified_gmt' => '2019-05-21 16:18:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=209',
  'menu_order' => 7,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '209',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-magazine/category/culture/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-widget-4',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 88,
  'post_date' => '2019-05-02 07:24:36',
  'post_date_gmt' => '2019-05-02 07:24:36',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '88',
  'post_modified' => '2019-05-02 07:24:36',
  'post_modified_gmt' => '2019-05-02 07:24:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=88',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'taxonomy',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '3',
    '_menu_item_object' => 'category',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 92,
  'post_date' => '2019-05-02 07:24:36',
  'post_date_gmt' => '2019-05-02 07:24:36',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '92',
  'post_modified' => '2019-05-02 07:24:36',
  'post_modified_gmt' => '2019-05-02 07:24:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=92',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'taxonomy',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '7',
    '_menu_item_object' => 'category',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 87,
  'post_date' => '2019-05-02 07:24:36',
  'post_date_gmt' => '2019-05-02 07:24:36',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '87',
  'post_modified' => '2019-05-02 07:24:36',
  'post_modified_gmt' => '2019-05-02 07:24:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=87',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'taxonomy',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '2',
    '_menu_item_object' => 'category',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 89,
  'post_date' => '2019-05-02 07:24:36',
  'post_date_gmt' => '2019-05-02 07:24:36',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '89',
  'post_modified' => '2019-05-02 07:24:36',
  'post_modified_gmt' => '2019-05-02 07:24:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=89',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'taxonomy',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '4',
    '_menu_item_object' => 'category',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 90,
  'post_date' => '2019-05-02 07:24:36',
  'post_date_gmt' => '2019-05-02 07:24:36',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '90',
  'post_modified' => '2019-05-02 07:24:36',
  'post_modified_gmt' => '2019-05-02 07:24:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=90',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'taxonomy',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '5',
    '_menu_item_object' => 'category',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 91,
  'post_date' => '2019-05-02 07:24:36',
  'post_date_gmt' => '2019-05-02 07:24:36',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '91',
  'post_modified' => '2019-05-02 07:24:36',
  'post_modified_gmt' => '2019-05-02 07:24:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-magazine/?p=91',
  'menu_order' => 6,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'taxonomy',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '6',
    '_menu_item_object' => 'category',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );



function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_custom_html" );
$widgets[1002] = array (
  'title' => '',
  'content' => '<a href="https://themify.me/themes/ultra"><img src="https://themify.me/demo/themes/ultra-magazine/files/2019/05/ads-banner-336.jpg" alt="Ads"></a>',
);
update_option( "widget_custom_html", $widgets );

$widgets = get_option( "widget_themify-feature-posts" );
$widgets[1003] = array (
  'title' => 'Recent Posts',
  'category' => '0',
  'show_count' => '5',
  'display' => 'none',
  'thumb_width' => '70',
  'thumb_height' => '70',
  'excerpt_length' => '55',
  'orderby' => 'date',
  'order' => 'DESC',
  'show_thumb' => 'on',
);
update_option( "widget_themify-feature-posts", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1004] = array (
  'title' => 'Newsletter',
  'text' => 'Receive the latest and greatest by subscribing to our newsletter
<div id="mc_embed_signup"><form id="mc-embedded-subscribe-form" class="validate" action="//themify.us2.list-manage.com/subscribe/post?u=03462cf158e86ea00590274ab&amp;id=0f2a95e5de" method="post" name="mc-embedded-subscribe-form" novalidate="" target="_blank">
<div id="mc_embed_signup_scroll">
<div class="mc-field-group"><input id="mce-EMAIL" class="required email" name="EMAIL" type="email" value="" />
<input id="mc-embedded-subscribe" class="button" name="subscribe" type="submit" value="Subscribe" /></div>
<div id="mce-responses" class="clear">
<div id="mce-error-response" class="response" style="display: none;"></div>
<div id="mce-success-response" class="response" style="display: none;"></div>
</div>
<!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups-->
<div style="position: absolute; left: -5000px;" aria-hidden="true"><input tabindex="-1" name="b_03462cf158e86ea00590274ab_0f2a95e5de" type="text" value="" /></div>
</div>
</form></div>
<script type=\'text/javascript\' src=\'//s3.amazonaws.com/downloads.mailchimp.com/js/mc-validate.js\'></script><script type=\'text/javascript\'>(function($) {window.fnames = new Array(); window.ftypes = new Array();fnames[0]=\'EMAIL\';ftypes[0]=\'email\';fnames[1]=\'FNAME\';ftypes[1]=\'text\';fnames[2]=\'LNAME\';ftypes[2]=\'text\';fnames[5]=\'HOMEPAGE\';ftypes[5]=\'text\';}(jQuery));var $mcj = jQuery.noConflict(true);</script>',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_themify-twitter" );
$widgets[1005] = array (
  'title' => 'Latest Tweets',
  'username' => 'themify',
  'type' => '0',
  'timeline_height' => '400',
  'timeline_width' => '300',
  'show_count' => '5',
  'hide_timestamp' => NULL,
  'grid_embed_code' => '',
  'hide_footer' => NULL,
  'show_follow' => NULL,
  'follow_text' => '→ Follow me',
  'include_retweets' => NULL,
  'exclude_replies' => NULL,
);
update_option( "widget_themify-twitter", $widgets );

$widgets = get_option( "widget_search" );
$widgets[1006] = array (
  'title' => '',
);
update_option( "widget_search", $widgets );

$widgets = get_option( "widget_themify-social-links" );
$widgets[1007] = array (
  'title' => '',
  'show_link_name' => 'on',
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1008] = array (
  'title' => 'About',
  'nav_menu' => themify_import_get_term_id_from_slug( "footer-widget-1" ),
);
update_option( "widget_nav_menu", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1009] = array (
  'title' => 'News',
  'nav_menu' => themify_import_get_term_id_from_slug( "footer-widget-2" ),
);
update_option( "widget_nav_menu", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1010] = array (
  'title' => 'Technology',
  'nav_menu' => themify_import_get_term_id_from_slug( "footer-widget-3" ),
);
update_option( "widget_nav_menu", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1011] = array (
  'title' => 'Culture',
  'nav_menu' => themify_import_get_term_id_from_slug( "footer-widget-4" ),
);
update_option( "widget_nav_menu", $widgets );



$sidebars_widgets = array (
  'sidebar-main' => 
  array (
    0 => 'custom_html-1002',
    1 => 'themify-feature-posts-1003',
    2 => 'text-1004',
    3 => 'themify-twitter-1005',
  ),
  'header-widget-1' => 
  array (
    0 => 'search-1006',
  ),
  'header-widget-2' => 
  array (
    0 => 'themify-social-links-1007',
  ),
  'footer-widget-1' => 
  array (
    0 => 'nav_menu-1008',
  ),
  'footer-widget-2' => 
  array (
    0 => 'nav_menu-1009',
  ),
  'footer-widget-3' => 
  array (
    0 => 'nav_menu-1010',
  ),
  'footer-widget-4' => 
  array (
    0 => 'nav_menu-1011',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "main-navigation" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );


$homepage = get_posts( array( 'name' => 'home', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			
	ob_start(); ?>a:107:{s:21:"setting-webfonts_list";s:11:"recommended";s:22:"setting-default_layout";s:12:"sidebar-none";s:27:"setting-default_post_layout";s:5:"grid3";s:19:"setting-post_filter";s:2:"no";s:23:"setting-disable_masonry";s:3:"yes";s:19:"setting-post_gutter";s:6:"gutter";s:30:"setting-default_layout_display";s:7:"excerpt";s:25:"setting-default_more_text";s:4:"More";s:21:"setting-index_orderby";s:4:"date";s:19:"setting-index_order";s:4:"DESC";s:30:"setting-default_media_position";s:5:"above";s:31:"setting-image_post_feature_size";s:5:"blank";s:24:"setting-image_post_width";s:3:"364";s:25:"setting-image_post_height";s:3:"240";s:32:"setting-default_page_post_layout";s:8:"sidebar1";s:37:"setting-default_page_post_layout_type";s:7:"classic";s:42:"setting-default_page_single_media_position";s:5:"above";s:38:"setting-image_post_single_feature_size";s:5:"blank";s:36:"setting-search-result_layout_display";s:7:"content";s:36:"setting-search-result_media_position";s:5:"above";s:27:"setting-default_page_layout";s:8:"sidebar1";s:40:"setting-custom_post_tglobal_style_single";s:8:"sidebar1";s:38:"setting-default_portfolio_index_layout";s:12:"sidebar-none";s:43:"setting-default_portfolio_index_post_layout";s:5:"grid3";s:29:"setting-portfolio_post_filter";s:3:"yes";s:33:"setting-portfolio_disable_masonry";s:3:"yes";s:24:"setting-portfolio_gutter";s:6:"gutter";s:39:"setting-default_portfolio_index_display";s:4:"none";s:50:"setting-default_portfolio_index_post_meta_category";s:3:"yes";s:49:"setting-default_portfolio_index_unlink_post_image";s:3:"yes";s:39:"setting-default_portfolio_single_layout";s:12:"sidebar-none";s:54:"setting-default_portfolio_single_portfolio_layout_type";s:9:"fullwidth";s:50:"setting-default_portfolio_single_unlink_post_image";s:3:"yes";s:22:"themify_portfolio_slug";s:7:"project";s:31:"themify_portfolio_category_slug";s:18:"portfolio-category";s:53:"setting-customizer_responsive_design_tablet_landscape";s:4:"1280";s:43:"setting-customizer_responsive_design_tablet";s:3:"768";s:43:"setting-customizer_responsive_design_mobile";s:3:"680";s:33:"setting-mobile_menu_trigger_point";s:3:"900";s:24:"setting-gallery_lightbox";s:8:"lightbox";s:21:"setting-header_design";s:18:"header-top-widgets";s:28:"setting-exclude_site_tagline";s:2:"on";s:27:"setting-exclude_search_form";s:2:"on";s:19:"setting_search_form";s:11:"live_search";s:19:"setting-exclude_rss";s:2:"on";s:29:"setting-exclude_social_widget";s:2:"on";s:22:"setting-header_widgets";s:17:"headerwidget-2col";s:21:"setting-footer_design";s:22:"footer-horizontal-left";s:32:"setting-exclude_footer_site_logo";s:2:"on";s:38:"setting-exclude_footer_menu_navigation";s:2:"on";s:22:"setting-use_float_back";s:2:"on";s:22:"setting-footer_widgets";s:17:"footerwidget-4col";s:30:"setting-footer_widget_position";s:3:"top";s:23:"setting-mega_menu_posts";s:1:"5";s:29:"setting-mega_menu_image_width";s:3:"180";s:30:"setting-mega_menu_image_height";s:3:"120";s:27:"setting-imagefilter_applyto";s:12:"featuredonly";s:29:"setting-color_animation_speed";s:1:"5";s:29:"setting-relationship_taxonomy";s:8:"category";s:37:"setting-relationship_taxonomy_entries";s:1:"3";s:45:"setting-relationship_taxonomy_display_content";s:4:"none";s:30:"setting-single_slider_autoplay";s:3:"off";s:27:"setting-single_slider_speed";s:6:"normal";s:28:"setting-single_slider_effect";s:5:"slide";s:28:"setting-single_slider_height";s:4:"auto";s:18:"setting-more_posts";s:8:"infinite";s:19:"setting-entries_nav";s:8:"numbered";s:25:"setting-img_php_base_size";s:5:"large";s:27:"setting-global_feature_size";s:5:"blank";s:22:"setting-link_icon_type";s:9:"font-icon";s:32:"setting-link_type_themify-link-0";s:10:"image-icon";s:33:"setting-link_title_themify-link-0";s:7:"Twitter";s:31:"setting-link_img_themify-link-0";s:108:"https://themify.me/demo/themes/ultra-magazine/wp-content/themes/themify-ultra/themify/img/social/twitter.png";s:32:"setting-link_type_themify-link-1";s:10:"image-icon";s:33:"setting-link_title_themify-link-1";s:8:"Facebook";s:31:"setting-link_img_themify-link-1";s:109:"https://themify.me/demo/themes/ultra-magazine/wp-content/themes/themify-ultra/themify/img/social/facebook.png";s:32:"setting-link_type_themify-link-2";s:10:"image-icon";s:33:"setting-link_title_themify-link-2";s:7:"YouTube";s:31:"setting-link_img_themify-link-2";s:108:"https://themify.me/demo/themes/ultra-magazine/wp-content/themes/themify-ultra/themify/img/social/youtube.png";s:32:"setting-link_type_themify-link-3";s:10:"image-icon";s:33:"setting-link_title_themify-link-3";s:9:"Pinterest";s:31:"setting-link_img_themify-link-3";s:110:"https://themify.me/demo/themes/ultra-magazine/wp-content/themes/themify-ultra/themify/img/social/pinterest.png";s:32:"setting-link_type_themify-link-4";s:9:"font-icon";s:33:"setting-link_title_themify-link-4";s:7:"Twitter";s:32:"setting-link_link_themify-link-4";s:27:"https://twitter.com/themify";s:33:"setting-link_ficon_themify-link-4";s:10:"fa-twitter";s:32:"setting-link_type_themify-link-5";s:9:"font-icon";s:33:"setting-link_title_themify-link-5";s:8:"Facebook";s:32:"setting-link_link_themify-link-5";s:28:"https://facebook.com/themify";s:33:"setting-link_ficon_themify-link-5";s:11:"fa-facebook";s:32:"setting-link_type_themify-link-6";s:9:"font-icon";s:33:"setting-link_title_themify-link-6";s:7:"YouTube";s:32:"setting-link_link_themify-link-6";s:38:"https://www.youtube.com/user/themifyme";s:33:"setting-link_ficon_themify-link-6";s:10:"fa-youtube";s:32:"setting-link_type_themify-link-7";s:9:"font-icon";s:33:"setting-link_title_themify-link-7";s:9:"Pinterest";s:33:"setting-link_ficon_themify-link-7";s:12:"fa-pinterest";s:22:"setting-link_field_ids";s:273:"{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-4":"themify-link-4","themify-link-5":"themify-link-5","themify-link-6":"themify-link-6","themify-link-7":"themify-link-7"}";s:23:"setting-link_field_hash";s:1:"8";s:30:"setting-page_builder_is_active";s:6:"enable";s:41:"setting-page_builder_animation_appearance";s:4:"none";s:42:"setting-page_builder_animation_parallax_bg";s:4:"none";s:44:"setting-page_builder_animation_scroll_effect";s:4:"none";s:44:"setting-page_builder_animation_sticky_scroll";s:4:"none";s:27:"setting-page_builder_expiry";s:1:"2";s:4:"skin";s:8:"magazine";s:13:"import_images";s:2:"on";}<?php $themify_data = unserialize( ob_get_clean() );

	themify_set_data( $themify_data );
	
}
themify_do_demo_import();